/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.deploy.internal;

import java.util.Set;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IWeblogicDeploymentPlan;
import oracle.eclipse.tools.weblogic.server.internal.util.FacetUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;

public class ModuleNameValuesProvider
extends PossibleValuesService {
    public Status.Severity getInvalidValueSeverity(String invalidValue) {
        IFile workspaceFile = (IFile)((Element)this.context(Element.class)).adapt(IFile.class);
        if (workspaceFile == null) {
            return Status.Severity.WARNING;
        }
        return Status.Severity.ERROR;
    }

    protected void fillPossibleValues(Set<String> values) {
        IWeblogicDeploymentPlan plan = (IWeblogicDeploymentPlan)this.context(IWeblogicDeploymentPlan.class);
        IProject project = (IProject)plan.adapt(IProject.class);
        if (project == null) {
            return;
        }
        this.addModulesFromProject(plan, project, values);
    }

    private void addModulesFromProject(IWeblogicDeploymentPlan plan, IProject proj, Set<String> set) {
        try {
            if (!proj.isOpen()) {
                return;
            }
            if (this.isSupportedProject(proj)) {
                if (FacetedProjectFramework.hasProjectFacet((IProject)proj, (String)"jst.ear")) {
                    IVirtualReference[] refs;
                    IVirtualComponent comp = ComponentCore.createComponent((IProject)proj);
                    String ext = FacetUtil.getResourceExtension(proj);
                    set.add(String.valueOf(comp.getDeployedName()) + ext);
                    IVirtualReference[] iVirtualReferenceArray = refs = comp.getReferences();
                    int n = refs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IVirtualReference ref = iVirtualReferenceArray[n2];
                        String name = ref.getArchiveName();
                        set.add(name);
                        ++n2;
                    }
                } else if (FacetedProjectFramework.hasProjectFacet((IProject)proj, (String)"jst.web") || FacetedProjectFramework.hasProjectFacet((IProject)proj, (String)"jst.ejb")) {
                    IVirtualComponent comp = ComponentCore.createComponent((IProject)proj);
                    String ext = FacetUtil.getResourceExtension(proj);
                    set.add(String.valueOf(comp.getDeployedName()) + ext);
                }
            } else {
                IProject project;
                String appName = plan.getApplicationName().text();
                if (appName == null) {
                    return;
                }
                String projectName = appName.indexOf(46) > 0 ? appName.substring(0, appName.lastIndexOf(46)) : appName;
                IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(projectName);
                if (res instanceof IProject && this.isSupportedProject(project = (IProject)res)) {
                    this.addModulesFromProject(plan, project, set);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private boolean isSupportedProject(IProject proj) {
        IRuntimeComponentVersion rv = WlsRuntimeUtil.getWlsRuntimeVersion(proj);
        return rv != null;
    }
}

