/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.deploy.internal;

import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IModuleOverride;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IWeblogicDeploymentPlan;
import oracle.eclipse.tools.weblogic.server.internal.util.FacetUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;

public class ModuleNameChangeListener
extends FilteredListener<PropertyContentEvent> {
    protected void handleTypedEvent(PropertyContentEvent event) {
        IModuleOverride module = (IModuleOverride)event.property().element();
        String moduleName = module.getModuleName().text();
        if (moduleName != null && moduleName.length() > 0) {
            IWeblogicDeploymentPlan plan = (IWeblogicDeploymentPlan)module.nearest(IWeblogicDeploymentPlan.class);
            IProject proj = (IProject)plan.adapt(IProject.class);
            if (proj == null) {
                return;
            }
            try {
                String appName = plan.getApplicationName().text();
                if (appName != null) {
                    String projectName = appName.indexOf(46) > 0 ? appName.substring(0, appName.lastIndexOf(46)) : appName;
                    String moduleType = this.findModuleTypeInProject(proj, projectName, moduleName);
                    module.setModuleType(moduleType);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private String findModuleTypeInProject(IProject proj, String appName, String moduleName) throws CoreException {
        IVirtualComponent comp = ComponentCore.createComponent((IProject)proj);
        if (comp != null) {
            String ext = FacetUtil.getResourceExtension(comp.getProject());
            if (moduleName.equals(String.valueOf(comp.getDeployedName()) + ext)) {
                return this.getModuleType(comp.getProject());
            }
            if (FacetedProjectFramework.hasProjectFacet((IProject)proj, (String)"jst.ear")) {
                IVirtualReference[] refs;
                IVirtualReference[] iVirtualReferenceArray = refs = comp.getReferences();
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    IVirtualReference ref = iVirtualReferenceArray[n2];
                    IVirtualComponent refComp = ref.getReferencedComponent();
                    if (moduleName.equals(ref.getArchiveName()) && !refComp.isBinary()) {
                        return this.getModuleType(refComp.getProject());
                    }
                    ++n2;
                }
            }
        } else {
            IProject project;
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(appName);
            if (res instanceof IProject && this.isSupportedProject(project = (IProject)res)) {
                return this.findModuleTypeInProject(project, appName, moduleName);
            }
        }
        return null;
    }

    private boolean isSupportedProject(IProject proj) {
        IRuntimeComponentVersion rv = WlsRuntimeUtil.getWlsRuntimeVersion(proj);
        return rv != null;
    }

    private String getModuleType(IProject proj) throws CoreException {
        if (FacetedProjectFramework.hasProjectFacet((IProject)proj, (String)"jst.ear")) {
            return "ear";
        }
        if (FacetedProjectFramework.hasProjectFacet((IProject)proj, (String)"jst.web")) {
            return "war";
        }
        if (FacetedProjectFramework.hasProjectFacet((IProject)proj, (String)"jst.ejb")) {
            return "ejb";
        }
        return null;
    }
}

