/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.deploy;

import oracle.eclipse.tools.weblogic.descriptors.IWebLogicDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.common.internal.WebLogicDescriptorRootElementController;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IModuleOverride;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IVariableDefinition;
import oracle.eclipse.tools.weblogic.descriptors.deploy.internal.ApplicationNameValuesProvider;
import oracle.eclipse.tools.weblogic.descriptors.deploy.internal.DeployPlanWlsVersionDefaultValueProvider;
import oracle.eclipse.tools.weblogic.descriptors.deploy.internal.WebLogicServerVersionValuesProvider;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.annotations.AbsolutePath;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlRootBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

@CustomXmlRootBinding(value=WebLogicDescriptorRootElementController.class)
public interface IWeblogicDeploymentPlan
extends IWebLogicDescriptor {
    public static final String CONTENT_TYPE_ID = "oracle.eclipse.tools.weblogic.descriptors.DeploymentPlan";
    public static final String ATTR_GLOBAL_VARIABLES = "global-variables";
    public static final ElementType TYPE = new ElementType(IWeblogicDeploymentPlan.class);
    @XmlBinding(path="%weblogic-version")
    @Services(value={@Service(impl=WebLogicServerVersionValuesProvider.class), @Service(impl=DeployPlanWlsVersionDefaultValueProvider.class)})
    public static final ValueProperty PROP_SERVER_VERSION = new ValueProperty(TYPE, IWebLogicDescriptor.PROP_SERVER_VERSION);
    @XmlBinding(path="description")
    @Documentation(content="A textual description of the plan document.", topics={@Documentation.Topic(label="WebLogic Deployment Plan Editor Tutorial", url="oracle.eclipse.tools.weblogic.doc/html/deployplan/tutorial.html")})
    public static final ValueProperty PROP_DESCRIPTION = new ValueProperty(TYPE, IWebLogicDescriptor.PROP_DESCRIPTION);
    @XmlBinding(path="application-name")
    @Label(standard="application name")
    @Service(impl=ApplicationNameValuesProvider.class)
    @Required
    @Documentation(content="A name associated with the application. This value may be used as the application's deployed name if not provided through deployment options.")
    public static final ValueProperty PROP_APPLICATION_NAME = new ValueProperty(TYPE, "ApplicationName");
    @XmlBinding(path="version")
    @Label(standard="plan version")
    @Documentation(content="The plan's version. This will also be incorporated into the deployed application's name.")
    public static final ValueProperty PROP_VERSION = new ValueProperty(TYPE, "Version");
    @Type(base=Path.class)
    @XmlBinding(path="config-root")
    @Label(standard="external config root")
    @ValidFileSystemResourceType(value=FileSystemResourceType.FOLDER)
    @AbsolutePath
    @Documentation(content="Location of the external descriptors associated with the plan.")
    public static final ValueProperty PROP_CONFIG_ROOT = new ValueProperty(TYPE, "ConfigRoot");
    @Type(base=IVariableDefinition.class)
    @XmlBinding(path="variable-definition")
    public static final ImpliedElementProperty PROP_VARIABLE_DEFINITION = new ImpliedElementProperty(TYPE, "VariableDefinition");
    @Label(standard="module override")
    @Type(base=IModuleOverride.class)
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="module-override", type=IModuleOverride.class)})
    public static final ListProperty PROP_MODULE_OVERRIDE = new ListProperty(TYPE, "ModuleOverride");

    public Value<String> getApplicationName();

    public void setApplicationName(String var1);

    public Value<String> getVersion();

    public void setVersion(String var1);

    public Value<Path> getConfigRoot();

    public void setConfigRoot(String var1);

    public void setConfigRoot(Path var1);

    public IVariableDefinition getVariableDefinition();

    public ElementList<IModuleOverride> getModuleOverride();
}

