/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.common.internal;

import oracle.eclipse.tools.weblogic.WebLogicDescriptorInfo;
import oracle.eclipse.tools.weblogic.WebLogicDescriptorType;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicDescriptor;
import oracle.eclipse.tools.weblogic.facets.CoreWlsExtensionFacetsGroup;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public final class WebLogicServerVersionValidationService
extends ValidationService {
    @Text(value="\"{0}\" is not a supported WebLogic Server version")
    private static LocalizableText versionNotSupportedMessage;
    @Text(value="Descriptor namespace does not match the server version")
    private static LocalizableText namespaceDoesNotMatchMessage;
    @Text(value="Server version does not match the version of {0} facet")
    private static LocalizableText facetDoesNotMatchMessage;
    @Text(value="Schema location declaration was not found or is incorrect")
    private static LocalizableText schemaLocationDeclNotFoundMessage;
    public static final String TYPE_VERSION_NOT_SUPPORTED = "Oracle.WebLogicServer.Tools.VersionNotSupported";
    public static final String TYPE_NAMESPACE_DOES_NOT_MATCH = "Oracle.WebLogicServer.Tools.NamespaceDoesNotMatch";
    public static final String TYPE_INVALID_SCHEMA_LOCATION = "Oracle.WebLogicServer.Tools.InvalidSchemaLocation";
    public static final String TYPE_FACET_DOES_NOT_MATCH = "Oracle.WebLogicServer.Tools.FacetDoesNotMatch";

    static {
        LocalizableText.init(WebLogicServerVersionValidationService.class);
    }

    protected Status compute() {
        IProjectFacetVersion fv;
        IProject project;
        WebLogicDescriptorInfo dinfo;
        WebLogicServerVersion mver;
        Value value = (Value)this.context(Value.class);
        Version ver = (Version)value.content(false);
        if (ver != null && ((mver = WebLogicServerVersion.convert(ver)) == null || mver.compareTo(WebLogicServerVersion.VERSION_9_2) < 0)) {
            String msg = versionNotSupportedMessage.format(new Object[]{value.text(false)});
            return Status.factoryForLeaf().severity(Status.Severity.ERROR).message(msg).type(TYPE_VERSION_NOT_SUPPORTED).create();
        }
        WebLogicServerVersion version = WebLogicServerVersion.convert((Version)value.content());
        IWebLogicDescriptor descriptor = (IWebLogicDescriptor)value.element().nearest(IWebLogicDescriptor.class);
        WebLogicDescriptorType descriptorType = WebLogicDescriptorType.getDescriptorType(descriptor);
        XmlElement root = ((XmlResource)descriptor.adapt(XmlResource.class)).getXmlElement(false);
        if (root != null && (dinfo = descriptorType.getDescriptorInfo(version)) != null) {
            String expectedNamespace;
            String currentNamespace = root.getNamespace();
            if (!currentNamespace.equals(expectedNamespace = dinfo.getNamespace())) {
                return Status.factoryForLeaf().severity(Status.Severity.ERROR).message(namespaceDoesNotMatchMessage.text()).type(TYPE_NAMESPACE_DOES_NOT_MATCH).create();
            }
            String schemaLocation = root.getSchemaLocation();
            if (schemaLocation.equals(currentNamespace)) {
                return Status.factoryForLeaf().severity(Status.Severity.ERROR).message(schemaLocationDeclNotFoundMessage.text()).type(TYPE_INVALID_SCHEMA_LOCATION).create();
            }
        }
        if ((project = (IProject)descriptor.adapt(IProject.class)) != null && (fv = CoreWlsExtensionFacetsGroup.findInstalledMember(project)) != null && !fv.getVersionString().equals(version.getFacetVersionString())) {
            String msg = facetDoesNotMatchMessage.format(new Object[]{fv.getProjectFacet().getLabel()});
            return Status.factoryForLeaf().severity(Status.Severity.ERROR).message(msg).type(TYPE_FACET_DOES_NOT_MATCH).create();
        }
        return Status.createOkStatus();
    }
}

