/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.common.internal;

import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.facets.CoreWlsExtensionFacetsGroup;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.services.DefaultValueService;
import org.eclipse.sapphire.services.DefaultValueServiceData;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;

public final class WebLogicServerVersionDefaultValueService
extends DefaultValueService {
    protected DefaultValueServiceData compute() {
        return new DefaultValueServiceData(WebLogicServerVersionDefaultValueService.getDefaultServerVersion((IProject)((Element)this.context(Element.class)).adapt(IProject.class)).toString());
    }

    public static WebLogicServerVersion getDefaultServerVersion(IProject project) {
        WebLogicServerVersion defaultServerVersion = WebLogicServerVersion.getNewestVersion();
        if (project != null) {
            IFacetedProject fproj = null;
            try {
                fproj = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException e) {
                WlsCorePlugin.logException((Exception)((Object)e));
            }
            if (fproj != null) {
                IProjectFacetVersion fv = CoreWlsExtensionFacetsGroup.findInstalledMember(fproj);
                if (fv != null) {
                    defaultServerVersion = WebLogicServerVersionDefaultValueService.convert(fv);
                } else {
                    IRuntimeComponent wlsRuntimeComponent = WlsRuntimeUtil.getWlsRuntimeComponent(fproj);
                    if (wlsRuntimeComponent != null) {
                        defaultServerVersion = WebLogicServerVersionDefaultValueService.convert(wlsRuntimeComponent.getRuntimeComponentVersion());
                    }
                }
            }
        }
        return defaultServerVersion;
    }

    private static WebLogicServerVersion convert(IProjectFacetVersion fv) {
        return WebLogicServerVersion.convert(fv.getVersionString());
    }

    private static WebLogicServerVersion convert(IRuntimeComponentVersion rcv) {
        return WebLogicServerVersion.convert(rcv.getVersionString());
    }
}

