/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.common.internal;

import oracle.eclipse.tools.weblogic.descriptors.common.LoggingPolicy;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;

public final class LoggingPolicyBinding
extends XmlValueBindingImpl {
    private static final XmlPath PATH_LOG_FILENAME = new XmlPath("log-filename");
    private static final XmlPath PATH_LOGGING_ENABLED = new XmlPath("logging-enabled");

    public XmlNode getXmlNode() {
        XmlElement el = this.xml(false);
        if (el != null) {
            XmlNode elLogFileName;
            XmlNode elLoggingEnabled = el.getChildNode(PATH_LOGGING_ENABLED, false);
            boolean enabled = elLoggingEnabled != null ? Boolean.valueOf(elLoggingEnabled.getText()) : true;
            if (enabled && (elLogFileName = el.getChildNode(PATH_LOG_FILENAME, false)) != null) {
                return elLogFileName;
            }
            return elLoggingEnabled;
        }
        return null;
    }

    public String read() {
        XmlElement el = this.xml(false);
        String val = null;
        if (el != null) {
            XmlElement elLoggingEnabled = (XmlElement)el.getChildNode(PATH_LOGGING_ENABLED, false);
            boolean enabled = elLoggingEnabled != null ? Boolean.valueOf(elLoggingEnabled.getText()) : true;
            if (enabled) {
                if (el.getChildNode(PATH_LOG_FILENAME, false) != null) {
                    val = LoggingPolicy.WRITE_TO_SEPARATE_FILE.name();
                }
            } else {
                val = LoggingPolicy.DISABLE_LOGGING.name();
            }
        }
        return val;
    }

    public void write(String value) {
        XmlElement el = this.xml(true);
        if (LoggingPolicy.WRITE_TO_SEPARATE_FILE.name().equals(value)) {
            el.removeChildNode(PATH_LOGGING_ENABLED);
            el.getChildNode(PATH_LOG_FILENAME, true);
        } else if (LoggingPolicy.DISABLE_LOGGING.name().equals(value)) {
            el.setChildNodeText(PATH_LOGGING_ENABLED, "false", false);
        } else {
            el.removeChildNode(PATH_LOGGING_ENABLED);
            el.removeChildNode(PATH_LOG_FILENAME);
        }
    }
}

