/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.common.internal;

import oracle.eclipse.tools.weblogic.descriptors.ILibraryRef;
import oracle.eclipse.tools.weblogic.descriptors.common.internal.LibraryRefVersionValidationService;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import oracle.eclipse.tools.weblogic.j2eelib.Version;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;

public final class LibraryRefImplVersionValidationService
extends LibraryRefVersionValidationService {
    @Text(value="No match found for shared library \"{0}\" with implementation version \"{1}\"")
    private static LocalizableText noMatchFoundMessage;
    private Listener listener;

    static {
        LocalizableText.init(LibraryRefImplVersionValidationService.class);
    }

    @Override
    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                LibraryRefImplVersionValidationService.this.refresh();
            }
        };
        ILibraryRef libRef = (ILibraryRef)this.context(ILibraryRef.class);
        libRef.attach(this.listener, "LibraryName");
        libRef.attach(this.listener, "SpecificationVersion");
        libRef.attach(this.listener, "ExactMatchRequired");
    }

    protected Status compute() {
        boolean allowNewerVersions;
        Value value = (Value)this.context(Value.class);
        ILibraryRef libraryReference = (ILibraryRef)value.element().nearest(ILibraryRef.class);
        String libraryName = libraryReference.getLibraryName().text();
        String specVersion = libraryReference.getSpecificationVersion().text();
        String implVersion = value.text();
        boolean bl = allowNewerVersions = (Boolean)libraryReference.isExactMatchRequired().content(true) == false;
        if (libraryName != null && implVersion != null) {
            boolean libraryNameMatched = false;
            boolean librarySpecVersionMatched = false;
            LibraryModule[] libraryModuleArray = LibraryModulesSvc.getRegistry().list();
            int n = libraryModuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                LibraryModule lib = libraryModuleArray[n2];
                String libName = lib.getName();
                if (libName != null && libName.equals(libraryName)) {
                    libraryNameMatched = true;
                    if (LibraryModuleRef.match(Version.create(specVersion), lib.getSpecificationVersion(), allowNewerVersions)) {
                        librarySpecVersionMatched = true;
                        if (LibraryModuleRef.match(Version.create(implVersion), lib.getImplementationVersion(), allowNewerVersions)) {
                            return Status.createOkStatus();
                        }
                    }
                }
                ++n2;
            }
            if (libraryNameMatched && librarySpecVersionMatched) {
                String msg = noMatchFoundMessage.format(new Object[]{libraryName, implVersion});
                return Status.createStatus((Status.Severity)Status.Severity.ERROR, (String)msg);
            }
        }
        return Status.createOkStatus();
    }

    @Override
    public void dispose() {
        if (this.listener != null) {
            ILibraryRef libRef = (ILibraryRef)this.context(ILibraryRef.class);
            libRef.detach(this.listener, "LibraryName");
            libRef.detach(this.listener, "SpecificationVersion");
            libRef.detach(this.listener, "ExactMatchRequired");
            this.listener = null;
        }
        super.dispose();
    }
}

