/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicAppDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Element;

public final class WebLogicDescriptorUtil {
    public static <R> R runInContextOfAppDescriptor(Element context, Operation<IWebLogicAppDescriptor, R> operation) {
        IWebLogicAppDescriptor weblogicAppDescriptor = null;
        boolean needsToBeDisposed = false;
        try {
            IProject earProject;
            IProject project;
            weblogicAppDescriptor = (IWebLogicAppDescriptor)context.nearest(IWebLogicAppDescriptor.class);
            if (weblogicAppDescriptor == null && (project = (IProject)context.adapt(IProject.class)) != null && (earProject = WtpProjectUtil.findReferencingEarProject((IProject)project)) != null) {
                weblogicAppDescriptor = WebLogicDescriptorFactory.getAppDescriptor(earProject);
                needsToBeDisposed = true;
            }
            R result = null;
            if (weblogicAppDescriptor != null) {
                result = operation.run(weblogicAppDescriptor);
            }
            R r = result;
            return r;
        }
        finally {
            if (weblogicAppDescriptor != null && needsToBeDisposed) {
                weblogicAppDescriptor.dispose();
            }
        }
    }

    public static abstract class Operation<P, R> {
        public abstract R run(P var1);
    }
}

