/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import java.io.File;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicAppClientDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicAppDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicEjbModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJdbcConfig;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJmsModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicWebModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicWebServicesDbCustDescriptor;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.FileResourceStore;
import org.eclipse.sapphire.modeling.ResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.SharedModelsCache;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;

public final class WebLogicDescriptorFactory {
    public static IWebLogicAppDescriptor getAppDescriptor(IProject project) {
        return WebLogicDescriptorFactory.getAppDescriptor(project, true);
    }

    private static IWebLogicAppDescriptor getAppDescriptor(IProject project, boolean writable) {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        if (vc == null) {
            return null;
        }
        IVirtualFile vf = vc.getRootFolder().getFile("META-INF/weblogic-application.xml");
        return WebLogicDescriptorFactory.getAppDescriptor(vf.getUnderlyingFile(), writable);
    }

    public static IWebLogicAppDescriptor getAppDescriptor(IFile file) {
        return WebLogicDescriptorFactory.getAppDescriptor(file, true);
    }

    private static IWebLogicAppDescriptor getAppDescriptor(IFile file, boolean writable) {
        IWebLogicAppDescriptor descriptor = null;
        try {
            WorkspaceFileResourceStore fileResourceStore = new WorkspaceFileResourceStore(file);
            XmlResourceStore xmlResourceStore = new XmlResourceStore((ByteArrayResourceStore)fileResourceStore);
            if (writable) {
                descriptor = WebLogicDescriptorFactory.getAppDescriptor(xmlResourceStore);
            } else {
                SharedModelsCache.StandardKey key = new SharedModelsCache.StandardKey((ResourceStore)fileResourceStore, IWebLogicAppDescriptor.TYPE);
                descriptor = (IWebLogicAppDescriptor)SharedModelsCache.retrieve((Object)key);
                if (descriptor == null) {
                    descriptor = WebLogicDescriptorFactory.getAppDescriptor(xmlResourceStore);
                    SharedModelsCache.store((Object)key, (Element)descriptor);
                }
            }
        }
        catch (ResourceStoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
        }
        return descriptor;
    }

    public static IWebLogicAppDescriptor getAppDescriptor(File file) {
        try {
            return WebLogicDescriptorFactory.getAppDescriptor(new XmlResourceStore((ByteArrayResourceStore)new FileResourceStore(file)));
        }
        catch (ResourceStoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
            return null;
        }
    }

    public static IWebLogicAppDescriptor getAppDescriptor(XmlResourceStore xmlResourceStore) {
        return (IWebLogicAppDescriptor)IWebLogicAppDescriptor.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
    }

    public static IWebLogicAppClientDescriptor getAppClientDescriptor(IProject project) {
        return WebLogicDescriptorFactory.getAppClientDescriptor(project, true);
    }

    private static IWebLogicAppClientDescriptor getAppClientDescriptor(IProject project, boolean writable) {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        if (vc == null) {
            return null;
        }
        IVirtualFile vf = vc.getRootFolder().getFile("META-INF/weblogic-application-client.xml");
        return WebLogicDescriptorFactory.getAppClientDescriptor(vf.getUnderlyingFile(), writable);
    }

    public static IWebLogicAppClientDescriptor getAppClientDescriptor(IFile file) {
        return WebLogicDescriptorFactory.getAppClientDescriptor(file, true);
    }

    private static IWebLogicAppClientDescriptor getAppClientDescriptor(IFile file, boolean writable) {
        IWebLogicAppClientDescriptor descriptor = null;
        try {
            WorkspaceFileResourceStore fileResourceStore = new WorkspaceFileResourceStore(file);
            XmlResourceStore xmlResourceStore = new XmlResourceStore((ByteArrayResourceStore)fileResourceStore);
            if (writable) {
                descriptor = WebLogicDescriptorFactory.getAppClientDescriptor(xmlResourceStore);
            } else {
                SharedModelsCache.StandardKey key = new SharedModelsCache.StandardKey((ResourceStore)fileResourceStore, IWebLogicAppClientDescriptor.TYPE);
                descriptor = (IWebLogicAppClientDescriptor)SharedModelsCache.retrieve((Object)key);
                if (descriptor == null) {
                    descriptor = WebLogicDescriptorFactory.getAppClientDescriptor(xmlResourceStore);
                    SharedModelsCache.store((Object)key, (Element)descriptor);
                }
            }
        }
        catch (ResourceStoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
        }
        return descriptor;
    }

    public static IWebLogicAppClientDescriptor getAppClientDescriptor(File file) {
        try {
            return WebLogicDescriptorFactory.getAppClientDescriptor(new XmlResourceStore((ByteArrayResourceStore)new FileResourceStore(file)));
        }
        catch (ResourceStoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
            return null;
        }
    }

    public static IWebLogicAppClientDescriptor getAppClientDescriptor(XmlResourceStore xmlResourceStore) {
        return (IWebLogicAppClientDescriptor)IWebLogicAppClientDescriptor.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
    }

    public static IWebLogicWebModuleDescriptor getWebDescriptor(IProject project) {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        if (vc == null) {
            return null;
        }
        IVirtualFile vf = vc.getRootFolder().getFile("WEB-INF/weblogic.xml");
        return WebLogicDescriptorFactory.getWebDescriptor(vf.getUnderlyingFile());
    }

    public static IWebLogicWebModuleDescriptor getWebDescriptor(IFile file) {
        try {
            return WebLogicDescriptorFactory.getWebDescriptor(new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(file)));
        }
        catch (ResourceStoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
            return null;
        }
    }

    public static IWebLogicWebModuleDescriptor getWebDescriptor(File file) {
        try {
            return WebLogicDescriptorFactory.getWebDescriptor(new XmlResourceStore((ByteArrayResourceStore)new FileResourceStore(file)));
        }
        catch (ResourceStoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
            return null;
        }
    }

    public static IWebLogicWebModuleDescriptor getWebDescriptor(XmlResourceStore xmlResourceStore) {
        return (IWebLogicWebModuleDescriptor)IWebLogicWebModuleDescriptor.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
    }

    public static IWebLogicEjbModuleDescriptor getEjbModuleDescriptor(IProject project) {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        if (vc == null) {
            return null;
        }
        IVirtualFile vf = vc.getRootFolder().getFile("META-INF/weblogic-ejb-jar.xml");
        return WebLogicDescriptorFactory.getEjbModuleDescriptor(vf.getUnderlyingFile());
    }

    public static IWebLogicEjbModuleDescriptor getEjbModuleDescriptor(IFile file) {
        try {
            return WebLogicDescriptorFactory.getEjbModuleDescriptor(new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(file)));
        }
        catch (ResourceStoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
            return null;
        }
    }

    public static IWebLogicEjbModuleDescriptor getEjbModuleDescriptor(File file) {
        try {
            return WebLogicDescriptorFactory.getEjbModuleDescriptor(new XmlResourceStore((ByteArrayResourceStore)new FileResourceStore(file)));
        }
        catch (ResourceStoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
            return null;
        }
    }

    public static IWebLogicEjbModuleDescriptor getEjbModuleDescriptor(XmlResourceStore xmlResourceStore) {
        return (IWebLogicEjbModuleDescriptor)IWebLogicEjbModuleDescriptor.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
    }

    public static IWebLogicJmsModuleDescriptor getJmsModuleDescriptor(IFile file) {
        try {
            return WebLogicDescriptorFactory.getJmsModuleDescriptor(new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(file)));
        }
        catch (ResourceStoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
            return null;
        }
    }

    public static IWebLogicJmsModuleDescriptor getJmsModuleDescriptor(File file) {
        try {
            return WebLogicDescriptorFactory.getJmsModuleDescriptor(new XmlResourceStore((ByteArrayResourceStore)new FileResourceStore(file)));
        }
        catch (ResourceStoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
            return null;
        }
    }

    public static IWebLogicJmsModuleDescriptor getJmsModuleDescriptor(XmlResourceStore xmlResourceStore) {
        return (IWebLogicJmsModuleDescriptor)IWebLogicJmsModuleDescriptor.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
    }

    public static IWebLogicJdbcConfig getJdbcConfig(IFile file) {
        try {
            return WebLogicDescriptorFactory.getJdbcConfig(new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(file)));
        }
        catch (ResourceStoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
            return null;
        }
    }

    public static IWebLogicJdbcConfig getJdbcConfig(File file) {
        try {
            return WebLogicDescriptorFactory.getJdbcConfig(new XmlResourceStore((ByteArrayResourceStore)new FileResourceStore(file)));
        }
        catch (ResourceStoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
            return null;
        }
    }

    public static IWebLogicJdbcConfig getJdbcConfig(XmlResourceStore xmlResourceStore) {
        return (IWebLogicJdbcConfig)IWebLogicJdbcConfig.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
    }

    public static IWebLogicWebServicesDbCustDescriptor getWebServicesDbCustDescriptor(IFile file) {
        try {
            return WebLogicDescriptorFactory.getWebServicesDbCustDescriptor(new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(file)));
        }
        catch (ResourceStoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
            return null;
        }
    }

    public static IWebLogicWebServicesDbCustDescriptor getWebServicesDbCustDescriptor(File file) {
        try {
            return WebLogicDescriptorFactory.getWebServicesDbCustDescriptor(new XmlResourceStore((ByteArrayResourceStore)new FileResourceStore(file)));
        }
        catch (ResourceStoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
            return null;
        }
    }

    public static IWebLogicWebServicesDbCustDescriptor getWebServicesDbCustDescriptor(XmlResourceStore xmlResourceStore) {
        return (IWebLogicWebServicesDbCustDescriptor)IWebLogicWebServicesDbCustDescriptor.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
    }
}

