/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import oracle.eclipse.tools.weblogic.descriptors.ComponentContentRelativePathService;
import oracle.eclipse.tools.weblogic.descriptors.XmlEntityCachingPolicy;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.NoDuplicates;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

@Label(standard="XML entity mapping")
public interface IXmlEntityMapping
extends Element {
    public static final ElementType TYPE = new ElementType(IXmlEntityMapping.class);
    @XmlBinding(path="entity-mapping-name")
    @Label(standard="name")
    @Required
    @NoDuplicates
    @Documentation(content="Specifies the name of the entity mapping declaration.")
    public static final ValueProperty PROP_NAME = new ValueProperty(TYPE, "Name");
    @XmlBinding(path="public-id")
    @Label(standard="public ID")
    @Documentation(content="Specifies the public ID of the entity, such as:[pbr/]-//BEA Systems, Inc.//DTD for cars//EN")
    public static final ValueProperty PROP_PUBLIC_ID = new ValueProperty(TYPE, "PublicId");
    @XmlBinding(path="system-id")
    @Label(standard="system ID")
    @Documentation(content="Specifies the system ID of the entity, such as:[pbr/]http://www.bea.com/dtds/car.dtd")
    public static final ValueProperty PROP_SYSTEM_ID = new ValueProperty(TYPE, "SystemId");
    @Type(base=Path.class)
    @XmlBinding(path="entity-uri")
    @Label(standard="entity URI")
    @Service(impl=ComponentContentRelativePathService.class)
    @ValidFileSystemResourceType(value=FileSystemResourceType.FILE)
    @MustExist
    @Documentation(content="Specifies the URI of the entity. The path is relative to the main directory of the EAR archive or the exploded directory.")
    public static final ValueProperty PROP_ENTITY_URI = new ValueProperty(TYPE, "EntityUri");
    @Type(base=XmlEntityCachingPolicy.class)
    @XmlBinding(path="when-to-cache")
    @Label(standard="caching policy")
    @DefaultValue(text="cache-on-reference")
    @Documentation(content="Specifies when you should cache the external entity. Valid values are:[ul][li]Cache on reference - WebLogic Server caches the external entity referenced by a URL the first time the entity is referenced in an XML document.[/li][li]Cache at initialization - WebLogic Server caches the entity when the server starts.[/li][li]Do not cache - WebLogic Server never caches the external entity.[/li][/ul]")
    public static final ValueProperty PROP_CACHING_POLICY = new ValueProperty(TYPE, "CachingPolicy");
    @Type(base=Integer.class)
    @XmlBinding(path="cache-timeout-interval")
    @Label(standard="cache timeout (secs)")
    @Enablement(expr="${ CachingPolicy == 'cache-on-reference' || CachingPolicy == 'cache-at-initialization' }")
    @DefaultValue(text="120")
    @Documentation(content="Specifies the number of seconds after which the cached external entity becomes stale or out-of-date. WebLogic Server re-retrieves the external entity from the specified URL or pathname relative to the main directory of the EAR archive or exploded directory if the cached copy has been in the cache for longer than this interval.[pbr/]The default value is 120 seconds.")
    public static final ValueProperty PROP_CACHE_TIMEOUT = new ValueProperty(TYPE, "CacheTimeout");

    public Value<String> getName();

    public void setName(String var1);

    public Value<String> getPublicId();

    public void setPublicId(String var1);

    public Value<String> getSystemId();

    public void setSystemId(String var1);

    public Value<Path> getEntityUri();

    public void setEntityUri(String var1);

    public void setEntityUri(Path var1);

    public Value<XmlEntityCachingPolicy> getCachingPolicy();

    public void setCachingPolicy(String var1);

    public void setCachingPolicy(XmlEntityCachingPolicy var1);

    public Value<Integer> getCacheTimeout();

    public void setCacheTimeout(String var1);

    public void setCacheTimeout(Integer var1);
}

