/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import oracle.eclipse.tools.weblogic.descriptors.IWebLogicDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.common.internal.WebLogicDescriptorRootElementController;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcConnectionPoolParameters;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcDataSourceParameters;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcDiagnostics;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcDriverParameters;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcIdentityOptions;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcOracleParameters;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcTransactionParameters;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.OracleParametersEnablementService;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlRootBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

@CustomXmlRootBinding(value=WebLogicDescriptorRootElementController.class)
public interface IWebLogicJdbcConfig
extends IWebLogicDescriptor,
IJdbcDataSourceParameters,
IJdbcIdentityOptions {
    public static final String CONTENT_TYPE_ID = "oracle.eclipse.tools.weblogic.descriptors.JdbcConfiguration";
    public static final ElementType TYPE = new ElementType(IWebLogicJdbcConfig.class);
    @XmlBinding(path="%weblogic-version")
    public static final ValueProperty PROP_SERVER_VERSION = new ValueProperty(TYPE, IWebLogicDescriptor.PROP_SERVER_VERSION);
    @XmlBinding(path="%description")
    public static final ValueProperty PROP_DESCRIPTION = new ValueProperty(TYPE, IWebLogicDescriptor.PROP_DESCRIPTION);
    @XmlBinding(path="name")
    @Label(standard="name")
    @Required
    @Documentation(content="A unique name that identifies this data source in the WebLogic domain")
    public static final ValueProperty PROP_NAME = new ValueProperty(TYPE, "Name");
    @Type(base=IJdbcDriverParameters.class)
    @Enablement(expr="${ DataSourceType == 'GenericDataSource' || DataSourceType == 'GridLinkDataSource' }")
    @XmlBinding(path="jdbc-driver-params")
    public static final ImpliedElementProperty PROP_DRIVER_PARAMETERS = new ImpliedElementProperty(TYPE, "DriverParameters");
    @Type(base=Integer.class)
    @XmlBinding(path="jdbc-connection-pool-params/test-frequency-seconds")
    @Label(standard="test frequency (secs)")
    public static final ValueProperty PROP_TEST_FREQUENCY = new ValueProperty(TYPE, "TestFrequency");
    @Type(base=IJdbcConnectionPoolParameters.class)
    @Enablement(expr="${ DataSourceType == 'GenericDataSource' || DataSourceType == 'GridLinkDataSource' }")
    @XmlBinding(path="jdbc-connection-pool-params")
    public static final ImpliedElementProperty PROP_CONNECTION_POOL_PARAMETERS = new ImpliedElementProperty(TYPE, "ConnectionPoolParameters");
    @Type(base=IJdbcOracleParameters.class)
    @Service(impl=OracleParametersEnablementService.class)
    @XmlBinding(path="jdbc-oracle-params")
    public static final ImpliedElementProperty PROP_ORACLE_PARAMETERS = new ImpliedElementProperty(TYPE, "OracleParameters");
    @Type(base=IJdbcTransactionParameters.class)
    @Enablement(expr="${ DataSourceType == 'GenericDataSource' || DataSourceType == 'GridLinkDataSource' }")
    @XmlBinding(path="")
    public static final ImpliedElementProperty PROP_TRANSACTION_PARAMETERS = new ImpliedElementProperty(TYPE, "TransactionParameters");
    @Type(base=IJdbcDiagnostics.class)
    @Enablement(expr="${ DataSourceType == 'GenericDataSource' || DataSourceType == 'GridLinkDataSource' }")
    @XmlBinding(path="")
    public static final ImpliedElementProperty PROP_DIAGNOSTICS = new ImpliedElementProperty(TYPE, "Diagnostics");
    @Type(base=IJdbcIdentityOptions.class)
    @Enablement(expr="${ DataSourceType == 'GenericDataSource' || DataSourceType == 'GridLinkDataSource' }")
    @XmlBinding(path="")
    public static final ImpliedElementProperty PROP_IDENTITY_OPTIONS = new ImpliedElementProperty(TYPE, "IdentityOptions");
    @Type(base=Long.class)
    @XmlBinding(path="id")
    @Label(standard="ID")
    @DefaultValue(text="0")
    @NumericRange(min="0")
    @Since(value="10.3.6")
    @Documentation(content="Immutable identifier for the datasource.")
    public static final ValueProperty PROP_ID = new ValueProperty(TYPE, "Id");

    public Value<String> getName();

    public void setName(String var1);

    public IJdbcDriverParameters getDriverParameters();

    public Value<Integer> getTestFrequency();

    public void setTestFrequency(String var1);

    public void setTestFrequency(Integer var1);

    public IJdbcConnectionPoolParameters getConnectionPoolParameters();

    public IJdbcOracleParameters getOracleParameters();

    public IJdbcTransactionParameters getTransactionParameters();

    public IJdbcDiagnostics getDiagnostics();

    public IJdbcIdentityOptions getIdentityOptions();

    public Value<Long> getId();

    public void setId(Long var1);

    public void setId(String var1);
}

