/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import oracle.eclipse.tools.weblogic.descriptors.IApplicationAdminModeTrigger;
import oracle.eclipse.tools.weblogic.descriptors.IApplicationLifecycleListenerDefinition;
import oracle.eclipse.tools.weblogic.descriptors.IApplicationParam;
import oracle.eclipse.tools.weblogic.descriptors.IApplicationShutdownListenerDefinition;
import oracle.eclipse.tools.weblogic.descriptors.IApplicationStartupListenerDefinition;
import oracle.eclipse.tools.weblogic.descriptors.ICapacityConstraint;
import oracle.eclipse.tools.weblogic.descriptors.IClassLoaderStructure;
import oracle.eclipse.tools.weblogic.descriptors.IClassLoadingConfiguration;
import oracle.eclipse.tools.weblogic.descriptors.ICoherenceConfiguration;
import oracle.eclipse.tools.weblogic.descriptors.IContextRequestClass;
import oracle.eclipse.tools.weblogic.descriptors.IDatabaseConnectionPool;
import oracle.eclipse.tools.weblogic.descriptors.IEntityCache;
import oracle.eclipse.tools.weblogic.descriptors.IFairShareRequestClass;
import oracle.eclipse.tools.weblogic.descriptors.IFastSwapSettingsDescriptorPart;
import oracle.eclipse.tools.weblogic.descriptors.ILibraryContextRootOverride;
import oracle.eclipse.tools.weblogic.descriptors.ILibraryRefDescriptorPart;
import oracle.eclipse.tools.weblogic.descriptors.IMaximumThreadsConstraint;
import oracle.eclipse.tools.weblogic.descriptors.IMinimumThreadsConstraint;
import oracle.eclipse.tools.weblogic.descriptors.IModuleDefinition;
import oracle.eclipse.tools.weblogic.descriptors.IOsgiFramework;
import oracle.eclipse.tools.weblogic.descriptors.IPackageReference;
import oracle.eclipse.tools.weblogic.descriptors.IResourceReferencesDescriptorPart;
import oracle.eclipse.tools.weblogic.descriptors.IResponseTimeRequestClass;
import oracle.eclipse.tools.weblogic.descriptors.ISchedulingGuideline;
import oracle.eclipse.tools.weblogic.descriptors.ISecurityRoleAssignment;
import oracle.eclipse.tools.weblogic.descriptors.ISecurityRoleAssignmentDescriptorPart;
import oracle.eclipse.tools.weblogic.descriptors.ISessionConfigurationDescriptorPart;
import oracle.eclipse.tools.weblogic.descriptors.ISingletonService;
import oracle.eclipse.tools.weblogic.descriptors.ISpringSettingsDescriptorPart;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.IWorkManagerDefinitionsDescriptorPart;
import oracle.eclipse.tools.weblogic.descriptors.IXmlProcessingConfiguration;
import oracle.eclipse.tools.weblogic.descriptors.app.IResourcePattern;
import oracle.eclipse.tools.weblogic.descriptors.common.internal.WebLogicDescriptorRootElementController;
import oracle.eclipse.tools.weblogic.descriptors.internal.LibraryContextRootOverridesValidator;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.FixedOrderList;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlRootBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

@CustomXmlRootBinding(value=WebLogicDescriptorRootElementController.class)
public interface IWebLogicAppDescriptor
extends IWebLogicDescriptor,
ILibraryRefDescriptorPart,
ISecurityRoleAssignmentDescriptorPart,
IFastSwapSettingsDescriptorPart,
ISessionConfigurationDescriptorPart,
IWorkManagerDefinitionsDescriptorPart,
ISpringSettingsDescriptorPart,
ICoherenceConfiguration,
IClassLoadingConfiguration,
IResourceReferencesDescriptorPart {
    public static final String DESCRIPTOR_FILE_NAME = "weblogic-application.xml";
    public static final String DESCRIPTOR_PATH = "META-INF/weblogic-application.xml";
    public static final ElementType TYPE = new ElementType(IWebLogicAppDescriptor.class);
    @XmlBinding(path="%weblogic-version")
    public static final ValueProperty PROP_SERVER_VERSION = new ValueProperty(TYPE, IWebLogicDescriptor.PROP_SERVER_VERSION);
    @XmlBinding(path="%description")
    public static final ValueProperty PROP_DESCRIPTION = new ValueProperty(TYPE, IWebLogicDescriptor.PROP_DESCRIPTION);
    @Label(standard="security realm name")
    @XmlBinding(path="security/realm-name")
    @Documentation(content="Specifies the security realm to be used by the[br/]application. If none is specified, the system default realm is used.")
    public static final ValueProperty PROP_SECURITY_REALM_NAME = new ValueProperty(TYPE, "SecurityRealmName");
    @Type(base=Boolean.class)
    @Label(standard="start MDBS with application")
    @DefaultValue(text="true")
    @XmlBinding(path="ejb/start-mdbs-with-application")
    @Documentation(content="Allows you to configure the EJB container to start message-driven beans with the application. If set to true, the container starts message-driven beans as part of the application. If set to false, the container keeps message-driven beans in a queue and the server starts them as soon as it has started listening on the ports.")
    public static final ValueProperty PROP_START_MDBS_WITH_APPLICATION = new ValueProperty(TYPE, "StartMdbsWithApplication");
    @Type(base=IEntityCache.class)
    @XmlListBinding(path="ejb", mappings={@XmlListBinding.Mapping(element="entity-cache", type=IEntityCache.class)})
    public static final ListProperty PROP_ENTITY_CACHES = new ListProperty(TYPE, "EntityCaches");
    @Type(base=IModuleDefinition.class)
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="module", type=IModuleDefinition.class)})
    public static final ListProperty PROP_MODULES = new ListProperty(TYPE, "Modules");
    @Label(standard="application parameters")
    @Type(base=IApplicationParam.class)
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="application-param", type=IApplicationParam.class)})
    @Documentation(content="Used to specify untyped parameters that affect the behavior of container instances related to the application. Currently, the following parameters are supported:[obr/]The following parameters in the weblogic-application.xml file can determine the default encoding to be used for both request and response.[pbr/]* webapp.encoding.default - can be set to a String representing an encoding supported by the JDK. If set, this will define the default encoding used to process servlet requests and responses. This setting is ignored if \"webapp.encoding.usevmdefault\" is set to \"true\". This value is also overridden for requests streams by the \"input-charset\" element of the weblogic.xml file, and for response streams by the contentType header of the request.[pbr/]* webapp.encoding.usevmdefault - can be set to \"true\" or \"false\". If set to \"true\", the system property \"file.encoding\" will be used to define the default encoding.[pbr/]The following parameter is used to affect the behavior of Web applications that are contained in this application:[pbr/]* webapp.getrealpath.accept_context_path - this is a compatibility switch which may be set to \"true\" or \"false\". If set to \"true\", then the context path of Web applications is allowed in calls to the servlet getRealPath method.")
    public static final ListProperty PROP_APPLICATION_PARAMS = new ListProperty(TYPE, "ApplicationParams");
    @Label(standard="singleton services")
    @Type(base=ISingletonService.class)
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="singleton-service", type=ISingletonService.class)})
    @Documentation(content="Used to register user-defined singleton services. These are classes that implement the interface weblogic.cluster.singleton.SingletonService. The \"class-name\" element is the name of user\u2019s implementation of SingletonService. The \"singleton-uri\" is a JAR file within the EAR file which contains the implementation. If the \"singleton-uri\" is not specified, then it is assumed that the class is visible to the application.")
    public static final ListProperty PROP_SINGLETON_SERVICES = new ListProperty(TYPE, "SingletonServices");
    @Type(base=IApplicationLifecycleListenerDefinition.class)
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="listener", type=IApplicationLifecycleListenerDefinition.class)})
    @Label(standard="lifecycle listeners")
    @Documentation(content="Used to register application life cycle listeners. These are classes that extend the abstract base class  weblogic.application.ApplicationLifecycleListener. The optional JAR path can point to a JAR file within the EAR file which contains the listener class. If the JAR path is not specified, then it is assumed that the class is visible to the application.")
    public static final ListProperty PROP_LIFECYCLE_LISTENERS = new ListProperty(TYPE, "LifecycleListeners");
    @Type(base=IApplicationStartupListenerDefinition.class)
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="startup", type=IApplicationStartupListenerDefinition.class)})
    @Label(standard="startup listeners")
    @Documentation(content="Used to register classes that should be run when the application is being started. These classes should implement the standard static main method. The optional JAR path can point to a JAR file within the EAR file which contains the listener class. If the JAR path is not specified, then it is assumed that the class is visible to the application.[pbr/]Note: Startup listeners are deprecated since WebLogic Server 9.0 release. You should use the application life cycle listeners instead.")
    public static final ListProperty PROP_STARTUP_LISTENERS = new ListProperty(TYPE, "StartupListeners");
    @Type(base=IApplicationShutdownListenerDefinition.class)
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="shutdown", type=IApplicationShutdownListenerDefinition.class)})
    @Label(standard="shutdown listeners")
    @Documentation(content="Used to register classes that should be run when the application is being shut down. These classes should implement the standard static main method. The optional JAR path can point to a JAR file within the EAR file which contains the listener class. If the JAR path is not specified, then it is assumed that the class is visible to the application.[pbr/]Note: Shutdown listeners are deprecated since WebLogic Server 9.0 release. You should use the application life cycle listeners instead.")
    public static final ListProperty PROP_SHUTDOWN_LISTENERS = new ListProperty(TYPE, "ShutdownListeners");
    @Service(impl=LibraryContextRootOverridesValidator.class)
    @Type(base=ILibraryContextRootOverride.class)
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="library-context-root-override", type=ILibraryContextRootOverride.class)})
    @Label(standard="library context root overrides")
    @Documentation(content="When referencing a web application library from a weblogic-application.xml descriptor, you can specify the context root to be used. This context root selection may be further overridden by the use of a library context root override. This override has been added to cater to third party library scenarios. Say customer app A.ear refers to vendor library V.ear which in turn refers to another vendor library V.war. Since customer has no control over library reference declaration in V.ear, the library context root override provides a way to override the context root for V.war. [pbr/]Note that you can only override context roots of web libraries that have context root explicitly specified in the library reference. The context root in the library reference is optional (defaulting to library file name without the extension), but it is best practice to specify context root explicitly in the reference.[pbr/]There is no limit to the depth of library references at which the override will work.[pbr/]The library context root overrides specified in enterprise application libraries are ignored. The overrides are only respected when specified by the top-level application.")
    public static final ListProperty PROP_LIBRARY_CONTEXT_ROOT_OVERRIDES = new ListProperty(TYPE, "LibraryContextRootOverrides");
    @XmlListBinding(path="prefer-application-packages", mappings={@XmlListBinding.Mapping(element="package-name", type=IPackageReference.class)})
    public static final ListProperty PROP_APPLICATION_PACKAGES = new ListProperty(TYPE, IClassLoadingConfiguration.PROP_APPLICATION_PACKAGES);
    @Since(value="10.3.1")
    @XmlListBinding(path="prefer-application-resources", mappings={@XmlListBinding.Mapping(element="resource-name", type=IResourcePattern.class)})
    public static final ListProperty PROP_APPLICATION_RESOURCES = new ListProperty(TYPE, IClassLoadingConfiguration.PROP_APPLICATION_RESOURCES);
    @Type(base=ISchedulingGuideline.class, possible={IResponseTimeRequestClass.class, IFairShareRequestClass.class, IContextRequestClass.class, IMinimumThreadsConstraint.class, IMaximumThreadsConstraint.class, ICapacityConstraint.class})
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="response-time-request-class", type=IResponseTimeRequestClass.class), @XmlListBinding.Mapping(element="fair-share-request-class", type=IFairShareRequestClass.class), @XmlListBinding.Mapping(element="context-request-class", type=IContextRequestClass.class), @XmlListBinding.Mapping(element="min-threads-constraint", type=IMinimumThreadsConstraint.class), @XmlListBinding.Mapping(element="max-threads-constraint", type=IMaximumThreadsConstraint.class), @XmlListBinding.Mapping(element="capacity", type=ICapacityConstraint.class)})
    @FixedOrderList
    @Label(standard="common scheduling guidelines")
    @Documentation(content="Various scheduling guidelines can be used to guide WebLogic Server in allocating threads to requests. There are two categories of scheduling guidelines: request classes and constraints.[pbr/]Request classes help ensure that high priority work is scheduled before less important work, even if the high priority work is submitted after the low priority work. There are multiple types of request classes, each of which expresses this scheduling guideline in different terms. A work manager may specify only one request class.[pbr/]Constraints define minimum and maximum numbers of threads allocated to execute requests and the total number of requests that can be queued or executing before WebLogic Server begins rejecting requests.", topics={@Documentation.Topic(label="Request Classes", url="oracle.eclipse.tools.weblogic.doc/context/html/RequestClasses.html"), @Documentation.Topic(label="Constraints", url="oracle.eclipse.tools.weblogic.doc/context/html/Constraints.html")})
    public static final ListProperty PROP_COMMON_SCHEDULING_GUIDELINES = new ListProperty(TYPE, "CommonSchedulingGuidelines");
    @Type(base=IXmlProcessingConfiguration.class)
    @XmlBinding(path="xml")
    public static final ImpliedElementProperty PROP_XML_PROCESSING_CONFIGURATION = new ImpliedElementProperty(TYPE, "XmlProcessingConfiguration");
    @Type(base=IApplicationAdminModeTrigger.class)
    @Label(standard="admin mode trigger")
    @XmlBinding(path="application-admin-mode-trigger")
    @Documentation(content="Specifies the conditions that will cause the application server to switch into administrative mode. You can specify the maximum amount of time (in seconds) that a thread can remain stuck, and the maximum number of stuck threads that the server should tolerate.")
    public static final ElementProperty PROP_ADMIN_MODE_TRIGGER = new ElementProperty(TYPE, "AdminModeTrigger");
    @Type(base=IDatabaseConnectionPool.class)
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="jdbc-connection-pool", type=IDatabaseConnectionPool.class)})
    public static final ListProperty PROP_DATABASE_CONNECTION_POOLS = new ListProperty(TYPE, "DatabaseConnectionPools");
    @Type(base=IClassLoaderStructure.class)
    @XmlBinding(path="classloader-structure")
    @Documentation(content="A \"classloader-structure\" element lets you define the organization of classloaders for this application. The declaration represents a tree structure that represents the classloader hierarchy and associates specific modules with particular nodes. A module's classes are loaded by the classloader that its associated with this element.[pbr/]Note that the depth is restricted to three levels.[pbr/]Example:[pbr/]<classloader-structure>[br/]    <module-ref>[br/]        <module-uri>ejb1.jar</module-uri>[br/]    </module-ref>[br/]</classloader-structure>[br/]<classloader-structure>[br/]    <module-ref>[br/]        <module-uri>ejb2.jar</module-uri>[br/]    </module-ref>[br/]</classloader-structure>")
    public static final ElementProperty PROP_CLASS_LOADER_STRUCTURE = new ElementProperty(TYPE, "ClassLoaderStructure");
    @XmlListBinding(path="security", mappings={@XmlListBinding.Mapping(element="security-role-assignment", type=ISecurityRoleAssignment.class)})
    public static final ListProperty PROP_SECURITY_ROLE_ASSIGNMENTS = new ListProperty(TYPE, ISecurityRoleAssignmentDescriptorPart.PROP_SECURITY_ROLE_ASSIGNMENTS);
    @Since(value="12.1.1")
    public static final ListProperty PROP_EJB_REFERENCE_DESCRIPTIONS = new ListProperty(TYPE, IResourceReferencesDescriptorPart.PROP_EJB_REFERENCE_DESCRIPTIONS);
    @Since(value="12.1.1")
    public static final ListProperty PROP_RESOURCE_REFERENCES = new ListProperty(TYPE, IResourceReferencesDescriptorPart.PROP_RESOURCE_REFERENCES);
    @Since(value="12.1.1")
    public static final ListProperty PROP_RESOURCE_ENV_REFERENCES = new ListProperty(TYPE, IResourceReferencesDescriptorPart.PROP_RESOURCE_ENV_REFERENCES);
    @Since(value="12.1.1")
    public static final ListProperty PROP_SERVICE_REFERENCES = new ListProperty(TYPE, IResourceReferencesDescriptorPart.PROP_SERVICE_REFERENCES);
    @Since(value="12.1.1")
    public static final ListProperty PROP_MESSAGE_DESTINATIONS = new ListProperty(TYPE, IResourceReferencesDescriptorPart.PROP_MESSAGE_DESTINATIONS);
    @Type(base=IOsgiFramework.class)
    @Label(standard="OSGi framework reference")
    @XmlBinding(path="osgi-framework-reference")
    @Since(value="12.1.2")
    @Documentation(content="Information about the OSGi framework which an application wishes to connect to. Bundles will be loaded into this framework and the bundle that should be used as a local resource are in this stanza. ")
    public static final ElementProperty PROP_OSGI_FRAMEWORK_REFERENCE = new ElementProperty(TYPE, "OsgiFrameworkReference");

    public Value<String> getSecurityRealmName();

    public void setSecurityRealmName(String var1);

    public Value<Boolean> getStartMdbsWithApplication();

    public void setStartMdbsWithApplication(String var1);

    public void setStartMdbsWithApplication(Boolean var1);

    public ElementList<IEntityCache> getEntityCaches();

    public ElementList<IModuleDefinition> getModules();

    public ElementList<IApplicationParam> getApplicationParams();

    public ElementList<ISingletonService> getSingletonServices();

    public ElementList<IApplicationLifecycleListenerDefinition> getLifecycleListeners();

    public ElementList<IApplicationStartupListenerDefinition> getStartupListeners();

    public ElementList<IApplicationShutdownListenerDefinition> getShutdownListeners();

    public ElementList<ILibraryContextRootOverride> getLibraryContextRootOverrides();

    public ElementList<ISchedulingGuideline> getCommonSchedulingGuidelines();

    public IXmlProcessingConfiguration getXmlProcessingConfiguration();

    public ElementHandle<IApplicationAdminModeTrigger> getAdminModeTrigger();

    public ElementList<IDatabaseConnectionPool> getDatabaseConnectionPools();

    public ElementHandle<IClassLoaderStructure> getClassLoaderStructure();

    public ElementHandle<IOsgiFramework> getOsgiFrameworkReference();
}

