/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import oracle.eclipse.tools.weblogic.descriptors.ISecurityPrincipalRef;
import oracle.eclipse.tools.weblogic.descriptors.common.internal.SecurityRoleAssignmentExternallyDefinedBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.CountConstraint;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

@Label(standard="security role assignment")
public interface ISecurityRoleAssignment
extends Element {
    public static final ElementType TYPE = new ElementType(ISecurityRoleAssignment.class);
    @XmlBinding(path="role-name")
    @Label(standard="role name")
    @Required
    @Documentation(content="The name of a security role.")
    public static final ValueProperty PROP_ROLE_NAME = new ValueProperty(TYPE, "RoleName");
    @Type(base=Boolean.class)
    @Label(standard="defined externally")
    @DefaultValue(text="false")
    @CustomXmlValueBinding(impl=SecurityRoleAssignmentExternallyDefinedBinding.class)
    @Documentation(content="Specifies that a particular security role is defined globally in a security realm; Oracle WebLogic Server uses this security role as the principal name, rather than looking it up in a global realm. When the security role and its principal-name mapping are defined elsewhere, this is used as an indicative placeholder.")
    public static final ValueProperty PROP_EXTERNALLY_DEFINED = new ValueProperty(TYPE, "ExternallyDefined");
    @Label(standard="principals")
    @Type(base=ISecurityPrincipalRef.class)
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="principal-name", type=ISecurityPrincipalRef.class)})
    @CountConstraint(min=1)
    @Enablement(expr="${ ! ExternallyDefined }")
    @Documentation(content="Specifies name of a principal that is defined in the security realm. You can use multiple \"principal-name\" elements to map principals to a role.", topics={@Documentation.Topic(label="Securing WebLogic Server", url="http://download.oracle.com/docs/cd/E13222_01/wls/docs103/secmanage/index.html")})
    public static final ListProperty PROP_PRINCIPALS = new ListProperty(TYPE, "Principals");

    public Value<String> getRoleName();

    public void setRoleName(String var1);

    public Value<Boolean> isExternallyDefined();

    public void setExternallyDefined(String var1);

    public void setExternallyDefined(Boolean var1);

    public ElementList<ISecurityPrincipalRef> getPrincipals();
}

