/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import oracle.eclipse.tools.weblogic.descriptors.ISchedulingGuideline;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

@Label(standard="response time request class")
@Image(path="images/descriptors/work-managers/response-time-rc.png")
@Documentation(content="Response time request class specifies a response time goal in milliseconds. Response time goals are not applied to individual requests. Instead, WebLogic Server computes a tolerable waiting time for requests with that class by subtracting the observed average thread use time from the response time goal, and schedules requests so that the average wait for requests with the class is proportional to its tolerable waiting time. [pbr/]For example, assume that WebLogic Server is running two modules with response time goals of 2000 ms and 5000 ms, respectively, and the actual thread use time for an individual request is less than its response time goal. During a period of sufficient demand, with a steady stream of requests for each module such that the number of requests exceed the number of threads, and no \"think time\" delays between response and request, WebLogic Server will schedule requests for ModuleA and ModuleB to keep the average response time in the ratio 2:5. The actual average response times for ModuleA and ModuleB might be higher or lower than the response time goals, but will be a common fraction or multiple of the stated goal. For example, if the average response time for ModuleA requests is 1,000 ms, the average response time for ModuleB requests would be 2,500 ms.")
public interface IResponseTimeRequestClass
extends ISchedulingGuideline {
    public static final ElementType TYPE = new ElementType(IResponseTimeRequestClass.class);
    @Type(base=Integer.class)
    @Label(standard="response time goal (ms)")
    @Required
    @NumericRange(min="1")
    @XmlBinding(path="goal-ms")
    public static final ValueProperty PROP_RESPONSE_TIME_GOAL = new ValueProperty(TYPE, "ResponseTimeGoal");

    public Value<Integer> getResponseTimeGoal();

    public void setResponseTimeGoal(String var1);

    public void setResponseTimeGoal(Integer var1);
}

