/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import oracle.eclipse.tools.weblogic.descriptors.IDefaultResourcePrincipal;
import oracle.eclipse.tools.weblogic.descriptors.ResourceLookupMethod;
import oracle.eclipse.tools.weblogic.descriptors.internal.ResourceReferenceDescriptionLookupMethodBinding;
import oracle.eclipse.tools.weblogic.descriptors.internal.ResourceReferenceNameValuesProvider;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NoDuplicates;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

@Label(standard="resource reference")
public interface IResourceReferenceDescription
extends Element {
    public static final ElementType TYPE = new ElementType(IResourceReferenceDescription.class);
    @XmlBinding(path="res-ref-name")
    @Label(standard="reference name")
    @Service(impl=ResourceReferenceNameValuesProvider.class)
    @Required
    @NoDuplicates
    @Documentation(content="A resource reference description specifies a JNDI name or a resource link for a resource reference used in your module\u2019s descriptor (web.xml or ejb-jar.xml).")
    public static final ValueProperty PROP_REFERENCE_NAME = new ValueProperty(TYPE, "ReferenceName");
    @Type(base=ResourceLookupMethod.class)
    @CustomXmlValueBinding(impl=ResourceReferenceDescriptionLookupMethodBinding.class)
    @Label(standard="resource lookup method")
    @DefaultValue(text="JNDI")
    public static final ValueProperty PROP_LOOKUP_METHOD = new ValueProperty(TYPE, "LookupMethod");
    @XmlBinding(path="jndi-name")
    @Label(standard="JNDI name")
    @Required
    @Enablement(expr="${ LookupMethod == 'JNDI' }")
    @Documentation(content="A resource reference description specifies a JNDI name or a resource link for a resource reference used in your module\u2019s descriptor (web.xml or ejb-jar.xml).")
    public static final ValueProperty PROP_JNDI_NAME = new ValueProperty(TYPE, "JndiName");
    @XmlBinding(path="resource-link")
    @Label(standard="resource link")
    @Required
    @Enablement(expr="${ LookupMethod == 'RESOURCE_LINK' }")
    @Documentation(content="A resource reference description specifies a JNDI name or a resource link for a resource reference used in your module\u2019s descriptor (web.xml or ejb-jar.xml).")
    public static final ValueProperty PROP_RESOURCE_LINK = new ValueProperty(TYPE, "ResourceLink");
    @Type(base=IDefaultResourcePrincipal.class)
    @XmlBinding(path="default-resource-principal")
    @Since(value="12.1.1")
    public static final ElementProperty PROP_DEFAULT_RESOURCE_PRINCIPAL = new ElementProperty(TYPE, "DefaultResourcePrincipal");

    public Value<String> getReferenceName();

    public void setReferenceName(String var1);

    public Value<ResourceLookupMethod> getLookupMethod();

    public void setLookupMethod(String var1);

    public void setLookupMethod(ResourceLookupMethod var1);

    public Value<String> getJndiName();

    public void setJndiName(String var1);

    public Value<String> getResourceLink();

    public void setResourceLink(String var1);

    public ElementHandle<IDefaultResourcePrincipal> getDefaultResourcePrincipal();
}

