/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import oracle.eclipse.tools.weblogic.descriptors.ISchedulingGuideline;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

@Label(standard="minimum threads constraint")
@Image(path="images/descriptors/work-managers/min-threads-constraint.png")
@Documentation(content="Minimum threads constraint guarantees the number of threads the server will allocate to affected requests to avoid deadlocks. The default is zero. A minimum threads constraint value of one is useful, for example, for a replication update request, which is called synchronously from a peer.[pbr/]A minimum threads constraint might not necessarily increase a fair share. This type of constraint has an effect primarily when the server instance is close to a deadlock condition. In that case, the constraint will cause WebLogic Server to schedule a request even if requests in the service class have gotten more than its fair share recently.")
public interface IMinimumThreadsConstraint
extends ISchedulingGuideline {
    public static final ElementType TYPE = new ElementType(IMinimumThreadsConstraint.class);
    @Type(base=Integer.class)
    @Label(standard="minimum thread count")
    @Required
    @NumericRange(min="0")
    @XmlBinding(path="count")
    public static final ValueProperty PROP_MINIMUM_THREAD_COUNT = new ValueProperty(TYPE, "MinimumThreadCount");

    public Value<Integer> getMinimumThreadCount();

    public void setMinimumThreadCount(String var1);

    public void setMinimumThreadCount(Integer var1);
}

