/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import oracle.eclipse.tools.weblogic.descriptors.ISchedulingGuideline;
import oracle.eclipse.tools.weblogic.descriptors.WorkManagerMaxThreadLimitType;
import oracle.eclipse.tools.weblogic.descriptors.internal.MaximumThreadsConstraintLimitTypeBinding;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

@Label(standard="maximum threads constraint")
@Image(path="images/descriptors/work-managers/max-threads-constraint.png")
@Documentation(content="Maximum threads constraint limits the number of concurrent threads executing requests from the constrained work set. The default is unlimited. For example, consider a constraint defined with maximum threads of 10 and shared by 3 entry points. The scheduling logic ensures that not more than 10 threads are executing requests from the three entry points combined.[pbr/]You can define a maximum threads constraint in terms of a the availability of the resource that requests depend upon, such as a connection pool.[pbr/]A maximum threads constraint might, but does not necessarily, prevent a request class from taking its fair share of threads or meeting its response time goal. Once the constraint is reached the server does not schedule requests of this type until the number of concurrent executions falls below the limit. The server then schedules work based on the fair share or response time goal.")
public interface IMaximumThreadsConstraint
extends ISchedulingGuideline {
    public static final ElementType TYPE = new ElementType(IMaximumThreadsConstraint.class);
    @Type(base=WorkManagerMaxThreadLimitType.class)
    @Label(standard="limit type")
    @Required
    @DefaultValue(text="FIXED")
    @CustomXmlValueBinding(impl=MaximumThreadsConstraintLimitTypeBinding.class)
    public static final ValueProperty PROP_MAXIMUM_THREAD_LIMIT_TYPE = new ValueProperty(TYPE, "MaximumThreadLimitType");
    @Type(base=Integer.class)
    @Label(standard="maximum thread count")
    @Enablement(expr="${ MaximumThreadLimitType == 'FIXED' }")
    @Required
    @NumericRange(min="1")
    @XmlBinding(path="count")
    public static final ValueProperty PROP_MAXIMUM_THREAD_COUNT = new ValueProperty(TYPE, "MaximumThreadCount");
    @Label(standard="connection pool")
    @Enablement(expr="${ MaximumThreadLimitType == 'BY_CONNECTION_POOL' }")
    @Required
    @XmlBinding(path="pool-name")
    public static final ValueProperty PROP_CONNECTION_POOL_NAME = new ValueProperty(TYPE, "ConnectionPoolName");
    @Type(base=Integer.class)
    @Label(standard="queue size")
    @DefaultValue(text="8192")
    @NumericRange(min="256", max="65536")
    @Since(value="12.1.2")
    @XmlBinding(path="queue-size")
    @Documentation(content=" Set the approximate size of the MaxThreadsConstraint requests queue. Requests are added to this queue if they are not yet eligible for execution due the the maximum number of concurrent threads that can execute requests sharing this constraint has been reached. The actual size of the queue created may be different from the value set here. For example, it may be rounded up to the nearest power of 2.")
    public static final ValueProperty PROP_QUEUE_SIZE = new ValueProperty(TYPE, "QueueSize");

    public Value<WorkManagerMaxThreadLimitType> getMaximumThreadLimitType();

    public void setMaximumThreadLimitType(String var1);

    public void setMaximumThreadLimitType(WorkManagerMaxThreadLimitType var1);

    public Value<Integer> getMaximumThreadCount();

    public void setMaximumThreadCount(String var1);

    public void setMaximumThreadCount(Integer var1);

    public Value<String> getConnectionPoolName();

    public void setConnectionPoolName(String var1);

    public Value<Integer> getQueueSize();

    public void setQueueSize(String var1);

    public void setQueueSize(Integer var1);
}

