/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import oracle.eclipse.tools.weblogic.descriptors.common.internal.LibraryRefContextRootDefaulValueService;
import oracle.eclipse.tools.weblogic.descriptors.common.internal.LibraryRefContextRootEnablementService;
import oracle.eclipse.tools.weblogic.descriptors.common.internal.LibraryRefContextRootValidationService;
import oracle.eclipse.tools.weblogic.descriptors.common.internal.LibraryRefImplVersionPossibleValuesService;
import oracle.eclipse.tools.weblogic.descriptors.common.internal.LibraryRefImplVersionValidationService;
import oracle.eclipse.tools.weblogic.descriptors.common.internal.LibraryRefNamePossibleValuesService;
import oracle.eclipse.tools.weblogic.descriptors.common.internal.LibraryRefSpecVersionPossibleValuesService;
import oracle.eclipse.tools.weblogic.descriptors.common.internal.LibraryRefSpecVersionValidationService;
import oracle.eclipse.tools.weblogic.descriptors.internal.LibraryRefMethods;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.DelegateImplementation;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

@Label(standard="shared library reference")
public interface ILibraryRef
extends Element {
    public static final ElementType TYPE = new ElementType(ILibraryRef.class);
    public static final String PNAME_LIBRARY_NAME = "LibraryName";
    public static final String PNAME_SPECIFICATION_VERSION = "SpecificationVersion";
    public static final String PNAME_IMPLEMENTATION_VERSION = "ImplementationVersion";
    public static final String PNAME_EXACT_MATCH_REQUIRED = "ExactMatchRequired";
    public static final String PNAME_CONTEXT_ROOT = "ContextRoot";
    @XmlBinding(path="library-name")
    @Label(standard="library name")
    @Required
    @Service(impl=LibraryRefNamePossibleValuesService.class)
    @Documentation(content="Specifies the name of the shared library. Every shared library reference must at least specify a name.")
    public static final ValueProperty PROP_LIBRARY_NAME = new ValueProperty(TYPE, "LibraryName");
    @XmlBinding(path="specification-version")
    @Label(standard="specification version")
    @Services(value={@Service(impl=LibraryRefSpecVersionPossibleValuesService.class), @Service(impl=LibraryRefSpecVersionValidationService.class)})
    @Documentation(content="Specifies the specification version of the shared library that can be matched by this reference. [pbr/]The default value is 0.")
    public static final ValueProperty PROP_SPECIFICATION_VERSION = new ValueProperty(TYPE, "SpecificationVersion");
    @XmlBinding(path="implementation-version")
    @Label(standard="implementation version")
    @Services(value={@Service(impl=LibraryRefImplVersionPossibleValuesService.class), @Service(impl=LibraryRefImplVersionValidationService.class)})
    @Documentation(content="Specifies the implementation version of the shared library that can be matched by this reference. [pbr/]The default value is \"null\".")
    public static final ValueProperty PROP_IMPLEMENTATION_VERSION = new ValueProperty(TYPE, "ImplementationVersion");
    @Type(base=Boolean.class)
    @XmlBinding(path="exact-match")
    @Label(standard="exact version required")
    @DefaultValue(text="false")
    @Documentation(content="Specifies whether or not this shared library reference can match versions that are newer than what is specified by Specification Version and Implementation Version.")
    public static final ValueProperty PROP_EXACT_MATCH_REQUIRED = new ValueProperty(TYPE, "ExactMatchRequired");
    @XmlBinding(path="context-root")
    @Label(standard="context root")
    @Services(value={@Service(impl=LibraryRefContextRootDefaulValueService.class), @Service(impl=LibraryRefContextRootValidationService.class), @Service(impl=LibraryRefContextRootEnablementService.class)})
    @Documentation(content="Specifies the context root that a shared web application library will be mapped to by the server. If not specified, the default context root is the file name of the library (as deployed) without the extension. For this reason it is recommended that the context root is always specified in the reference.[pbr/]This setting is only applicable when referencing web application libraries from an enterprise application or an enterprise application library.")
    public static final ValueProperty PROP_CONTEXT_ROOT = new ValueProperty(TYPE, "ContextRoot");

    public Value<String> getLibraryName();

    public void setLibraryName(String var1);

    public Value<String> getSpecificationVersion();

    public void setSpecificationVersion(String var1);

    public Value<String> getImplementationVersion();

    public void setImplementationVersion(String var1);

    public Value<Boolean> isExactMatchRequired();

    public void setExactMatchRequired(String var1);

    public void setExactMatchRequired(Boolean var1);

    public Value<String> getContextRoot();

    public void setContextRoot(String var1);

    @DelegateImplementation(value=LibraryRefMethods.class)
    public void moveBefore(String ... var1);
}

