/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IFastSwapSettings
extends Element {
    public static final ElementType TYPE = new ElementType(IFastSwapSettings.class);
    @Type(base=Boolean.class)
    @XmlBinding(path="enabled")
    @Label(standard="enable class redefinition")
    @DefaultValue(text="false")
    @Documentation(content="Java EE 5 introduces the ability to redefine a class at runtime without dropping its ClassLoader or abandoning existing instances. This allows containers to reload altered classes without disturbing running applications, vastly speeding up iterative development cycles and improving the overall development and testing experiences. The usefulness of the Java EE dynamic class redefinition is severely curtailed, however, by the restriction that the shape of the class \u2013 its declared fields and methods \u2013 cannot change. The purpose of FastSwap is to remove this restriction in WLS, allowing the dynamic redefinition of classes with new shapes to facilitate iterative development.[pbr/]With FastSwap, Java classes are redefined in-place without reloading the ClassLoader, thereby having the decided advantage of fast turnaround times. This means that you do not have to wait for an application to redeploy and then navigate back to wherever you were in the Web page flow. Instead, you can make your changes, auto compile, and then see the effects immediately.", topics={@Documentation.Topic(label="FastSwap Documentation", url="http://download.oracle.com/docs/cd/E13222_01/wls/docs103/deployment/deployunits.html#wp1053872")})
    public static final ValueProperty PROP_ENABLED = new ValueProperty(TYPE, "Enabled");
    @Type(base=Integer.class)
    @XmlBinding(path="refresh-interval")
    @Label(standard="refresh interval (seconds)")
    @Enablement(expr="${ Enabled }")
    @DefaultValue(text="10")
    @Documentation(content="Java EE 5 introduces the ability to redefine a class at run time without dropping its ClassLoader or abandoning existing instances. This allows containers to reload altered classes without disturbing running applications, vastly speeding up iterative development cycles and improving the overall development and testing experiences. The usefulness of the Java EE dynamic class redefinition is severely curtailed, however, by the restriction that the shape of the class \u2013 its declared fields and methods \u2013 cannot change. The purpose of FastSwap is to remove this restriction in WLS, allowing the dynamic redefinition of classes with new shapes to facilitate iterative development.[pbr/]With FastSwap, Java classes are redefined in-place without reloading the ClassLoader, thereby having the decided advantage of fast turnaround times. This means that you do not have to wait for an application to redeploy and then navigate back to wherever you were in the Web page flow. Instead, you can make your changes, auto compile, and then see the effects immediately.", topics={@Documentation.Topic(label="FastSwap Documentation", url="http://download.oracle.com/docs/cd/E13222_01/wls/docs103/deployment/deployunits.html#wp1053872")})
    public static final ValueProperty PROP_REFRESH_INTERVAL = new ValueProperty(TYPE, "RefreshInterval");
    @Type(base=Integer.class)
    @XmlBinding(path="redefinition-task-limit")
    @Label(standard="redefinition task limit")
    @Enablement(expr="${ Enabled }")
    @Documentation(content="Java EE 5 introduces the ability to redefine a class at run-time without dropping its ClassLoader or abandoning existing instances. This allows containers to reload altered classes without disturbing running applications, vastly speeding up iterative development cycles and improving the overall development and testing experiences. The usefulness of the Java EE dynamic class redefinition is severely curtailed, however, by the restriction that the shape of the class \u2013 its declared fields and methods \u2013 cannot change. The purpose of FastSwap is to remove this restriction in WLS, allowing the dynamic redefinition of classes with new shapes to facilitate iterative development.[pbr/]With FastSwap, Java classes are redefined in-place without reloading the ClassLoader, thereby having the decided advantage of fast turnaround times. This means that you do not have to wait for an application to redeploy and then navigate back to wherever you were in the Web page flow. Instead, you can make your changes, auto compile, and then see the effects immediately.", topics={@Documentation.Topic(label="FastSwap Documentation", url="http://download.oracle.com/docs/cd/E13222_01/wls/docs103/deployment/deployunits.html#wp1053872")})
    public static final ValueProperty PROP_REDEFINITION_TASK_LIMIT = new ValueProperty(TYPE, "RedefinitionTaskLimit");

    public Value<Boolean> isEnabled();

    public void setEnabled(String var1);

    public void setEnabled(Boolean var1);

    public Value<Integer> getRefreshInterval();

    public void setRefreshInterval(String var1);

    public void setRefreshInterval(Integer var1);

    public Value<Integer> getRedefinitionTaskLimit();

    public void setRedefinitionTaskLimit(String var1);

    public void setRedefinitionTaskLimit(Integer var1);
}

