/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IDatabasePreparedStatementProfilingConfig
extends Element {
    public static final ElementType TYPE = new ElementType(IDatabasePreparedStatementProfilingConfig.class);
    @Type(base=Boolean.class)
    @XmlBinding(path="profiling-enabled")
    @Label(standard="enable prepared statement profiling")
    @Documentation(content="Enables profiling of JDBC prepared statement cache. When enabled, prepared statement cache profiles are stored in external storage for further analysis. This is a resource-consuming feature, so it is recommended that you disable it on a production server. [br/]\t [br/]\t The default value is \"false\".")
    public static final ValueProperty PROP_PROFILING_ENABLED = new ValueProperty(TYPE, "ProfilingEnabled");
    @Type(base=Integer.class)
    @XmlBinding(path="cache-profiling-threshold")
    @Label(standard="cache threshold")
    @Enablement(expr="${ ProfilingEnabled }")
    @NumericRange(min="0")
    @Documentation(content="Defines the number of statement requests after which the state of the prepared statement cache is logged. This allows control over the output volume.")
    public static final ValueProperty PROP_CACHE_THRESHOLD = new ValueProperty(TYPE, "CacheThreshold");
    @Type(base=Boolean.class)
    @XmlBinding(path="parameter-logging-enabled")
    @Label(standard="enable prepared statement parameter logging")
    @Enablement(expr="${ ProfilingEnabled }")
    @Documentation(content="During SQL roundtrip profiling it is possible to store values of prepared statement parameters. This is a resource-consuming feature, so it is recommended that you disable it on a production server.")
    public static final ValueProperty PROP_PARAMETER_LOGGING_ENABLED = new ValueProperty(TYPE, "ParameterLoggingEnabled");
    @Type(base=Integer.class)
    @XmlBinding(path="max-parameter-length")
    @Label(standard="max parameter length")
    @Enablement(expr="${ ParameterLoggingEnabled }")
    @NumericRange(min="0")
    @Documentation(content="During SQL roundtrip profiling it is possible to store values of prepared statement parameters. This setting defines maximum length of the String passed as a parameter for JDBC SQL roundtrip profiling. This is a resource-consuming feature, so you should limit the length of data for a parameter to reduce the output volume.")
    public static final ValueProperty PROP_MAX_PARAMETER_LENGTH = new ValueProperty(TYPE, "MaxParameterLength");

    public Value<Boolean> isProfilingEnabled();

    public void setProfilingEnabled(String var1);

    public void setProfilingEnabled(Boolean var1);

    public Value<Integer> getCacheThreshold();

    public void setCacheThreshold(String var1);

    public void setCacheThreshold(Integer var1);

    public Value<Boolean> isParameterLoggingEnabled();

    public void setParameterLoggingEnabled(String var1);

    public void setParameterLoggingEnabled(Boolean var1);

    public Value<Integer> getMaxParameterLength();

    public void setMaxParameterLength(String var1);

    public void setMaxParameterLength(Integer var1);
}

