/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import oracle.eclipse.tools.weblogic.descriptors.DatabasePreparedStatementCacheType;
import oracle.eclipse.tools.weblogic.descriptors.IDatabasePreparedStatementProfilingConfig;
import oracle.eclipse.tools.weblogic.descriptors.app.internal.DatabasePreparedStatementCacheTypeBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IDatabaseDriverParameters
extends Element {
    public static final ElementType TYPE = new ElementType(IDatabaseDriverParameters.class);
    @Type(base=Boolean.class)
    @XmlBinding(path="row-prefetch-enabled")
    @Label(standard="enable row prefetching")
    @Documentation(content="Controls row prefetching between a client and Oracle WebLogic Server for each ResultSet. When an external client accesses a database using JDBC through Oracle Weblogic Server, row prefetching improves performance by fetching multiple rows from the server to the client in one server access. Oracle WebLogic Server will ignore this setting and not use row prefetching when the client and Oracle WebLogic Server are in the same JVM.")
    public static final ValueProperty PROP_ROW_PREFETCH_ENABLED = new ValueProperty(TYPE, "RowPrefetchEnabled");
    @Type(base=Integer.class)
    @XmlBinding(path="row-prefetch-size")
    @Label(standard="row prefetch size")
    @DefaultValue(text="48")
    @NumericRange(min="2", max="65536")
    @Enablement(expr="${ RowPrefetchEnabled }")
    @Documentation(content="The number of result set rows to prefetch for a client. The optimal value depends on the particulars of the query. In general, increasing this number will increase performance, until a particular value is reached. At that point, further increases do not result in a significant performance increase. Very rarely will increased performance result from exceeding 100 rows. The default value should be reasonable for most situations.")
    public static final ValueProperty PROP_ROW_PREFETCH_SIZE = new ValueProperty(TYPE, "RowPrefetchSize");
    @Type(base=Integer.class)
    @XmlBinding(path="stream-chunk-size")
    @Label(standard="streaming data chunk size ")
    @DefaultValue(text="256")
    @NumericRange(min="1", max="65536")
    @Documentation(content="Configures data chunk size for streaming datatypes. Streaming datatypes (for example, resulting from a call to the getBinaryStream() method) will be pulled in the specified-sized chunks from Oracle WebLogic Server to the client as needed.")
    public static final ValueProperty PROP_STREAM_CHUNK_SIZE = new ValueProperty(TYPE, "StreamChunkSize");
    @Type(base=DatabasePreparedStatementCacheType.class)
    @CustomXmlValueBinding(impl=DatabasePreparedStatementCacheTypeBinding.class)
    @Label(standard="prepared statement cache type")
    @DefaultValue(text="LRU")
    @Documentation(content="Two different prepared statement cache approaches are available. Least Recently Used (LRU) is the default and almost always superior. It means that for a statement cache of size N, the most recently used prepared statements will remain in cache, and when an N+1 statement is prepared, it will be cached, booting out the oldest cache resident, which will be closed. Fixed is an alternative method which may find some rare value. The first distinct N statements that are prepared are cached indefinitely and all subsequent statements are created, used, and closed per invoke (not cached). This form might be useful when users have too many statements to cache, and they know which they need cached, and can populate the cache as desired.")
    public static final ValueProperty PROP_PREPARED_STATEMENT_CACHE_TYPE = new ValueProperty(TYPE, "PreparedStatementCacheType");
    @Type(base=Integer.class)
    @XmlBinding(path="prepared-statement/cache-size")
    @Label(standard="prepared statement cache size")
    @DefaultValue(text="10")
    @NumericRange(min="0")
    @Documentation(content="The number of prepared and callable statements stored in the cache for further use. Oracle WebLogic Server can reuse statements in the cache without reloading them, which can increase server performance. Setting the size of the statement cache to 0 disables it. Each connection in the pool has its own cache of statements.")
    public static final ValueProperty PROP_PREPARED_STATEMENT_CACHE_SIZE = new ValueProperty(TYPE, "PreparedStatementCacheSize");
    @Type(base=Boolean.class)
    @XmlBinding(path="statement/profiling-enabled")
    @Label(standard="enable statement profiling")
    @Documentation(content="Controls whether or not profiling of SQL statements is enabled.")
    public static final ValueProperty PROP_STATEMENT_PROFILING_ENABLED = new ValueProperty(TYPE, "StatementProfilingEnabled");
    @Type(base=IDatabasePreparedStatementProfilingConfig.class)
    @XmlBinding(path="prepared-statement")
    public static final ImpliedElementProperty PROP_PREPARED_STATEMENT_PROFILING_CONFIG = new ImpliedElementProperty(TYPE, "PreparedStatementProfilingConfig");

    public Value<Boolean> isRowPrefetchEnabled();

    public void setRowPrefetchEnabled(String var1);

    public void setRowPrefetchEnabled(Boolean var1);

    public Value<Integer> getRowPrefetchSize();

    public void setRowPrefetchSize(String var1);

    public void setRowPrefetchSize(Integer var1);

    public Value<Integer> getStreamChunkSize();

    public void setStreamChunkSize(String var1);

    public void setStreamChunkSize(Integer var1);

    public Value<DatabasePreparedStatementCacheType> getPreparedStatementCacheType();

    public void setPreparedStatementCacheType(String var1);

    public void setPreparedStatementCacheType(DatabasePreparedStatementCacheType var1);

    public Value<Integer> getPreparedStatementCacheSize();

    public void setPreparedStatementCacheSize(String var1);

    public void setPreparedStatementCacheSize(Integer var1);

    public Value<Boolean> isStatementProfilingEnabled();

    public void setStatementProfilingEnabled(String var1);

    public void setStatementProfilingEnabled(Boolean var1);

    public IDatabasePreparedStatementProfilingConfig getPreparedStatementProfilingConfig();
}

