/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import oracle.eclipse.tools.weblogic.descriptors.IndexDirectorySortOrder;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlValueBinding;

public interface IContainerDescriptorSection
extends Element {
    public static final ElementType TYPE = new ElementType(IContainerDescriptorSection.class);
    @Type(base=Boolean.class)
    @XmlValueBinding(path="check-auth-on-forward", mapExistanceToValue="true")
    @Label(standard="authenticate forwarded requests")
    @DefaultValue(text="false")
    @Documentation(content="Set \"check-auth-on-forward\" element when you want to require authentication of forwarded requests from a servlet or JSP. Omit the tag if you do not want to require reauthentication.[pbr/]Note that as a best practice, Oracle does not recommend that you enable the \"check-auth-on-forward\" property.")
    public static final ValueProperty PROP_CHECK_AUTH_ON_FORWARD = new ValueProperty(TYPE, "CheckAuthOnForward");
    @Type(base=Boolean.class)
    @XmlBinding(path="filter-dispatched-requests-enabled")
    @Label(standard="filter dispatched requests")
    @DefaultValue(text="false")
    @Documentation(content="Controls whether or not filters are applied to dispatched requests. The default value is false. [pbr/]Note that because 2.4 servlets are backward-compatible with 2.3 servlets (per the 2.4 specification), when 2.3 descriptor elements are detected by Oracle WebLogic Server, the <filter-dispatched-requests-enabled> element defaults to \"true\".")
    public static final ValueProperty PROP_FILTER_DISPATCHED_REQUESTS_ENABLED = new ValueProperty(TYPE, "FilterDispatchedRequestsEnabled");
    @XmlBinding(path="redirect-content-type")
    @Label(standard="redirect content type")
    @Deprecated
    @Documentation(content="If the \"redirect-content-type\" element is set, then the servlet container will set that type on the response for internal redirects (for example, for welcome files).[pbr/]Note: The \"redirect-content-type\" element is deprecated since 8.1 and will be removed in a future version of Oracle WebLogic Server.")
    public static final ValueProperty PROP_REDIRECT_CONTENT_TYPE = new ValueProperty(TYPE, "RedirectContentType");
    @XmlBinding(path="redirect-content")
    @Label(standard="redirect content")
    @Deprecated
    @Documentation(content="If the \"redirect-content\" element is set, then the servlet container will use that as the value for the user-readable data used in a redirect.[pbr/]Note: The \"redirect-content\" element is deprecated since 8.1 and will be removed in a future version of Oracle WebLogic Server.")
    public static final ValueProperty PROP_REDIRECT_CONTENT = new ValueProperty(TYPE, "RedirectContent");
    @Type(base=Boolean.class)
    @XmlBinding(path="redirect-with-absolute-url")
    @Label(standard="redirect with absolute URL")
    @DefaultValue(text="true")
    @Documentation(content="Controls whether the javax.servlet.http.HttpServletResponse.SendRedirect() method redirects using a relative or absolute URL. Set this element to \"false\" if you are using a proxy HTTP server and do not want the URL converted to a non-relative link.[pbr/]The default behavior is to convert the URL to a non-relative link.")
    public static final ValueProperty PROP_REDIRECT_WITH_ABSOLUTE_URL = new ValueProperty(TYPE, "RedirectWithAbsoluteUrl");
    @Type(base=Boolean.class)
    @XmlBinding(path="index-directory-enabled")
    @Label(standard="generate a directory listing if index file is missing")
    @DefaultValue(text="false")
    @Documentation(content="Controls whether or not to automatically generate an HTML directory listing if no suitable index file is found.[pbr/]The default value is \"false\" (does not generate a directory).")
    public static final ValueProperty PROP_INDEX_DIRECTORY_ENABLED = new ValueProperty(TYPE, "IndexDirectoryEnabled");
    @Type(base=IndexDirectorySortOrder.class)
    @XmlBinding(path="index-directory-sort-by")
    @Label(standard="directory sort key")
    @Enablement(expr="${ IndexDirectoryEnabled }")
    @DefaultValue(text="NAME")
    @Documentation(content="Defines the order in which the directory listing generated by weblogic.servlet.FileServlet is sorted. Valid \"sort-by\" values are NAME, LAST_MODIFIED, and SIZE.")
    public static final ValueProperty PROP_INDEX_DIRECTORY_SORT_BY = new ValueProperty(TYPE, "IndexDirectorySortBy");
    @NamedValues(arbitraryValueLabel="check servlets at specified interval", defaultArbitraryValue="1", namedValues={@NamedValues.NamedValue(value="-1", label="never check servlets"), @NamedValues.NamedValue(value="0", label="constantly check servlets")})
    @Type(base=Integer.class)
    @XmlBinding(path="servlet-reload-check-secs")
    @Label(standard="interval (in seconds) to check servlets for changes to trigger reloading")
    @DefaultValue(text="1")
    @NumericRange(min="-1")
    @Documentation(content="Defines whether or not Oracle WebLogic Server will check a servlet modifications, and if the servlet has been modified, reloads it.[pbr/]The value -1 means never check the servlets. This is the default value in a production environment.[pbr/]The value 0 means always check the servlets.[pbr/]The value 1 means check the servlets every second. This is the default value in a development environment.[pbr/]A value specified in the console will always take precedence over a manually specified value.")
    public static final ValueProperty PROP_SERVLET_RELOAD_CHECK_SECS = new ValueProperty(TYPE, "ServletReloadCheckSecs");
    @NamedValues(arbitraryValueLabel="check resources at specified interval", defaultArbitraryValue="1", namedValues={@NamedValues.NamedValue(value="-1", label="never check resources"), @NamedValues.NamedValue(value="0", label="constantly check resources")})
    @Type(base=Integer.class)
    @XmlBinding(path="resource-reload-check-secs")
    @Label(standard="interval (in seconds) to check resources for changes to trigger reloading")
    @DefaultValue(text="1")
    @NumericRange(min="-1")
    @Documentation(content="Used to perform metadata caching for cached resources that are found in the resource path in the Web application scope. This parameter identifies how often Oracle WebLogic Server checks whether or not a resource has been modified, and if so, it reloads it.[pbr/]The value -1 means never reload. This is the default value in a production environment.[pbr/]The value 0 means always reload.[pbr/]The value 1 means reload every second. This is the default value in a development environment.[pbr/]Values specified for this parameter using the Admin Console are given precedence.")
    public static final ValueProperty PROP_RESOURCE_RELOAD_CHECK_SECS = new ValueProperty(TYPE, "ResourceReloadCheckSecs");
    @Type(base=Integer.class)
    @XmlBinding(path="single-threaded-servlet-pool-size")
    @Label(standard="single thread servlet pool size")
    @DefaultValue(text="5")
    @Deprecated
    @Documentation(content="Defines the size of the pool used for SingleThreadMode instance pools. The default value is 5.[pbr/]Note that SingleThreadMode instance pools are deprecated.")
    public static final ValueProperty PROP_SINGLE_THREADED_SERVLET_POOL_SIZE = new ValueProperty(TYPE, "SingleThreadedServletPoolSize");
    @Type(base=Boolean.class)
    @XmlBinding(path="session-monitoring-enabled")
    @Label(standard="enable session monitoring")
    @DefaultValue(text="false")
    @Deprecated
    @Documentation(content="If set to \"true\", allows run-time MBeans to be created for sessions. When set to \"false\" (default), run-time MBeans are not created. A value specified in the console takes precedence over manually set value.")
    public static final ValueProperty PROP_SESSION_MONITORING_ENABLED = new ValueProperty(TYPE, "SessionMonitoringEnabled");
    @Type(base=Boolean.class)
    @XmlBinding(path="save-sessions-enabled")
    @Label(standard="save session on redeploy of web app")
    @DefaultValue(text="false")
    @Documentation(content="Controls whether or not session data is cleaned up during redeploy or undeploy. It affects memory and replicated sessions. Setting the value to \"true\" means session data is saved. Setting to \"false\" means session data will be destroyed when the Web application is redeployed or undeployed.")
    public static final ValueProperty PROP_SAVE_SESSIONS_ENABLED = new ValueProperty(TYPE, "SaveSessionsEnabled");
    @XmlBinding(path="default-mime-type")
    @Label(standard="default MIME type")
    @Documentation(content="Allows to specify the default MIME type for a content-type for which the extension is not mapped.")
    public static final ValueProperty PROP_DEFAULT_MIME_TYPE = new ValueProperty(TYPE, "DefaultMimeType");
    @Type(base=Boolean.class)
    @XmlBinding(path="client-cert-proxy-enabled")
    @Label(standard="enable proxy client identity certificates")
    @DefaultValue(text="false")
    @Documentation(content="When set to \"true\", Oracle WebLogic Server passes identity certificates from the clients to the backend servers. Also, Oracle WebLogic Server is notified whether to honor or discard the incoming WL-Proxy-Client-Cert header.[pbr/]A proxy-server plugin encodes each identity certification in the WL-Proxy-Client-Cert header and passes it to the backend Oracle WebLogic Server instances. Each Oracle WebLogic Server instance takes the certificate information from the header, ensured it came from a secure source, and uses that information to authenticate the user. For the background Oracle WebLogic Server instances, this parameter must be set to \"true\" (either at the cluster/server level, or at the Web application level).[pbr/]If you set this element to \"true\", use a weblogic.security.net.ConnectionFilter to ensure that each Oracle WebLogic Server instance accepts connections only from the machine on which the proxy-server plugin is running. If you specify \"true\" without using a connection filter, a potential security vulnerability is created because the WL-Proxy-Client-Cert header can be spoofed.")
    public static final ValueProperty PROP_CLIENT_CERT_PROXY_ENABLED = new ValueProperty(TYPE, "ClientCertProxyEnabled");
    @Type(base=Boolean.class)
    @XmlBinding(path="relogin-enabled")
    @Label(standard="enable relogin after denied access")
    @DefaultValue(text="false")
    @Documentation(content="This is a backward compatibility parameter. If a user has logged in already and tries to access a resource for which they do not have privileges, a FORBIDDEN (403) response occurs.")
    public static final ValueProperty PROP_RELOGIN_ENABLED = new ValueProperty(TYPE, "ReloginEnabled");
    @Type(base=Boolean.class)
    @XmlBinding(path="allow-all-roles")
    @Label(standard="allow all roles within realm (versus web app)")
    @DefaultValue(text="false")
    @Documentation(content="In the security-constraints elements defined in the web.xml descriptor of a Web application, the \"auth-constraint\" element indicates the user roles that should be permitted access to this resource collection. Here role-name = \"*\" is a compact syntax for indicating all roles in the Web application. In past releases, role-name = \"*\" was treated as all users (or roles) defined within the realm.[pbr/]This \"allow-all-roles\" element is a backward compatibility switch to restore old behavior. The default behavior is to allow all roles defined in the Web application. The value specified in weblogic.xml takes precedence over the value defined in the WebAppContainerMBean.")
    public static final ValueProperty PROP_ALLOW_ALL_ROLES = new ValueProperty(TYPE, "AllowAllRoles");
    @Type(base=Boolean.class)
    @XmlBinding(path="native-io-enabled")
    @Label(standard="enable native IO for serving static files")
    @DefaultValue(text="false")
    @Documentation(content="To use native input-output while serving static files with weblogic.servlet.FileServlet, which is implicitly registered as the default servlet, set the \"native-io-enabled\" element to \"true\". [pbr/]Note that \"native-io-enabled\" element applies only on Windows OS.")
    public static final ValueProperty PROP_NATIVE_IO_ENABLED = new ValueProperty(TYPE, "NativeIoEnabled");
    @Type(base=Long.class)
    @XmlBinding(path="minimum-native-file-size")
    @Label(standard="minimum file size (bytes)")
    @Enablement(expr="${ NativeIoEnabled }")
    @DefaultValue(text="4096")
    @NumericRange(min="0")
    @Documentation(content="The \"minimum-native-file-size\" element applies only when \"native-io-enabled\" is set to \"true\". It sets the minimum file size for using native input-output. If the file being served is larger than this value, native input-output is used.")
    public static final ValueProperty PROP_MINIMUM_NATIVE_FILE_SIZE = new ValueProperty(TYPE, "MinimumNativeFileSize");
    @Type(base=Boolean.class)
    @XmlBinding(path="disable-implicit-servlet-mappings")
    @Label(standard="disable implicit servlet mapping")
    @DefaultValue(text="false")
    @Documentation(content="When the \"disable-implicit-servlet-mappings\" flag is set to \"true\", the Web application container does not create implicit mappings for internal servlets (*.jsp, *.class, and so on); only for the default servlet mapping. A typical use case for disabling implicit servlet mappings would be when configuring HttpClusterServlet or HttpProxyServlet.")
    public static final ValueProperty PROP_DISABLE_IMPLICIT_SERVLET_MAPPINGS = new ValueProperty(TYPE, "DisableImplicitServletMappings");
    @XmlBinding(path="temp-dir")
    @Label(standard="temp directory")
    @Documentation(content="Location of temporary directory for the Web application, as returned by \"javax.servlet.context.tempDir\" context attribute.")
    public static final ValueProperty PROP_TEMP_DIR = new ValueProperty(TYPE, "TempDir");
    @Type(base=Boolean.class)
    @XmlBinding(path="optimistic-serialization")
    @Label(standard="enable optimistic serialization")
    @DefaultValue(text="false")
    @Documentation(content="When \"optimistic-serialization\" is enabled, Oracle WebLogic Server neither serializes nor deserializes context and does not request attributes upon getAttribute(name) when the request is dispatched across servlet contexts.[pbr/]This means that you must ensure that the attributes common to Web applications are scoped to a common parent class loader (application-scoped), or you must place them in the system classpath if the two Web applications do not belong to the same application.[pbr/]When \"optimistic-serialization\" is disabled (default), Oracle WebLogic Server serializes and deserializes context, as well as requests attributes upon getAttribute(name) to avoid the possibility of ClassCastExceptions.[pbr/]The \"optimistic-serialization\" value can also be specified at domain level in the WebAppContainerMBean, which applies for all Web applications. The value in the weblogic.xml file, if specified, overrides the domain-level value.")
    public static final ValueProperty PROP_OPTIMISTIC_SERIALIZATION = new ValueProperty(TYPE, "OptimisticSerialization");
    @Type(base=Boolean.class)
    @XmlBinding(path="retain-original-url")
    @Label(standard="retain protocol from original URL after login")
    @DefaultValue(text="false")
    @Documentation(content="Used in FORM-based authentication scenarios. When this property is set to \"true\", after a successful authentication, Oracle Weblogic Server will redirect back to the Web resource (page or servlet) retaining the protocol (http or https) used to access the protected resource in the original request. If set to \"false\" (default), Oracle Weblogic Server will redirect back to the protected resource using the current protocol. You can also specify this setting at domain level in WebAppContainerMBean, in which case it will be applied to all the Web applications in the domain.")
    public static final ValueProperty PROP_RETAIN_ORIGINAL_URL = new ValueProperty(TYPE, "RetainOriginalUrl");
    @Type(base=Boolean.class)
    @XmlBinding(path="show-archived-real-path-enabled")
    @Label(standard="enable getRealPath() results for archived web apps")
    @DefaultValue(text="false")
    @Since(value="10.0")
    @Documentation(content="If the \"show-archived-real-path-enabled\" element is set to \"false\", then the servlet container will return real path of files in archived Web applications as \"null\".")
    public static final ValueProperty PROP_SHOW_ARCHIVED_REAL_PATH_ENABLED = new ValueProperty(TYPE, "ShowArchivedRealPathEnabled");
    @Type(base=Boolean.class)
    @XmlBinding(path="require-admin-traffic")
    @Label(standard="allow traffic through the admin channel")
    @DefaultValue(text="false")
    @Since(value="10.3")
    @Documentation(content="The \"require-admin-trafffic\" element defines whether or not traffic should go through the administration channel. When set to \"true\", traffic is allowed to go through the administration channel. Otherwise, traffic can only go through administration channel when the Web application is in administrative mode.")
    public static final ValueProperty PROP_REQUIRE_ADMIN_TRAFFIC = new ValueProperty(TYPE, "RequireAdminTraffic");
    @Type(base=Boolean.class)
    @XmlBinding(path="access-logging-disabled")
    @Label(standard="disable access logging")
    @DefaultValue(text="false")
    @Since(value="10.3")
    @Documentation(content="Defines whether to eliminate access logging of the underlying Web application. Setting this property to \"true\" improves server throughput by reducing the logging overhead. If the property is not specified or a \"false\" value is specified, application accesses are logged.")
    public static final ValueProperty PROP_ACCESS_LOGGING_DISABLED = new ValueProperty(TYPE, "AccessLoggingDisabled");
    @Type(base=Boolean.class)
    @Label(standard="prefer forward query string")
    @XmlBinding(path="prefer-forward-query-string")
    @DefaultValue(text="${ VersionMatches( Root().ServerVersion, '[12.1.1' ) ? true : false }")
    @Since(value="10.3.6")
    @Documentation(content="Specifies whether or not to prefer the forward query string in forward scenario.[pbr/]If it is set to true and the forward target URL contains a query string, only the new forward query string is used, and the existing query string sent by client or added in previous forwards is ignored. If the current forward does not specify any query string, the existing one is used.[pbr/]If it is set to false, all the query strings, including those sent from client and added in previous forwards, are add-up and the new forward query string appears in the front.")
    public static final ValueProperty PROP_PREFER_FORWARD_QUERY_STRING = new ValueProperty(TYPE, "PreferForwardQueryString");
    @Type(base=Boolean.class)
    @Label(standard="fail deploy on filter init error")
    @XmlBinding(path="fail-deploy-on-filter-init-error")
    @DefaultValue(text="true")
    @Since(value="12.1.1")
    @Documentation(content="specifies whether or not to proceed with deployment when an exception incurs in filter.init(). If it is set to \"false\", the  webapp deployment would proceed.[pbr/]This param is a backward compatibility switch to restore old behavior. Default behavior is consistent with the reference implementation, Glassfish.")
    public static final ValueProperty PROP_FAIL_DEPLOY_ON_FILTER_INIT_ERROR = new ValueProperty(TYPE, "FailDeployOnFilterInitError");
    @Type(base=Boolean.class)
    @Label(standard="send permanent redirects")
    @XmlBinding(path="send-permanent-redirects")
    @DefaultValue(text="false")
    @Since(value="12.1.1")
    @Documentation(content="specifies whether or not to HTTP 301 is sent (Permanent Redirect) during javax.servlet.HttpServletResponse.sendRedirect(location) call.")
    public static final ValueProperty PROP_SEND_PERMANENT_REDIRECTS = new ValueProperty(TYPE, "SendPermanentRedirects");
    @Type(base=Boolean.class)
    @Label(standard="enable container initializer")
    @XmlBinding(path="container-initializer-enabled")
    @DefaultValue(text="true")
    @Since(value="12.1.2")
    @Documentation(content="specifies whether or not the container should scan and process container-initializer which is specified in servlet spec 3.0")
    public static final ValueProperty PROP_CONTAINER_INITIALIZER_ENABLED = new ValueProperty(TYPE, "ContainerInitializerEnabled");

    public Value<Boolean> isCheckAuthOnForward();

    public void setCheckAuthOnForward(String var1);

    public void setCheckAuthOnForward(Boolean var1);

    public Value<Boolean> isFilterDispatchedRequestsEnabled();

    public void setFilterDispatchedRequestsEnabled(String var1);

    public void setFilterDispatchedRequestsEnabled(Boolean var1);

    public Value<String> getRedirectContentType();

    public void setRedirectContentType(String var1);

    public Value<String> getRedirectContent();

    public void setRedirectContent(String var1);

    public Value<Boolean> isRedirectWithAbsoluteUrl();

    public void setRedirectWithAbsoluteUrl(String var1);

    public void setRedirectWithAbsoluteUrl(Boolean var1);

    public Value<Boolean> isIndexDirectoryEnabled();

    public void setIndexDirectoryEnabled(String var1);

    public void setIndexDirectoryEnabled(Boolean var1);

    public Value<IndexDirectorySortOrder> getIndexDirectorySortBy();

    public void setIndexDirectorySortBy(String var1);

    public void setIndexDirectorySortBy(IndexDirectorySortOrder var1);

    public Value<Integer> getServletReloadCheckSecs();

    public void setServletReloadCheckSecs(String var1);

    public void setServletReloadCheckSecs(Integer var1);

    public Value<Integer> getResourceReloadCheckSecs();

    public void setResourceReloadCheckSecs(String var1);

    public void setResourceReloadCheckSecs(Integer var1);

    public Value<Integer> getSingleThreadedServletPoolSize();

    public void setSingleThreadedServletPoolSize(String var1);

    public void setSingleThreadedServletPoolSize(Integer var1);

    public Value<Boolean> isSessionMonitoringEnabled();

    public void setSessionMonitoringEnabled(String var1);

    public void setSessionMonitoringEnabled(Boolean var1);

    public Value<Boolean> isSaveSessionsEnabled();

    public void setSaveSessionsEnabled(String var1);

    public void setSaveSessionsEnabled(Boolean var1);

    public Value<String> getDefaultMimeType();

    public void setDefaultMimeType(String var1);

    public Value<Boolean> isClientCertProxyEnabled();

    public void setClientCertProxyEnabled(String var1);

    public void setClientCertProxyEnabled(Boolean var1);

    public Value<Boolean> isReloginEnabled();

    public void setReloginEnabled(String var1);

    public void setReloginEnabled(Boolean var1);

    public Value<Boolean> isAllowAllRoles();

    public void setAllowAllRoles(String var1);

    public void setAllowAllRoles(Boolean var1);

    public Value<Boolean> isNativeIoEnabled();

    public void setNativeIoEnabled(String var1);

    public void setNativeIoEnabled(Boolean var1);

    public Value<Long> getMinimumNativeFileSize();

    public void setMinimumNativeFileSize(String var1);

    public void setMinimumNativeFileSize(Long var1);

    public Value<Boolean> isDisableImplicitServletMappings();

    public void setDisableImplicitServletMappings(String var1);

    public void setDisableImplicitServletMappings(Boolean var1);

    public Value<String> getTempDir();

    public void setTempDir(String var1);

    public Value<Boolean> isOptimisticSerialization();

    public void setOptimisticSerialization(String var1);

    public void setOptimisticSerialization(Boolean var1);

    public Value<Boolean> isRetainOriginalUrl();

    public void setRetainOriginalUrl(String var1);

    public void setRetainOriginalUrl(Boolean var1);

    public Value<Boolean> isShowArchivedRealPathEnabled();

    public void setShowArchivedRealPathEnabled(String var1);

    public void setShowArchivedRealPathEnabled(Boolean var1);

    public Value<Boolean> isRequireAdminTraffic();

    public void setRequireAdminTraffic(String var1);

    public void setRequireAdminTraffic(Boolean var1);

    public Value<Boolean> isAccessLoggingDisabled();

    public void setAccessLoggingDisabled(String var1);

    public void setAccessLoggingDisabled(Boolean var1);

    public Value<Boolean> getPreferForwardQueryString();

    public void setPreferForwardQueryString(String var1);

    public void setPreferForwardQueryString(Boolean var1);

    public Value<Boolean> getFailDeployOnFilterInitError();

    public void setFailDeployOnFilterInitError(String var1);

    public void setFailDeployOnFilterInitError(Boolean var1);

    public Value<Boolean> getSendPermanentRedirects();

    public void setSendPermanentRedirects(String var1);

    public void setSendPermanentRedirects(Boolean var1);

    public Value<Boolean> getContainerInitializerEnabled();

    public void setContainerInitializerEnabled(String var1);

    public void setContainerInitializerEnabled(Boolean var1);
}

