/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import oracle.eclipse.tools.weblogic.descriptors.ISchedulingGuideline;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

@Label(standard="capacity constraint")
@Image(path="images/descriptors/work-managers/capacity-constraint.png")
@Documentation(content="Capacity constraint causes the server to reject requests only when it has reached its capacity. The default is -1. Note that the capacity includes all requests, queued or executing, from the constrained work set. Work is rejected either when an individual capacity threshold is exceeded or if the global capacity is exceeded. This constraint is independent of the global queue threshold.")
public interface ICapacityConstraint
extends ISchedulingGuideline {
    public static final ElementType TYPE = new ElementType(ICapacityConstraint.class);
    @Type(base=Integer.class)
    @Label(standard="capacity")
    @Required
    @NumericRange(min="-1")
    @XmlBinding(path="count")
    public static final ValueProperty PROP_CAPACITY = new ValueProperty(TYPE, "Capacity");

    public Value<Integer> getCapacity();

    public void setCapacity(String var1);

    public void setCapacity(Integer var1);
}

