/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IAsyncDescriptor
extends Element {
    public static final ElementType TYPE = new ElementType(IAsyncDescriptor.class);
    @NamedValues(arbitraryValueLabel="timeout (sec)", defaultArbitraryValue="120", namedValues={@NamedValues.NamedValue(value="-1", label="asynchronous job never timeout")})
    @Type(base=Integer.class)
    @XmlBinding(path="timeout-secs")
    @Label(standard="time that WebLogic Server waits before timing out an asynchronous job")
    @DefaultValue(text="120")
    @NumericRange(min="-1")
    @Since(value="12.1.1")
    @Documentation(content="Sets the time, in seconds, that WebLogic Server waits before timing out an asynchronous job.[pbr/]Setting the timeout to -1 indicates that the asynchronous job never times out.")
    public static final ValueProperty PROP_TIMEOUT_SECS = new ValueProperty(TYPE, "TimeoutSecs");
    @Type(base=Integer.class)
    @XmlBinding(path="timeout-check-interval-secs")
    @Label(standard="timeout check interval (sec)")
    @DefaultValue(text="30")
    @Since(value="12.1.1")
    @Documentation(content="Sets the time, in seconds, that WebLogic Server waits between doing checks for timed-out jobs.")
    public static final ValueProperty PROP_TIMEOUT_CHECK_INTERVAL_SECS = new ValueProperty(TYPE, "TimeoutCheckIntervalSecs");
    @XmlBinding(path="async-work-manager")
    @Label(standard="async work manager")
    @Since(value="12.1.1")
    @Documentation(content="Specifies a Work Manager for asynchronous jobs, including asynchronous dispatches initiated using the AsyncContext dispatch methods and runnable jobs started using the AsyncContext start method. If no Work Manager is specified, the asynchronous jobs will be executed in the current request Work Manager.")
    public static final ValueProperty PROP_ASYNC_WORK_MANAGER = new ValueProperty(TYPE, "AsyncWorkManager");

    public Value<Integer> getTimeoutSecs();

    public void setTimeoutSecs(String var1);

    public void setTimeoutSecs(Integer var1);

    public Value<Integer> getTimeoutCheckIntervalSecs();

    public void setTimeoutCheckIntervalSecs(String var1);

    public void setTimeoutCheckIntervalSecs(Integer var1);

    public Value<String> getAsyncWorkManager();

    public void setAsyncWorkManager(String var1);
}

