/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.credential.model;

import java.util.Set;
import oracle.eclipse.tools.weblogic.credential.keystore.model.IKeystore;
import oracle.eclipse.tools.weblogic.credential.keystore.model.IKeystoreEntry;
import oracle.eclipse.tools.weblogic.credential.keystore.model.KeystoreResource;
import oracle.eclipse.tools.weblogic.credential.model.IX509Certificates;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.services.PossibleValuesService;

public class CertAliasValueProvider
extends PossibleValuesService {
    protected void fillPossibleValues(Set<String> values) {
        IX509Certificates x509Cert = (IX509Certificates)this.context().find(IX509Certificates.class);
        Path p = (Path)x509Cert.getX509ServerKeystore().content();
        String path = p != null ? p.toPortableString() : null;
        String passwd = (String)x509Cert.getX509ServerKeystorePassword().content();
        if (path == null || passwd == null) {
            return;
        }
        try {
            KeystoreResource res = new KeystoreResource(path, passwd);
            res.refresh();
            IKeystore kstore = (IKeystore)IKeystore.TYPE.instantiate((Resource)res);
            for (IKeystoreEntry e : kstore.getKeystoreEntries()) {
                String type = (String)e.getType().content();
                if (type.indexOf("CertEntry") < 0) continue;
                String alias = (String)e.getName().content();
                values.add(alias);
            }
            kstore.dispose();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}

