/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.credential.keystore.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import oracle.eclipse.tools.weblogic.credential.keystore.model.ICertificateEntry;
import oracle.eclipse.tools.weblogic.credential.keystore.model.IKeystore;
import oracle.eclipse.tools.weblogic.credential.keystore.model.IKeystoreEntry;
import oracle.eclipse.tools.weblogic.credential.keystore.model.IPrivateKeyEntry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.LayeredListPropertyBinding;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.modeling.ResourceStoreException;

public class KeystoreResource
extends Resource {
    KeyStore ks;
    String type = null;
    String provider = null;
    List<Entry> entries = new ArrayList<Entry>();
    String storePath;
    String passwd;

    public KeystoreResource(String storePath, String passwd) throws Exception {
        super(null);
        this.storePath = storePath;
        this.passwd = passwd;
        this.loadKeystore();
    }

    public String getStorePath() {
        return this.storePath;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public KeyStore getKeyStore() {
        return this.ks;
    }

    public void save() throws ResourceStoreException {
        super.save();
        try {
            if (this.ks != null) {
                try (FileOutputStream fis = null;){
                    fis = new FileOutputStream(new File(this.storePath));
                    this.ks.store(fis, this.getPasswd().toCharArray());
                }
            }
            this.loadKeystore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == IKeystore.PROP_TYPE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return KeystoreResource.this.type;
                }

                public void write(String value) {
                }
            };
        }
        if (p == IKeystore.PROP_PROVIDER) {
            return new ValuePropertyBinding(){

                public String read() {
                    return KeystoreResource.this.provider;
                }

                public void write(String value) {
                }
            };
        }
        if (p == IKeystore.PROP_KEYSTORE_ENTRIES) {
            LayeredListPropertyBinding listBinding = new LayeredListPropertyBinding(){

                protected List<?> readUnderlyingList() {
                    return KeystoreResource.this.entries;
                }

                protected Resource resource(Object obj) {
                    Entry entry = (Entry)obj;
                    if (entry.keyStoreEntry instanceof Certificate) {
                        return new CertificateEntryResource(KeystoreResource.this, obj);
                    }
                    return new PrivateKeyEntryResource(KeystoreResource.this, obj);
                }

                public ElementType type(Resource obj) {
                    if (obj instanceof CertificateEntryResource) {
                        return ICertificateEntry.TYPE;
                    }
                    return IPrivateKeyEntry.TYPE;
                }

                public void remove(Resource resource) {
                    KeystoreEntryResource res = (KeystoreEntryResource)resource;
                    IKeystoreEntry ke = (IKeystoreEntry)res.element();
                    String alias = (String)ke.getName().content();
                    if (alias.startsWith("wlsdemo") || alias.startsWith("wlscertgencab") || alias.startsWith("certgenca") || alias.startsWith("demoidentity")) {
                        return;
                    }
                    try {
                        KeystoreResource.this.ks.deleteEntry(alias);
                    }
                    catch (KeyStoreException e) {
                        e.printStackTrace();
                    }
                    KeystoreResource.this.refresh();
                }
            };
            return listBinding;
        }
        return null;
    }

    public void loadKeystore() throws Exception {
        char[] password = this.passwd.toCharArray();
        FileInputStream fis = null;
        try {
            this.ks = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(this.storePath);
            this.ks.load(fis, password);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public IStatus refresh() {
        this.entries.clear();
        try {
            char[] password = this.passwd.toCharArray();
            this.provider = this.ks.getProvider().getName();
            this.type = this.ks.getType();
            Enumeration<String> enu = this.ks.aliases();
            while (enu.hasMoreElements()) {
                String alias = enu.nextElement();
                Entry e = new Entry();
                e.name = alias;
                if (this.ks.isCertificateEntry(alias)) {
                    Certificate c = this.ks.getCertificate(alias);
                    e.keyStoreEntry = c;
                    e.certificateChain = c.toString();
                } else {
                    try {
                        Key k = this.ks.getKey(alias, password);
                        e.keyStoreEntry = k;
                        e.certificateChain = k.toString();
                    }
                    catch (UnrecoverableKeyException unrecoverableKeyException) {
                        e.certificateChain = "Unable to display detail of the private key since it is protected by a password different from the keystore password";
                    }
                }
                this.entries.add(e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    class CertificateEntryResource
    extends KeystoreEntryResource {
        public CertificateEntryResource(Resource parent, Object obj) {
            super(parent, obj);
        }
    }

    static class Entry {
        String name;
        String certificateChain = null;
        Object keyStoreEntry;

        Entry() {
        }

        public String getType() {
            if (this.keyStoreEntry instanceof Certificate) {
                return "CertificateEntry";
            }
            return "PrivateKeyEntry";
        }
    }

    class KeystoreEntryResource
    extends Resource {
        Entry e;

        public KeystoreEntryResource(Resource parent, Object obj) {
            super(parent);
            this.e = (Entry)obj;
        }

        protected PropertyBinding createBinding(Property property) {
            PropertyDef p = property.definition();
            if (p == IKeystoreEntry.PROP_TYPE) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return KeystoreEntryResource.this.e.getType();
                    }

                    public void write(String value) {
                    }
                };
            }
            if (p == IKeystoreEntry.PROP_NAME) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return KeystoreEntryResource.this.e.name;
                    }

                    public void write(String value) {
                    }
                };
            }
            if (p == IKeystoreEntry.PROP_EXPIRY) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return "";
                    }

                    public void write(String value) {
                    }
                };
            }
            if (p == IKeystoreEntry.PROP_CERTIFICATE_CHAIN) {
                return new ValuePropertyBinding(){

                    public String read() {
                        return KeystoreEntryResource.this.e.certificateChain;
                    }

                    public void write(String value) {
                    }
                };
            }
            return null;
        }
    }

    class PrivateKeyEntryResource
    extends KeystoreEntryResource {
        public PrivateKeyEntryResource(Resource parent, Object obj) {
            super(parent, obj);
        }
    }
}

