/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.appmodel.internal;

import oracle.eclipse.tools.weblogic.appmodel.IModule;
import oracle.eclipse.tools.weblogic.appmodel.IModuleDependency;
import oracle.eclipse.tools.weblogic.appmodel.IWebLogicJdbcConfigRef;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public final class WebLogicJdbcConfigRefLocationValidator
extends ValidationService {
    private Listener listener;

    protected void initValidationService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                WebLogicJdbcConfigRefLocationValidator.this.refresh();
            }
        };
        ((IWebLogicJdbcConfigRef)this.context(IWebLogicJdbcConfigRef.class)).attach(this.listener, "../Dependencies[#type=IWebLogicJdbcConfigRef]/Location");
    }

    protected Status compute() {
        Value value = (Value)this.context(Value.class);
        IWebLogicJdbcConfigRef element = (IWebLogicJdbcConfigRef)value.element().nearest(IWebLogicJdbcConfigRef.class);
        Path path = (Path)value.content();
        if (path != null) {
            for (IModuleDependency dep : ((IModule)element.nearest(IModule.class)).getDependencies()) {
                Path p;
                if (!(dep instanceof IWebLogicJdbcConfigRef) || dep == element || !path.equals((Object)(p = (Path)((IWebLogicJdbcConfigRef)dep).getLocation().content()))) continue;
                String msg = NLS.bind((String)Resources.multipleIdenticalJdbcDependencies, (Object)path.toPortableString());
                return Status.createErrorStatus((String)msg);
            }
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path.toPortableString());
            if (resource != null && resource instanceof IFile) {
                IFile file = (IFile)resource;
                IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
                IContentDescription contentDescription = null;
                try {
                    contentDescription = contentTypeManager.getDescriptionFor(file.getContents(), file.getName(), IContentDescription.ALL);
                }
                catch (Exception e) {
                    WlsCorePlugin.logException(e);
                }
                if (contentDescription == null || !contentDescription.getContentType().getId().equals("oracle.eclipse.tools.weblogic.descriptors.JdbcConfiguration")) {
                    String msg = NLS.bind((String)Resources.notJdbcConfiguration, (Object)path.toPortableString());
                    return Status.createErrorStatus((String)msg);
                }
            }
        }
        return Status.createOkStatus();
    }

    public void dispose() {
        if (this.listener != null) {
            ((IWebLogicJdbcConfigRef)this.context(IWebLogicJdbcConfigRef.class)).detach(this.listener, "../Dependencies[#type=IWebLogicJdbcConfigRef]/Location");
            this.listener = null;
        }
        super.dispose();
    }

    private static final class Resources
    extends NLS {
        public static String multipleIdenticalJdbcDependencies;
        public static String notJdbcConfiguration;

        static {
            Resources.initializeMessages((String)WebLogicJdbcConfigRefLocationValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

