/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.applib;

import oracle.eclipse.tools.common.util.jdt.JavaProjectUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public final class AppLibrariesContainer {
    public static final String CONTAINER_ID = "oracle.eclipse.tools.weblogic.lib.application";
    public static final String LEGACY_CONTAINER_ID = "com.bea.workshop.wls.core.AppLibrariesContainer";

    public static boolean isAppLibrariesContainer(IClasspathEntry cpe) {
        IPath path = cpe.getPath();
        if (path.segmentCount() > 0) {
            String firstSegment = path.segment(0);
            return firstSegment.equals(CONTAINER_ID) || firstSegment.equals(LEGACY_CONTAINER_ID);
        }
        return false;
    }

    public static boolean isOnClasspath(IProject project) throws CoreException {
        if (JavaProjectUtil.isJavaProject((IProject)project)) {
            return AppLibrariesContainer.isOnClasspath(JavaCore.create((IProject)project));
        }
        return false;
    }

    public static boolean isOnClasspath(IJavaProject project) throws CoreException {
        IClasspathEntry[] cp;
        IClasspathEntry[] iClasspathEntryArray = cp = project.getRawClasspath();
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (AppLibrariesContainer.isAppLibrariesContainer(cpe)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void addToClasspath(IProject project, IProject referencedEarProject) throws CoreException {
        if (JavaProjectUtil.isJavaProject((IProject)project)) {
            AppLibrariesContainer.addToClasspath(JavaCore.create((IProject)project), referencedEarProject);
        }
    }

    public static void addToClasspath(IJavaProject project, IProject referencedEarProject) throws CoreException {
        if (!AppLibrariesContainer.isOnClasspath(project)) {
            IClasspathEntry[] oldcp = project.getRawClasspath();
            IClasspathEntry[] newcp = new IClasspathEntry[oldcp.length + 1];
            System.arraycopy(oldcp, 0, newcp, 0, oldcp.length);
            IPath path = new Path(CONTAINER_ID).append(referencedEarProject.getName());
            newcp[newcp.length - 1] = JavaCore.newContainerEntry((IPath)path);
            project.setRawClasspath(newcp, null);
        }
    }

    public static void removeFromClasspath(IProject project) throws CoreException {
        if (JavaProjectUtil.isJavaProject((IProject)project)) {
            AppLibrariesContainer.removeFromClasspath(JavaCore.create((IProject)project));
        }
    }

    public static void removeFromClasspath(IJavaProject project) throws CoreException {
        IClasspathEntry[] oldcp = project.getRawClasspath();
        int i = 0;
        while (i < oldcp.length) {
            if (AppLibrariesContainer.isAppLibrariesContainer(oldcp[i])) {
                IClasspathEntry[] newcp = new IClasspathEntry[oldcp.length - 1];
                System.arraycopy(oldcp, 0, newcp, 0, i);
                System.arraycopy(oldcp, i + 1, newcp, i, oldcp.length - i - 1);
                project.setRawClasspath(newcp, null);
                return;
            }
            ++i;
        }
    }
}

