/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.fileio.ZipUtil;
import oracle.eclipse.tools.weblogic.DescriptorInfo;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.server.internal.util.FacetUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.ContentModelManager;
import org.osgi.framework.Bundle;

public class WlsDescriptorCatalog {
    static final String WST_XML_CORE_BUNDLE_ID = "org.eclipse.wst.xml.core";
    static final String JST_STANDARD_SCHEMA_BUNDLE_ID = "org.eclipse.jst.standard.schemas";
    static final String CATALOG_EXT_ID = "catalogContributions";
    private static WlsDescriptorCatalog instance = null;
    private static final String CATALOG_CACHE_FILE = "descriptor.schemas/wls-descriptor-catalog.txt";
    private TreeSet<String> wlsDescriptorTypes = new TreeSet();
    private HashMap<String, String> wlsDescriptorFileMap = new HashMap();

    private WlsDescriptorCatalog() {
        this.initialize();
        this.wlsDescriptorFileMap.put("weblogic.xml", "weblogic-web-app");
        this.wlsDescriptorFileMap.put("persistence-configuration.xml", "persistence-configuration");
        this.wlsDescriptorFileMap.put("weblogic-diagnostics.xml", "wldf-resource");
        this.wlsDescriptorFileMap.put("weblogic-webservices-policy.xml", "webservice-policy-ref");
    }

    private void initialize() {
        Bundle wlsCoreBundle = Platform.getBundle((String)"oracle.eclipse.tools.weblogic");
        URL url = FileLocator.find((Bundle)wlsCoreBundle, (IPath)new Path(CATALOG_CACHE_FILE), null);
        if (url != null) {
            this.loadFromCache(url);
        } else {
            this.loadFromRegistry();
        }
    }

    private void loadFromRegistry() {
        Collection extensions = PluginUtil.findExtensions((String)WST_XML_CORE_BUNDLE_ID, (String)CATALOG_EXT_ID);
        for (IExtension ext : extensions) {
            IConfigurationElement[] systems;
            String ns = ext.getNamespaceIdentifier();
            if (!ns.equals("oracle.eclipse.tools.weblogic")) continue;
            IConfigurationElement[] cfgElms = ext.getConfigurationElements();
            IConfigurationElement[] iConfigurationElementArray = systems = cfgElms[0].getChildren("system");
            int n = systems.length;
            int n2 = 0;
            while (n2 < n) {
                CMNode rootElement;
                IConfigurationElement cfg = iConfigurationElementArray[n2];
                String systemId = cfg.getAttribute("systemId");
                String wlsVersionString = "10.3.1";
                if (systemId.startsWith("http://www.bea.com/ns")) {
                    wlsVersionString = systemId.startsWith("http://www.bea.com/ns/weblogic/10.0") ? "10.0" : (systemId.startsWith("http://www.bea.com/ns/weblogic/90") ? "9.2" : (systemId.startsWith("http://www.bea.com/ns/weblogic/91") ? "9.2" : (systemId.startsWith("http://www.bea.com/ns/weblogic/920") ? "9.2" : "10.3.0")));
                }
                WebLogicServerVersion wlsVersion = WebLogicServerVersion.convert(wlsVersionString);
                ICatalog catalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
                String uri = systemId;
                try {
                    uri = catalog.resolveSystem(systemId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                CMDocument xsdDoc = ContentModelManager.getInstance().createCMDocument(uri, null);
                if (xsdDoc != null && (rootElement = xsdDoc.getElements().item(0)) != null) {
                    int n3 = xsdDoc.getElements().getLength();
                    int i = 0;
                    while (i < n3) {
                        rootElement = xsdDoc.getElements().item(i);
                        String type = rootElement.getNodeName();
                        this.wlsDescriptorTypes.add(type);
                        DescriptorInfo info = new DescriptorInfo();
                        info.type = type;
                        info.namespace = (String)xsdDoc.getProperty("http://org.eclipse.wst/cm/properties/targetNamespaceURI");
                        info.uri = systemId;
                        wlsVersion.addDescriptor(info);
                        System.out.println((Object)((Object)wlsVersion) + "," + type + "," + systemId + "," + info.namespace);
                        ++i;
                    }
                }
                ++n2;
            }
        }
    }

    private void loadFromCache(URL url) {
        try {
            BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(url.openStream()), StandardCharsets.UTF_8));
            String line = bf.readLine();
            while (line != null) {
                String[] data = line.split(",");
                WebLogicServerVersion wlsVersion = WebLogicServerVersion.convert(data[0]);
                if (wlsVersion != null) {
                    DescriptorInfo info = new DescriptorInfo();
                    info.type = data[1];
                    info.uri = data[2];
                    info.namespace = data[3];
                    this.wlsDescriptorTypes.add(info.type);
                    wlsVersion.addDescriptor(info);
                }
                line = bf.readLine();
            }
            bf.close();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public static synchronized WlsDescriptorCatalog getInstance() {
        if (instance == null) {
            instance = new WlsDescriptorCatalog();
        }
        return instance;
    }

    public String getDescriptorType(String fileName) {
        String ret = this.wlsDescriptorFileMap.get(fileName);
        if (fileName.endsWith("-jdbc.xml")) {
            ret = "jdbc-data-source";
        }
        if (fileName.endsWith("-jms.xml")) {
            ret = "weblogic-jms";
        }
        if (ret == null) {
            ret = fileName;
            if (fileName.indexOf(46) > 0) {
                ret = fileName.substring(0, fileName.lastIndexOf("."));
            }
        }
        return ret;
    }

    public String findDescriptorUri(WebLogicServerVersion version, String type) {
        DescriptorInfo info = version.findDescriptor(type);
        if (info == null) {
            WebLogicServerVersion[] versions = WebLogicServerVersion.values();
            ArrayList<WebLogicServerVersion> olderVersions = new ArrayList<WebLogicServerVersion>();
            WebLogicServerVersion[] webLogicServerVersionArray = versions;
            int n = versions.length;
            int n2 = 0;
            while (n2 < n) {
                WebLogicServerVersion ver = webLogicServerVersionArray[n2];
                if (ver == version) break;
                olderVersions.add(0, ver);
                ++n2;
            }
            for (WebLogicServerVersion ver : olderVersions) {
                info = ver.findDescriptor(type);
                if (info == null) continue;
                return info.uri;
            }
            return null;
        }
        return info.uri;
    }

    public TreeSet<String> getDescriptorTypes() {
        return this.wlsDescriptorTypes;
    }

    public Collection<String> getDescriptorFileNames(WebLogicServerVersion version, String moduleType) {
        ArrayList<String> ret = new ArrayList<String>();
        String rtPath = "";
        if (moduleType.equals("ear")) {
            ret.add("META-INF/weblogic-application.xml");
        } else {
            if (moduleType.equals("jms") || moduleType.equals("jdbc")) {
                return ret;
            }
            if (moduleType.equals("war")) {
                ret.add("WEB-INF/weblogic.xml");
                rtPath = "WEB-INF/classes/META-INF/";
            }
            if (moduleType.equals("ejb")) {
                ret.add("META-INF/weblogic-ejb-jar.xml");
                rtPath = "META-INF/";
            }
            ret.add(String.valueOf(rtPath) + "weblogic-rdbms-jar.xml");
            ret.add(String.valueOf(rtPath) + "persistence-configuration.xml");
            ret.add(String.valueOf(rtPath) + "weblogic-webservices.xml");
            ret.add(String.valueOf(rtPath) + "weblogic-wsee-clientHandlerChain.xml");
            ret.add(String.valueOf(rtPath) + "webservice-policy-ref.xml");
            ret.add(String.valueOf(rtPath) + "weblogic-wsee-standaloneclient.xml");
            ret.add(String.valueOf(rtPath) + "weblogic-ra.xml");
        }
        ret.add("META-INF/weblogic-diagnostics.xml");
        return ret;
    }

    public static void findDescriptorsInModule(IProject proj, String appName, String moduleName, Collection<String> ret) {
        try {
            if (FacetedProjectFramework.hasProjectFacet((IProject)proj, (String)"jst.ear")) {
                IVirtualComponent comp = ComponentCore.createComponent((IProject)proj);
                if (comp == null) {
                    return;
                }
                if (moduleName.equals(comp.getDeployedName())) {
                    IVirtualFolder rootFolder = comp.getRootFolder();
                    WlsDescriptorCatalog.visitVirtualFolders(rootFolder, ret);
                } else {
                    WlsDescriptorCatalog.addDescriptorsFromProject(proj, moduleName, ret);
                }
            } else if (FacetedProjectFramework.hasProjectFacet((IProject)proj, (String)"jst.web") || FacetedProjectFramework.hasProjectFacet((IProject)proj, (String)"jst.ejb")) {
                IVirtualComponent comp = ComponentCore.createComponent((IProject)proj);
                IVirtualFolder compFolder = comp.getRootFolder();
                WlsDescriptorCatalog.visitVirtualFolders(compFolder, ret);
            } else {
                IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(appName);
                if (res instanceof IProject) {
                    proj = (IProject)res;
                    WlsDescriptorCatalog.addDescriptorsFromProject(proj, moduleName, ret);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private static void addDescriptorsFromProject(IProject proj, String overridenModuleName, Collection<String> ret) {
        IVirtualReference[] refs;
        IVirtualComponent comp = ComponentCore.createComponent((IProject)proj);
        if (comp == null) {
            return;
        }
        String ext = FacetUtil.getResourceExtension(proj);
        String archiveName = String.valueOf(comp.getDeployedName()) + ext;
        if (archiveName.equals(overridenModuleName)) {
            IVirtualFolder compFolder = comp.getRootFolder();
            WlsDescriptorCatalog.visitVirtualFolders(compFolder, ret);
            return;
        }
        IVirtualReference[] iVirtualReferenceArray = refs = comp.getReferences();
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualReference ref = iVirtualReferenceArray[n2];
            String name = ref.getArchiveName();
            if (name.equals(overridenModuleName)) {
                IVirtualComponent refComp = ref.getReferencedComponent();
                if (refComp instanceof VirtualArchiveComponent) {
                    VirtualArchiveComponent archComp = (VirtualArchiveComponent)refComp;
                    if (archComp.getFileExtension().equals("war") || archComp.getFileExtension().equals("jar")) {
                        File file = archComp.getUnderlyingDiskFile();
                        try {
                            ZipFile zip = ZipUtil.open((File)file);
                            Enumeration<? extends ZipEntry> itr = zip.entries();
                            while (itr.hasMoreElements()) {
                                ZipEntry zipentry = itr.nextElement();
                                String path = zipentry.getName();
                                if (!path.endsWith(".xml")) continue;
                                if (path.startsWith("/")) {
                                    path = path.substring(1);
                                }
                                if (path.startsWith("META-INF/") || path.startsWith("WEB-INF/")) {
                                    ret.add(path);
                                    continue;
                                }
                                if (!path.endsWith("-jms.xml") && !path.startsWith("-jdbc.xml")) continue;
                                ret.add(path);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                } else if (refComp instanceof J2EEModuleVirtualComponent) {
                    IVirtualFolder compFolder = refComp.getRootFolder();
                    WlsDescriptorCatalog.visitVirtualFolders(compFolder, ret);
                }
            }
            ++n2;
        }
    }

    private static void visitVirtualFolders(IVirtualFolder compFolder, Collection<String> set) {
        try {
            IVirtualResource[] members;
            IVirtualResource[] iVirtualResourceArray = members = compFolder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IVirtualResource res = iVirtualResourceArray[n2];
                if (res instanceof IVirtualFolder) {
                    WlsDescriptorCatalog.visitVirtualFolders((IVirtualFolder)res, set);
                } else {
                    IVirtualFile file = (IVirtualFile)res;
                    if (file.getFileExtension().equals("xml")) {
                        String path = file.getRuntimePath().toString();
                        if (path.startsWith("/")) {
                            path = path.substring(1);
                        }
                        if (path.startsWith("META-INF/") || path.startsWith("WEB-INF/")) {
                            set.add(path);
                        } else if (path.endsWith("-jms.xml") || path.endsWith("-jdbc.xml")) {
                            set.add(path);
                        }
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

