/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IWlsAdapterListener;
import oracle.eclipse.tools.weblogic.server.IWlsDeployRuntime;
import oracle.eclipse.tools.weblogic.server.WlsDeployRuntimeFactory;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerRuntime;
import oracle.eclipse.tools.weblogic.wlst.IWLSTRunner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.project.facet.core.util.internal.FileUtil;
import org.eclipse.wst.server.core.IRuntime;

public class WLSTRunnerUtil {
    static Hashtable<String, IWLSTRunner> WLSTRunnerCache = new Hashtable();

    public static synchronized String runWLSTScript(WeblogicServer ws, InputStream scriptFileInputStream, HashMap<String, String> extraProps, IProgressMonitor monitor) throws CoreException {
        String ret;
        block10: {
            ret = "";
            try {
                try {
                    IWLSTRunner runner = WLSTRunnerUtil.findWLSTRunner(ws.getServer().getRuntime());
                    if (runner != null) {
                        BufferedReader br = new BufferedReader(new InputStreamReader(scriptFileInputStream, StandardCharsets.UTF_8));
                        StringBuffer script = new StringBuffer();
                        String line = br.readLine();
                        while (line != null) {
                            script.append(line);
                            script.append("\n");
                            line = br.readLine();
                        }
                        String source = script.toString();
                        HashMap<String, String> props = new HashMap<String, String>();
                        props.put("%USER_NAME%", ws.getCredentialInfo().getUsername());
                        props.put("%PASS_WORD%", ws.getCredentialInfo().getPassword());
                        props.put("%HOST_NAME%", ws.getHostname());
                        props.put("%PORT%", "" + ws.getPort());
                        props.put("%ADMIN_SERVER%", ws.getServerInfo().getServerName());
                        props.put("%DOMAIN_PATH%", ws.getDomainPath().toPortableString());
                        if (extraProps != null) {
                            props.putAll(extraProps);
                        }
                        for (Map.Entry entry : props.entrySet()) {
                            source = source.replaceAll((String)entry.getKey(), (String)entry.getValue());
                        }
                        if ("true".equals(System.getProperty("debugJmsWLSTScript"))) {
                            File tmp = File.createTempFile("OEPE-WLST-", ".py");
                            FileUtil.writeFile((File)tmp, (String)(String.valueOf(source) + "\n"));
                        }
                        String path = ws.getWeblogicHome().toPortableString();
                        WLSTRunnerUtil.setWLSTSystemProperties(path);
                        ret = runner.executeWLST(source, monitor);
                        break block10;
                    }
                    throw new Exception("WLST Runtime not found for " + ws.getDomainPath().toPortableString());
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.weblogic", 0, "Error executing WLST script", (Throwable)e));
                }
            }
            finally {
                WLSTRunnerUtil.resetWLSTSystemProperties();
            }
        }
        return ret;
    }

    public static synchronized String runWLSTScript(IRuntime rt, InputStream scriptFileInputStream, HashMap<String, String> extraProps, IProgressMonitor monitor) throws CoreException {
        String ret;
        block10: {
            ret = "";
            try {
                try {
                    monitor.setTaskName("Initializing WLST");
                    IWLSTRunner runner = WLSTRunnerUtil.findWLSTRunner(rt);
                    if (runner != null) {
                        BufferedReader br = new BufferedReader(new InputStreamReader(scriptFileInputStream, "UTF-8"));
                        StringBuffer script = new StringBuffer();
                        String line = br.readLine();
                        while (line != null) {
                            script.append(line);
                            script.append("\n");
                            line = br.readLine();
                        }
                        String source = script.toString();
                        HashMap<String, String> props = new HashMap<String, String>();
                        if (extraProps != null) {
                            props.putAll(extraProps);
                        }
                        for (Map.Entry entry : props.entrySet()) {
                            source = source.replaceAll((String)entry.getKey(), (String)entry.getValue());
                        }
                        if ("true".equals(System.getProperty("debugJmsWLSTScript"))) {
                            File tmp = File.createTempFile("OEPE-WLST-", ".py");
                            FileUtil.writeFile((File)tmp, (String)(String.valueOf(source) + "\n"));
                        }
                        monitor.setTaskName("Generating WLST script");
                        String path = rt.getLocation().toPortableString();
                        WLSTRunnerUtil.setWLSTSystemProperties(path);
                        monitor.setTaskName("Executing WLST script");
                        ret = runner.executeWLST(source, monitor);
                        break block10;
                    }
                    throw new Exception("WLST Runtime not found for " + rt.getLocation().toPortableString());
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.weblogic", 0, "Error executing WLST script", (Throwable)e));
                }
            }
            finally {
                WLSTRunnerUtil.resetWLSTSystemProperties();
            }
        }
        return ret;
    }

    public static synchronized String runWLSTScriptInCommandLine(IRuntime rt, InputStream scriptFileInputStream, HashMap<String, String> extraProps, IProgressMonitor monitor) throws CoreException {
        StringBuffer ret = new StringBuffer();
        StringBuffer script = new StringBuffer();
        try {
            try {
                monitor.beginTask("Executing WLST script", 50);
                BufferedReader br = new BufferedReader(new InputStreamReader(scriptFileInputStream, "UTF-8"));
                String line = br.readLine();
                while (line != null) {
                    script.append(line);
                    script.append("\n");
                    line = br.readLine();
                }
                monitor.worked(10);
                String source = script.toString();
                HashMap<String, String> props = new HashMap<String, String>();
                if (extraProps != null) {
                    props.putAll(extraProps);
                }
                for (Map.Entry entry : props.entrySet()) {
                    source = source.replaceAll((String)entry.getKey(), (String)entry.getValue());
                }
                script = new StringBuffer(source);
                File tmp = File.createTempFile("OEPE-WLST-", ".py");
                FileUtil.writeFile((File)tmp, (String)(String.valueOf(source) + "\n"));
                WlsCorePlugin.getInstance().getLog().log((IStatus)new Status(1, "oracle.eclipse.tools.weblogic", "Executing WLST script:" + source));
                List<String> cmdLine = WLSTRunnerUtil.getWlstScriptCmd(rt);
                cmdLine.add(tmp.getCanonicalPath());
                String[] cmd = cmdLine.toArray(new String[cmdLine.size()]);
                monitor.worked(10);
                ProcessBuilder processBuilder = new ProcessBuilder(cmd);
                processBuilder.redirectErrorStream();
                File workingDirectory = new File(cmd[0]).getParentFile();
                processBuilder.directory(workingDirectory);
                Map<String, String> env = processBuilder.environment();
                WeblogicServerRuntime WlsRuntime = (WeblogicServerRuntime)rt.loadAdapter(WeblogicServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
                if (WlsRuntime.getDefaultJavaVmLocation() == null) {
                    try {
                        String mwHomePath = WlsRuntimeUtil.getMwHome(rt.getLocation().toFile()).getCanonicalPath();
                        env.put("MW_HOME", new File(mwHomePath).getCanonicalPath().replace('\\', '/'));
                        env.put("JAVA_HOME", WlsRuntime.getJavaVmLocation().toPortableString());
                    }
                    catch (IOException iOException) {}
                }
                Process proc = processBuilder.start();
                IWlsAdapterListener adapter = WlsRuntimeUtil.getWlsAdapter();
                if (adapter != null) {
                    adapter.captureScriptStart(proc, new String[]{"Executing WLST script..."}, "UTF-8");
                }
                proc.waitFor();
                if (adapter != null) {
                    adapter.captureScriptFinish();
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.weblogic", 0, "Error executing WLST script", (Throwable)e));
            }
            catch (InterruptedException e) {
                throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.weblogic", 0, "Error executing WLST script", (Throwable)e));
            }
        }
        finally {
            WLSTRunnerUtil.resetWLSTSystemProperties();
        }
        return String.valueOf(script.toString()) + "\n" + ret.toString();
    }

    static synchronized IWLSTRunner findWLSTRunner(IRuntime rt) {
        IWlsDeployRuntime runtime;
        IWLSTRunner runner = WLSTRunnerCache.get(rt.getId());
        if (runner == null && (runtime = WlsDeployRuntimeFactory.create(rt)) != null) {
            runner = runtime.getWLSTRunner();
            WLSTRunnerCache.put(rt.getId(), runner);
        }
        return runner;
    }

    static void setWLSTSystemProperties(String wlsPath) {
        System.setProperty("prod.props.file", String.valueOf(wlsPath) + "/.product.properties");
        System.setProperty("platform.home", wlsPath);
        System.setProperty("wls.home", String.valueOf(wlsPath) + "/server");
    }

    static void resetWLSTSystemProperties() {
        System.setProperty("wls.home", "");
        System.setProperty("platform.home", "");
        System.setProperty("prod.props.file", "");
    }

    public static List<String> getWlstScriptCmd(IRuntime runtime) throws CoreException {
        ArrayList<String> cmdArgs = new ArrayList<String>();
        String wlsHomeDir = runtime.getLocation().toPortableString();
        File mwHome = WlsRuntimeUtil.getMwHome(runtime.getLocation().toFile());
        String wlstScript = String.valueOf(wlsHomeDir) + "/common/bin/wlst." + CorePlugin.getScriptExtension();
        File workingDirectory = new File(String.valueOf(wlsHomeDir) + "/common/bin/");
        File oracleCommon = new File(mwHome, "oracle_common");
        if (oracleCommon.exists()) {
            workingDirectory = new File(oracleCommon + "/common/bin/");
            wlstScript = String.valueOf(workingDirectory.getAbsolutePath().replace('\\', '/')) + "/wlst." + CorePlugin.getScriptExtension();
            cmdArgs.add(wlstScript);
        } else {
            wlstScript = String.valueOf(workingDirectory.getAbsolutePath().replace('\\', '/')) + "/wlst." + CorePlugin.getScriptExtension();
            cmdArgs.add(wlstScript);
        }
        return cmdArgs;
    }
}

