/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import oracle.eclipse.tools.common.util.fileio.ManifestUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerInstall;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.DomainTemplateUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.TemplateInfo;
import org.eclipse.wst.server.core.IRuntime;
import org.osgi.framework.Version;

public class JRFRuntimeUtil {
    private static final String URL_11_1_1_2 = "http://download.oracle.com/otn/nt/middleware/11g/ofm_appdev_generic_11.1.1.2.0_disk1_1of1.zip";
    private static final String URL_11_1_1_3 = "http://download.oracle.com/otn/nt/middleware/11g/ofm_appdev_generic_11.1.1.3.0_disk1_1of1.zip";
    private static final String URL_11_1_1_4 = "http://download.oracle.com/otn/nt/middleware/11g/111140/ofm_appdev_generic_11.1.1.4.0_disk1_1of1.zip";
    private static final String URL_11_1_1_5 = "http://download.oracle.com/otn/nt/middleware/11g/111150/ofm_appdev_generic_11.1.1.5.0_disk1_1of1.zip";
    private static final String URL_11_1_1_6 = "http://download.oracle.com/otn/nt/middleware/11g/111160/ofm_appdev_generic_11.1.1.6.0_disk1_1of1.zip";
    private static final String URL_11_1_1_7 = "http://download.oracle.com/otn/nt/middleware/11g/111170/ofm_appdev_generic_11.1.1.7.0_disk1_1of1.zip";
    private static final HashMap<String, String> URL_MAP = new HashMap();
    private static final HashMap<String, String> WLS_ADF_VER_MAP;
    public static final String JRF_MODULE_PREFIX = "oracle.jrf_";
    private static final Object JRF_DOMAIN_TEMPLATE_NAME;
    private static final Map<File, String> jrfVersionCache;

    static {
        URL_MAP.put("11.1.1.2.0", URL_11_1_1_2);
        URL_MAP.put("11.1.1.3.0", URL_11_1_1_3);
        URL_MAP.put("11.1.1.4.0", URL_11_1_1_4);
        URL_MAP.put("11.1.1.5.0", URL_11_1_1_5);
        URL_MAP.put("11.1.1.6.0", URL_11_1_1_6);
        URL_MAP.put("11.1.1.7.0", URL_11_1_1_7);
        WLS_ADF_VER_MAP = new HashMap();
        WLS_ADF_VER_MAP.put("10.3.4", "11.1.1");
        WLS_ADF_VER_MAP.put("10.3.5", "11.1.1");
        WLS_ADF_VER_MAP.put("10.3.6", "11.1.1");
        WLS_ADF_VER_MAP.put("12.1.2", "12.1.2");
        JRF_DOMAIN_TEMPLATE_NAME = "Oracle JRF";
        jrfVersionCache = new HashMap<File, String>();
    }

    public static String getDownloadURL(String version) {
        return URL_MAP.get(version);
    }

    public static String getJRFRuntimeVersion(File wlhome) {
        String oracleCommonModulePath = String.valueOf(WlsRuntimeUtil.getMwHome(wlhome).getAbsolutePath()) + "/oracle_common/modules/";
        File oracleCommonModuleFolder = new File(oracleCommonModulePath);
        if (oracleCommonModuleFolder.exists()) {
            return JRFRuntimeUtil.getJRFRuntimeVersionFrom(oracleCommonModuleFolder);
        }
        return null;
    }

    public static String getJRFRuntimeVersionFrom(File oracleCommonModuleFolder) {
        TreeMap<Version, File> map = JRFRuntimeUtil.getJrfModuleFolderMap(oracleCommonModuleFolder);
        if (map.size() > 0) {
            return map.lastEntry().getKey().toString();
        }
        return null;
    }

    public static File getJDKHome(File wlhome) {
        File mwHome = WlsRuntimeUtil.getMwHome(wlhome);
        File[] fileArray = mwHome.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory() && (f.getName().startsWith("jdk") || f.getName().startsWith("jrockit"))) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isJRFRuntimeInstalled(File wlhome) {
        File mwHome = WlsRuntimeUtil.getMwHome(wlhome);
        String oracleCommonModulePath = String.valueOf(mwHome.getAbsolutePath()) + "/oracle_common/modules/";
        File oracleCommonModuleFolder = new File(oracleCommonModulePath);
        if (oracleCommonModuleFolder.exists()) {
            File[] fileArray = oracleCommonModuleFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory() && f.getName().startsWith(JRF_MODULE_PREFIX)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static String getAdfVersionForWls(String wlsVersion) {
        String adfVersion = WLS_ADF_VER_MAP.get(wlsVersion);
        if (adfVersion != null) {
            return adfVersion;
        }
        return "11.1.1";
    }

    public static String getJRFRuntimeImplVersion(File wlhome) {
        File mwHome = WlsRuntimeUtil.getMwHome(wlhome);
        String oracleCommonModulePath = String.valueOf(mwHome.getAbsolutePath()) + "/oracle_common/modules/";
        File oracleCommonModuleFolder = new File(oracleCommonModulePath);
        if (oracleCommonModuleFolder.exists()) {
            String implVer = jrfVersionCache.get(wlhome);
            if (implVer != null) {
                return implVer;
            }
            implVer = JRFRuntimeUtil.getJRFRuntimeImplVersionFrom(oracleCommonModuleFolder);
            if (implVer != null) {
                jrfVersionCache.put(wlhome, implVer);
                return implVer;
            }
        }
        return null;
    }

    public static String getJRFRuntimeImplVersionFrom(File oracleCommonModuleFolder) {
        String version = null;
        TreeMap<Version, File> map = JRFRuntimeUtil.getJrfModuleFolderMap(oracleCommonModuleFolder);
        if (map.size() > 0) {
            File f = map.lastEntry().getValue();
            version = map.lastEntry().getKey().toString();
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File jar = fileArray[n2];
                if (jar.getName().equals("jrf.jar")) {
                    try {
                        String implVer = ManifestUtil.readManifestEntry((File)jar, (String)"Implementation-Version");
                        if (implVer != null) {
                            int n22;
                            int n1 = implVer.indexOf("JDEVADF_");
                            if (n1 > 0 && (n22 = (implVer = implVer.substring(n1 + "JDEVADF_".length())).indexOf(95)) > 0) {
                                version = implVer.substring(0, n22);
                            }
                            return version;
                        }
                        String jrfWlsVer = ManifestUtil.readManifestEntry((File)jar, (String)"Class-Path");
                        if (jrfWlsVer != null) {
                            int n1 = jrfWlsVer.lastIndexOf(95);
                            int n23 = jrfWlsVer.substring(n1 + 1).indexOf(".jar");
                            version = jrfWlsVer.substring(n1 + 1, n1 + n23 + 1);
                            return version;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        return version;
    }

    public static String getInstallableJRFVersion(WebLogicServerInstall install) {
        String installedJrfVersion;
        WebLogicServerVersion v = install.getVersion();
        if (v.compareTo(WebLogicServerVersion.VERSION_10_3_3) == 0) {
            String installedJrfVersion2 = JRFRuntimeUtil.getJRFRuntimeImplVersion(install.getLocation().getAbsoluteFile());
            if (installedJrfVersion2 == null) {
                return "11.1.1.2.0";
            }
            if (installedJrfVersion2.equals("11.1.1.2.0")) {
                return "11.1.1.3.0";
            }
        } else if (v.compareTo(WebLogicServerVersion.VERSION_10_3_4) == 0) {
            String installedJrfVersion3 = JRFRuntimeUtil.getJRFRuntimeImplVersion(install.getLocation().getAbsoluteFile());
            if (installedJrfVersion3 == null) {
                return "11.1.1.4.0";
            }
        } else if (v.compareTo(WebLogicServerVersion.VERSION_10_3_5) == 0) {
            String installedJrfVersion4 = JRFRuntimeUtil.getJRFRuntimeImplVersion(install.getLocation().getAbsoluteFile());
            if (installedJrfVersion4 == null) {
                return "11.1.1.5.0";
            }
        } else if (v.compareTo(WebLogicServerVersion.VERSION_10_3_6) == 0) {
            String installedJrfVersion5 = JRFRuntimeUtil.getJRFRuntimeImplVersion(install.getLocation().getAbsoluteFile());
            if (installedJrfVersion5 == null) {
                return "11.1.1.7.0";
            }
        } else if (v.compareTo(WebLogicServerVersion.VERSION_12_1_2) == 0 && (installedJrfVersion = JRFRuntimeUtil.getJRFRuntimeImplVersion(install.getLocation().getAbsoluteFile())) == null) {
            return "12.1.2.0.0";
        }
        return null;
    }

    public static String getJRFTemplateName(IRuntime rt) {
        String ret = null;
        for (TemplateInfo info : DomainTemplateUtil.findAllDomainExtensionTemplates(rt).values()) {
            if (!info.selectable.equals("true") || !info.getName().equals(JRF_DOMAIN_TEMPLATE_NAME)) continue;
            ret = info.getFullName();
        }
        return ret;
    }

    private static TreeMap<Version, File> getJrfModuleFolderMap(File oracleCommonModuleFolder) {
        TreeMap<Version, File> adfModuleDirMap = new TreeMap<Version, File>();
        File[] fileArray = oracleCommonModuleFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory() && f.getName().startsWith(JRF_MODULE_PREFIX)) {
                String version = f.getName().substring(JRF_MODULE_PREFIX.length());
                Version v = Version.parseVersion((String)version);
                adfModuleDirMap.put(v, f);
            }
            ++n2;
        }
        return adfModuleDirMap;
    }
}

