/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;

public class J2EEDescriptorCatalog {
    private static J2EEDescriptorCatalog instance;
    static final String WST_XML_CORE_BUNDLE_ID = "org.eclipse.wst.xml.core";
    static final String JST_STANDARD_SCHEMA_BUNDLE_ID = "org.eclipse.jst.standard.schemas";
    private TreeSet<String> j2eeDescriptorTypes = new TreeSet();
    private HashMap<String, String> j2eeDescriptorFileMap = new HashMap();
    private HashMap<String, String> j2ee14DescriptorUriMap = new HashMap();
    private HashMap<String, String> javaee50DescriptorUriMap = new HashMap();
    private String[] J2EE_DESCRIPTOR_FILES = new String[]{"application", "web", "ejb-jar", "persistence", "orm", "webservices", "connector", "application-client"};

    private J2EEDescriptorCatalog() {
        this.initialize();
    }

    private void initialize() {
        this.j2eeDescriptorFileMap.put("application.xml", "application");
        this.j2eeDescriptorFileMap.put("web.xml", "web-app");
        this.j2eeDescriptorFileMap.put("ejb-jar.xml", "ejb-jar");
        this.j2eeDescriptorFileMap.put("persistence.xml", "persistence");
        this.j2eeDescriptorFileMap.put("orm.xml", "orm");
        this.j2eeDescriptorFileMap.put("webservices.xml", "webservices");
        String[] stringArray = this.J2EE_DESCRIPTOR_FILES;
        int n = this.J2EE_DESCRIPTOR_FILES.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.j2eeDescriptorTypes.add(s);
            ++n2;
        }
        this.javaee50DescriptorUriMap.put("application", "http://java.sun.com/xml/ns/javaee/application_5.xsd");
        this.javaee50DescriptorUriMap.put("web-app", "http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd");
        this.javaee50DescriptorUriMap.put("ejb-jar", "http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd");
        this.javaee50DescriptorUriMap.put("persistence", "http://java.sun.com/xml/ns/persistence/persistence_1_0.xsd");
        this.javaee50DescriptorUriMap.put("orm", "http://java.sun.com/xml/ns/persistence/orm_1_0.xsd");
        this.javaee50DescriptorUriMap.put("webservices", "http://java.sun.com/xml/ns/javaee/javaee_web_services_1_2.xsd");
        this.javaee50DescriptorUriMap.put("faces-config", "http://java.sun.com/xml/ns/javaee/web-facesconfig_1_2.xsd");
        this.j2ee14DescriptorUriMap.put("application", "http://java.sun.com/xml/ns/j2ee/application_1_4.xsd");
        this.j2ee14DescriptorUriMap.put("web-app", "http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd");
        this.j2ee14DescriptorUriMap.put("ejb-jar", "http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd");
        this.j2ee14DescriptorUriMap.put("webservices", "http://java.sun.com/xml/ns/j2ee/j2ee_web_services_1_1.xsd");
    }

    public static J2EEDescriptorCatalog getInstance() {
        if (instance == null) {
            instance = new J2EEDescriptorCatalog();
        }
        return instance;
    }

    public String getDescriptorType(String fileName) {
        String ret = this.j2eeDescriptorFileMap.get(fileName);
        return ret;
    }

    public String findDescriptorUri(String J2EEVersion, String type) {
        if ("5.0".equals(J2EEVersion)) {
            return this.javaee50DescriptorUriMap.get(type);
        }
        if ("1.4".equals(J2EEVersion)) {
            return this.j2ee14DescriptorUriMap.get(type);
        }
        return null;
    }

    public TreeSet<String> getDescriptorTypes() {
        return this.j2eeDescriptorTypes;
    }

    public Collection<String> getDescriptorFileNames(String moduleType) {
        ArrayList<String> ret = new ArrayList<String>();
        String rtPath = "";
        if (moduleType.equals("ear")) {
            ret.add("META-INF/application.xml");
        } else if (moduleType.equals("war") || moduleType.equals("ejb")) {
            if (moduleType.equals("war")) {
                ret.add("WEB-INF/web.xml");
                rtPath = "WEB-INF/classes/META-INF/";
            }
            if (moduleType.equals("ejb")) {
                ret.add("META-INF/ejb-jar.xml");
                rtPath = "META-INF/";
            }
            ret.add(String.valueOf(rtPath) + "webservice.xml");
            ret.add(String.valueOf(rtPath) + "persistence.xml");
            ret.add(String.valueOf(rtPath) + "orm.xml");
        }
        return ret;
    }
}

