/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.ui.elbinding.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.controller.ui.ADFControllerUiPlugin;
import oracle.eclipse.tools.adf.controller.ui.elbinding.IElBindingContextFactory;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.ui.bindedit.IElBindingContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Plugin;

public class ElBindingContextFactoryReader {
    private static final String ADF_CONTROLLER_UI_PLUGIN = "oracle.eclipse.tools.adf.controller.ui";
    private static final String EXT_ID = "elBindingContextFactory";
    private static final String CLASS_ATTR = "class";
    private static List<IElBindingContextFactory> _factories;

    public static IElBindingContext getElBindingContext(String actionHandlerclassName, IDocument document, boolean acceptsEarlyBoundVariables, boolean acceptsLateBoundVariables, boolean acceptsJspVariables, IFile variableSource) {
        for (IElBindingContextFactory factory : ElBindingContextFactoryReader.getAllFactories()) {
            if (!factory.isFactoryFor(actionHandlerclassName)) continue;
            return factory.getContext(document, acceptsEarlyBoundVariables, acceptsLateBoundVariables, acceptsJspVariables, variableSource);
        }
        return null;
    }

    private static synchronized List<IElBindingContextFactory> getAllFactories() {
        if (_factories == null) {
            _factories = ElBindingContextFactoryReader.readAllFactories();
        }
        return Collections.unmodifiableList(_factories);
    }

    private static List<IElBindingContextFactory> readAllFactories() {
        ArrayList<IElBindingContextFactory> factories = new ArrayList<IElBindingContextFactory>();
        Collection extensions = PluginUtil.findExtensions((String)ADF_CONTROLLER_UI_PLUGIN, (String)EXT_ID);
        for (IExtension ext : extensions) {
            IConfigurationElement[] configurations;
            IConfigurationElement[] iConfigurationElementArray = configurations = ext.getConfigurationElements();
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configuration = iConfigurationElementArray[n2];
                try {
                    IElBindingContextFactory factory = (IElBindingContextFactory)configuration.createExecutableExtension(CLASS_ATTR);
                    factories.add(factory);
                }
                catch (CoreException e) {
                    LoggingService.logException((Plugin)ADFControllerUiPlugin.getDefault(), (CoreException)e);
                }
                ++n2;
            }
        }
        return factories;
    }

    private ElBindingContextFactoryReader() {
        throw new IllegalStateException("Should not be instantiated!");
    }
}

