/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.ui.editor;

import java.util.ArrayList;
import oracle.eclipse.tools.adf.controller.model.IActivity;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.model.ITaskFlowFile;
import oracle.eclipse.tools.adf.controller.model.internal.BreakpointDerivedValueService;
import oracle.eclipse.tools.adf.controller.ui.ADFControllerUiPlugin;
import oracle.eclipse.tools.adf.debugger.ui.AdfDebugUITools;
import oracle.eclipse.tools.adf.debugger.ui.TaskflowActivity;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugElement;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.services.DerivedValueService;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.forms.swt.MasterDetailsEditorPage;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.xml.editor.XmlEditorResourceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class TaskFlowEditor
extends SapphireEditor
implements IBreakpointListener,
IPartListener,
IDebugEventSetListener {
    public static final String ID = "oracle.eclipse.tools.adf.controller.ui.taskfloweditor";
    private ITaskFlowFile taskFlowRoot;
    private StructuredTextEditor tfSourceEditor;
    private SapphireDiagramEditor tfDiagramEditor;
    private MasterDetailsEditorPage tfOverviewPage;
    private IThread suspendedThread = null;

    protected Element createModel() {
        this.taskFlowRoot = (ITaskFlowFile)ITaskFlowFile.TYPE.instantiate((Resource)new RootXmlResource((XmlResourceStore)new XmlEditorResourceStore((SapphireEditor)this, this.tfSourceEditor)));
        return this.taskFlowRoot;
    }

    protected void createSourcePages() throws PartInitException {
        this.tfSourceEditor = new StructuredTextEditor();
        this.tfSourceEditor.setEditorPart((IEditorPart)this);
        int index = this.addPage((IEditorPart)this.tfSourceEditor, this.getEditorInput());
        this.setPageText(index, "Source");
    }

    protected void createFormPages() throws PartInitException {
        this.tfOverviewPage = new MasterDetailsEditorPage((SapphireEditor)this, (Element)this.taskFlowRoot, DefinitionLoader.sdef(((Object)((Object)this)).getClass()).page("main"));
        this.addPage(1, (IFormPage)this.tfOverviewPage);
    }

    protected void createDiagramPages() throws PartInitException {
        this.tfDiagramEditor = new SapphireDiagramEditor((SapphireEditor)this, (Element)this.taskFlowRoot, DefinitionLoader.sdef(((Object)((Object)this)).getClass()).page("diagram"));
        this.addPage(0, (IEditorPart)this.tfDiagramEditor, this.getEditorInput());
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        this.getEditorSite().getPage().addPartListener((IPartListener)this);
    }

    public void doSave(IProgressMonitor monitor) {
        this.tfDiagramEditor.doSave(monitor);
        super.doSave(monitor);
    }

    public void dispose() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        this.getEditorSite().getPage().removePartListener((IPartListener)this);
        this.taskFlowRoot.disposeTaskFlowContext();
        super.dispose();
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.refreshModel();
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.refreshModel();
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.refreshModel();
    }

    public void refreshModel() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ITaskFlowFile tf = (ITaskFlowFile)TaskFlowEditor.this.getModelElement();
                for (IActivity act : tf.getTaskFlow().getActivities()) {
                    BreakpointDerivedValueService breakpointStateService = (BreakpointDerivedValueService)act.getBreakpoint().service(DerivedValueService.class);
                    breakpointStateService.refreshState();
                }
            }
        });
    }

    public Object getAdapter(Class type) {
        if (type.equals(ITextEditor.class)) {
            return this.tfSourceEditor;
        }
        if (type == IGotoMarker.class) {
            return new IGotoMarker(){

                public void gotoMarker(IMarker marker) {
                    TaskFlowEditor.this.gotoMarker(marker);
                }
            };
        }
        Object ret = super.getAdapter(type);
        if (ret == null && PalettePage.class.equals((Object)type) && this.tfDiagramEditor != null) {
            ret = this.tfDiagramEditor.getAdapter(type);
        }
        return ret;
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        if (part == this) {
            this.setActiveTaskflow();
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        }
    }

    public void partClosed(IWorkbenchPart part) {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void handleDebugEvents(DebugEvent[] events) {
        Object obj = events[0].getSource();
        JDIDebugTarget target = null;
        if (obj instanceof JDIDebugElement) {
            target = ((JDIDebugElement)obj).getJavaDebugTarget();
        }
        if (events[0].getKind() == 1 || events[0].getKind() == 8) {
            if (this.suspendedThread != null && this.suspendedThread.getDebugTarget() == target) {
                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                AdfDebugUITools.reset();
                this.suspendedThread = null;
            }
        } else if (events[0].getKind() == 2) {
            this.setActiveTaskflow();
            UIJob refreshJob = new UIJob("Locate ADF taskflow activity"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    TaskFlowEditor.this.refreshModel();
                    return Status.OK_STATUS;
                }
            };
            refreshJob.schedule(200L);
        }
    }

    private void setActiveTaskflow() {
        IAdaptable ctx = DebugUITools.getDebugContext();
        if (ctx instanceof JDIStackFrame) {
            final JDIStackFrame stackFrame = (JDIStackFrame)ctx;
            if (!stackFrame.getThread().isSuspended()) {
                return;
            }
            TaskflowActivity ta = new TaskflowActivity();
            ta.setFrameStack(stackFrame);
            String taskflow = ta.getTaskflowId();
            String activity = ta.getActivityId();
            if (taskflow != null && activity != null) {
                AdfDebugUITools.setCurrentActivity((String)(String.valueOf(taskflow) + "#" + activity));
                boolean found = false;
                ITaskFlow taskFlow = this.taskFlowRoot.getTaskFlow();
                for (IActivity act : taskFlow.getActivities()) {
                    if (!((String)act.getActivityId().content()).equals(activity)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    UIJob refreshJob = new UIJob("Lookup ADF taskflow activity"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            ISourceDisplay display = (ISourceDisplay)stackFrame.getAdapter(ISourceDisplay.class);
                            if (display != null) {
                                display.displaySource((Object)stackFrame, TaskFlowEditor.this.getEditorSite().getPage(), true);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    refreshJob.schedule();
                } else {
                    this.refreshModel();
                }
                this.suspendedThread = ((JDIStackFrame)ctx).getThread();
            }
        }
    }

    private void gotoMarker(IMarker marker) {
        block4: {
            try {
                if (marker.getType().equals("oracle.eclipse.tools.adf.controller.ui.taskFlowBookmarkMarker")) {
                    this.setActiveEditor((IEditorPart)this.tfDiagramEditor);
                    String activityId = (String)marker.getAttribute("ActivityId");
                    for (DiagramNodePart nodePart : this.tfDiagramEditor.getPart().getNodes()) {
                        IActivity activity = (IActivity)nodePart.getLocalModelElement();
                        String activityId2 = (String)activity.getActivityId().content();
                        if (activityId2 == null || !activityId2.equals(activityId)) continue;
                        ArrayList<DiagramNodePart> parts = new ArrayList<DiagramNodePart>();
                        parts.add(nodePart);
                        this.tfDiagramEditor.selectParts(parts);
                        break block4;
                    }
                    break block4;
                }
                this.setActiveEditor((IEditorPart)this.tfSourceEditor);
                IDE.gotoMarker((IEditorPart)this.tfSourceEditor, (IMarker)marker);
            }
            catch (CoreException ce) {
                LoggingService.logException((Plugin)ADFControllerUiPlugin.getDefault(), (CoreException)ce);
            }
        }
    }
}

