/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.ui.actionhandler;

import oracle.eclipse.tools.adf.controller.TaskFlowFactory;
import oracle.eclipse.tools.adf.controller.model.ITaskFlowFile;
import oracle.eclipse.tools.adf.controller.model.TaskFlowType;
import oracle.eclipse.tools.common.util.xml.NCNameValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramPresentation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class TaskFlowConverterHandler
extends SapphireActionHandler {
    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        Element model = this.getPart().getLocalModelElement();
        IFile ifile = (IFile)model.adapt(IFile.class);
        if (ifile != null && !ifile.equals((Object)TaskFlowFactory.getDefaultUnboundedTaskFlowFile((IProject)ifile.getProject()))) {
            this.setEnabled(false);
        }
    }

    public boolean isEnabled() {
        ITaskFlowFile tfFile;
        TaskFlowType tfType;
        Element ele = this.getPart().getLocalModelElement();
        IFile ifile = (IFile)ele.adapt(IFile.class);
        return ifile != null && !ifile.equals((Object)TaskFlowFactory.getDefaultUnboundedTaskFlowFile((IProject)ifile.getProject())) && ((tfType = (TaskFlowType)(tfFile = (ITaskFlowFile)ele.nearest(ITaskFlowFile.class)).getTaskFlowType().content()) == TaskFlowType.Bounded || tfType == TaskFlowType.Unbounded);
    }

    protected Object run(Presentation context) {
        Element ele = this.getPart().getLocalModelElement();
        ITaskFlowFile tfFile = (ITaskFlowFile)ele.nearest(ITaskFlowFile.class);
        IFile ifile = (IFile)ele.adapt(IFile.class);
        boolean oldBounded = tfFile.getTaskFlowType().content() == TaskFlowType.Bounded;
        boolean bounded = !oldBounded;
        Shell shell = Display.getDefault().getActiveShell();
        ((DiagramPresentation)context).getConfigurationManager().getDiagramEditor();
        if (!bounded) {
            MessageBox msgBox = new MessageBox(shell, 196);
            msgBox.setText(Resources.tfConverterTitle);
            String msg = NLS.bind((String)Resources.boundedTFLoseContentMsg, (Object)ifile.getName());
            msgBox.setMessage(msg);
            if (msgBox.open() == 64) {
                tfFile.setTaskFlowType(TaskFlowType.Unbounded);
            }
        } else {
            TaskFlowIdValidator idValidator = new TaskFlowIdValidator();
            String msg = NLS.bind((String)Resources.unboundedTFLoseContentMsg, (Object)ifile.getName());
            InputDialog d = new InputDialog(shell, Resources.tfConverterTitle, msg, null, (IInputValidator)idValidator);
            if (d.open() == 0) {
                tfFile.setTaskFlowType(TaskFlowType.Bounded);
                tfFile.getTaskFlow().setTaskFlowId(d.getValue());
            }
        }
        return null;
    }

    private static final class Resources
    extends NLS {
        public static String tfConverterTitle;
        public static String boundedTFLoseContentMsg;
        public static String unboundedTFLoseContentMsg;
        public static String invalidNCName;

        static {
            Resources.initializeMessages((String)TaskFlowConverterHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private static final class TaskFlowIdValidator
    implements IInputValidator {
        private TaskFlowIdValidator() {
        }

        public String isValid(String tfId) {
            if (tfId == null || tfId.isEmpty() || !NCNameValidator.isValidNCName((String)tfId)) {
                return Resources.invalidNCName;
            }
            return null;
        }
    }
}

