/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.ui.actionhandler;

import oracle.eclipse.tools.adf.controller.model.IStaticTaskFlowReference;
import oracle.eclipse.tools.adf.controller.model.ITaskFlowCallComponent;
import oracle.eclipse.tools.adf.controller.ui.ADFControllerUiPlugin;
import oracle.eclipse.tools.adf.controller.ui.internal.wizard.CreateTaskFlowWizard;
import oracle.eclipse.tools.adf.controller.util.ProjectUtil;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class OpenReferencedTaskFlowHandler
extends SapphireActionHandler {
    private static final String TASKFLOW_EDITOR_ID = "oracle.eclipse.tools.adf.controller.ui.editor.TaskFlowEditor";

    protected Object run(Presentation context) {
        SapphirePart part = context.part();
        final IFile referedFile = this.getReferencedTaskFlowFile((DiagramNodePart)part);
        Display.getCurrent().asyncExec(new Runnable((ISapphirePart)part){
            private final /* synthetic */ ISapphirePart val$part;
            {
                this.val$part = iSapphirePart;
            }

            @Override
            public void run() {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                try {
                    if (referedFile != null) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        page.openEditor((IEditorInput)new FileEditorInput(referedFile), OpenReferencedTaskFlowHandler.TASKFLOW_EDITOR_ID);
                    } else {
                        ITaskFlowCallComponent tfCall = (ITaskFlowCallComponent)this.val$part.getLocalModelElement();
                        IProject proj = (IProject)tfCall.adapt(IProject.class);
                        CreateTaskFlowWizard newWizard = new CreateTaskFlowWizard();
                        StructuredSelection ss = new StructuredSelection((Object)proj);
                        newWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)ss);
                        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)newWizard);
                        dialog.create();
                        if (dialog.open() == 0) {
                            IFile file = newWizard.getFileHandle();
                            IPath fullPath = file.getFullPath();
                            IContainer webRoot = ProjectUtil.getWebContentFolderIResource((IProject)proj);
                            if (fullPath != null && webRoot != null) {
                                StringBuilder tfRef = new StringBuilder();
                                tfRef.append('/');
                                IPath relPath = fullPath.makeRelativeTo(webRoot.getFullPath());
                                String portablePath = relPath.toPortableString();
                                if (portablePath != null && portablePath.length() > 0) {
                                    tfRef.append(relPath.toPortableString());
                                    IStaticTaskFlowReference staticRef = (IStaticTaskFlowReference)tfCall.getTaskFlowReference().content(true, IStaticTaskFlowReference.TYPE);
                                    staticRef.setDocument(tfRef.toString());
                                }
                            }
                        }
                    }
                }
                catch (PartInitException e) {
                    LoggingService.logException((Plugin)ADFControllerUiPlugin.getDefault(), (CoreException)e);
                }
            }
        });
        return null;
    }

    private IFile getReferencedTaskFlowFile(DiagramNodePart nodePart) {
        ITaskFlowCallComponent tfCall = (ITaskFlowCallComponent)nodePart.getModelElement();
        return TaskFlowUtil.getReferencedTaskFlowFile((ITaskFlowCallComponent)tfCall);
    }
}

