/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.ui.actionhandler;

import oracle.eclipse.tools.adf.common.ui.quickstart.wizard.NewADFFileWizard;
import oracle.eclipse.tools.adf.controller.model.IADFView;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.ui.ADFControllerUiPlugin;
import oracle.eclipse.tools.adf.controller.util.ProjectUtil;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewJSPActionHandler
extends SapphireActionHandler {
    protected Object run(Presentation context) {
        DiagramNodePart nodePart = (DiagramNodePart)context.part();
        Element modelElement = nodePart.getModelElement();
        if (!(modelElement instanceof IADFView)) {
            return null;
        }
        IADFView view = (IADFView)modelElement;
        boolean useFragments = false;
        ITaskFlow tfModel = (ITaskFlow)view.nearest(ITaskFlow.class);
        if (tfModel != null) {
            useFragments = tfModel.isUsePageFragments().content() == Boolean.TRUE;
        }
        boolean hasPage = view.getPage().content() != null;
        IProject proj = (IProject)view.adapt(IProject.class);
        final IFile viewPageFile = this.getViewPageFile(view, proj, useFragments);
        if (!hasPage || viewPageFile == null || !viewPageFile.exists()) {
            StructuredSelection ss;
            NewADFFileWizard newJspWizard = new NewADFFileWizard(useFragments, new Boolean(TaskFlowUtil.isBoundedTaskFlow((ITaskFlow)tfModel)));
            newJspWizard.setTaskflowProject(proj);
            if (viewPageFile == null) {
                ss = new StructuredSelection((Object)proj);
            } else {
                ss = new StructuredSelection((Object)viewPageFile);
                newJspWizard.setInitialContainerFullPath(viewPageFile.getParent().getFullPath());
                String name = viewPageFile.getName();
                newJspWizard.setInitialFileName(name);
            }
            newJspWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)ss);
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)newJspWizard);
            dialog.create();
            if (dialog.open() == 0) {
                IFile file = newJspWizard.getFile();
                IPath fullPath = file.getFullPath();
                IContainer webRoot = ProjectUtil.getWebContentFolderIResource((IProject)proj);
                if (fullPath != null && webRoot != null) {
                    StringBuilder page = new StringBuilder();
                    page.append('/');
                    IPath relPath = fullPath.makeRelativeTo(webRoot.getFullPath());
                    String portablePath = relPath.toPortableString();
                    if (portablePath != null && portablePath.length() > 0) {
                        page.append(relPath.toPortableString());
                        view.setPage(page.toString());
                    }
                }
            }
        } else if (viewPageFile != null) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!PlatformUI.isWorkbenchRunning()) {
                        return;
                    }
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)viewPageFile, (boolean)true);
                    }
                    catch (PartInitException e) {
                        LoggingService.logException((Plugin)ADFControllerUiPlugin.getDefault(), (CoreException)e);
                    }
                }
            });
        }
        return null;
    }

    private IFile getViewPageFile(IADFView view, IProject proj, boolean useFragments) {
        Path pagePath = (Path)view.getPage().content();
        if (pagePath == null) {
            Value id = view.getActivityId();
            pagePath = new Path((String)id.content());
            pagePath = useFragments ? pagePath.addFileExtension("jsff") : pagePath.addFileExtension("jspx");
        }
        if (pagePath != null) {
            IContainer webRoot;
            String pathStr = pagePath.toString();
            if (pathStr.startsWith("/")) {
                pathStr = pathStr.substring(1);
            }
            if ((webRoot = ProjectUtil.getWebContentFolderIResource((IProject)proj)) != null) {
                IFolder webFolder = proj.getFolder(webRoot.getProjectRelativePath());
                return webFolder.getFile(pathStr);
            }
        }
        return null;
    }
}

