/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.controller.ui.actionhandler;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.controller.model.IActivity;
import oracle.eclipse.tools.adf.controller.model.ITaskFlow;
import oracle.eclipse.tools.adf.controller.model.ITaskFlowFile;
import oracle.eclipse.tools.adf.controller.model.TaskFlowType;
import oracle.eclipse.tools.adf.controller.ui.elbinding.VariablesModelWithBindings;
import oracle.eclipse.tools.adf.controller.util.TaskFlowUtil;
import oracle.eclipse.tools.adf.dtrt.context.typed.ITaskFlowContext;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.ManagedBeanExternalVariable;
import oracle.eclipse.tools.application.common.services.variables.MethodReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.ui.bindedit.MethodBindDialog;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.MethodViewFilter;
import oracle.eclipse.tools.webtier.ui.internal.palette.model.variable.VariablesModel;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.forms.BrowseActionHandler;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.widgets.Shell;

public class LaunchBindDialogActionHandler
extends BrowseActionHandler {
    public static IFile getPageDefinitionAccessibleFile(IActivity activity) {
        ITaskFlowContext pdContext;
        ITaskFlowFile taskflowFile;
        if (activity != null && (taskflowFile = (ITaskFlowFile)activity.nearest(ITaskFlowFile.class)) != null && (pdContext = taskflowFile.getTaskFlowContext()) != null && pdContext.isValidBoundSourceActivity((Object)activity)) {
            IPageDefinition pageDefinition = pdContext.getPageDefinition((Object)activity);
            return pdContext.getAccessibleFile((IObject)pageDefinition);
        }
        return null;
    }

    public String browse(Presentation context) {
        IFile tfFile = (IFile)this.getModelElement().adapt(IFile.class);
        IDocument tfDoc = (IDocument)tfFile.getAdapter(IDocument.class);
        ArrayList<String> sigs = new ArrayList<String>();
        Element modelElement = this.getModelElement();
        ITaskFlow tfModel = (ITaskFlow)modelElement.nearest(ITaskFlow.class);
        IFile pageDefFile = LaunchBindDialogActionHandler.getPageDefinitionAccessibleFile((IActivity)modelElement.nearest(IActivity.class));
        Object initValObj = this.property().content();
        WritableValue val = new WritableValue(initValObj, String.class);
        TaskflowMethodBindDialog methodBindDlg = new TaskflowMethodBindDialog(((SwtPresentation)context).shell(), (IObservableValue)val, null, tfDoc, sigs, null, null, null, pageDefFile, tfModel);
        if (methodBindDlg.open() == 0) {
            return (String)val.getValue();
        }
        return null;
    }

    private static class BindingsMethodViewFilter
    extends MethodViewFilter {
        private ITaskFlow tfModel;
        private IFile tfFile;

        public BindingsMethodViewFilter(List<MethodReference> acceptedSignatures, ITaskFlow tfModel) {
            super(acceptedSignatures);
            this.tfModel = tfModel;
            this.tfFile = (IFile)this.tfModel.adapt(IFile.class);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ValueReference) {
                IModelContext context = DataType.NullModelContext.getInstance();
                if (((ValueReference)element).getType(context).getName().equals("bindings")) {
                    return true;
                }
                Variable var = ((ValueReference)element).getVariable();
                if (var instanceof ManagedBeanExternalVariable) {
                    IFile file;
                    ManagedBeanExternalVariable managedBeanVar = (ManagedBeanExternalVariable)var;
                    IResource res = managedBeanVar.getDefinitionLocation().getResource();
                    return res instanceof IFile && ((file = (IFile)res).equals((Object)this.tfFile) || TaskFlowUtil.getTaskFlowType((IFile)file) == TaskFlowType.Unbounded);
                }
            }
            return super.select(viewer, parentElement, element);
        }
    }

    private static class TaskflowMethodBindDialog
    extends MethodBindDialog {
        private IFile pagedefFile;
        private ITaskFlow tfModel;

        public TaskflowMethodBindDialog(Shell parentShell, IObservableValue modelObservable, IValidator validator, IDocument baseDoc, List<String> acceptedSignatures, String attributeName, String userMethodBodyTemplateId, String defaultMethodBodyTemplateId, IFile pagedefFile, ITaskFlow tfModel) {
            super(parentShell, modelObservable, validator, baseDoc, acceptedSignatures, attributeName, userMethodBodyTemplateId, defaultMethodBodyTemplateId);
            this.pagedefFile = pagedefFile;
            this.tfModel = tfModel;
        }

        protected VariablesModel createVariablesModel(IFile file) {
            return new VariablesModelWithBindings(file, this.pagedefFile);
        }

        protected MethodViewFilter createMethodViewFilter() {
            return new BindingsMethodViewFilter(this._acceptedSignatures, this.tfModel);
        }
    }
}

