/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.wizard;

import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.webtier.jsf.ui.Messages;
import oracle.eclipse.tools.webtier.jsf.ui.internal.Activator;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.AbstractDialogEditorCreationAdvisor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.dialog.ConverterSelectionDialogCreationAdvisor;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.JSFAppConfigManagerFactory;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;

public class ConverterSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "oracle.eclipse.tools.webtier.jsf.ui.wizard.ConverterSelectionDialog";
    private final ConverterSelectionDialogCreationAdvisor _advisor;

    public ConverterSelectionDialog(Shell shell, ConverterSelectionDialogCreationAdvisor advisor) {
        super(shell, advisor.getMulipleSelection());
        this.setSelectionHistory(new ConverterSelectionHistory());
        this._advisor = advisor;
        this.setTitle(this._advisor.getTitle());
        this.setSeparatorLabel(Messages.ConverterSelectionDialog_separatorLabel);
        this.setListLabelProvider(new ConverterLabelProvider());
        this.setDetailsLabelProvider(new ConverterDetailsLabelProvider());
        this.setInitialPattern("?", 2);
    }

    protected void doBindData() {
        this._advisor.bindData((IObservableValue)new AbstractObservableValue(){

            protected void doSetValue(Object value) {
                ConverterSelectionDialog.this.setMessage((String)value);
            }

            protected Object doGetValue() {
                return ConverterSelectionDialog.this.getMessage();
            }

            public Object getValueType() {
                return String.class;
            }
        }, new AbstractDialogEditorCreationAdvisor.IStatusUpdater(){

            public void updateStatus(IStatus status) {
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Control createdDialogArea = super.createDialogArea(parent);
        createdDialogArea = this._advisor.createEditingArea((Composite)createdDialogArea);
        return createdDialogArea;
    }

    protected void computeResult() {
        super.computeResult();
        Object[] results = this.getResult();
        ((IObservableValue)this._advisor.getSelectionModel().getStateModel()).setValue(this._advisor.getMulipleSelection() ? results : results[0]);
        this._advisor.computeResult();
    }

    public boolean close() {
        this._advisor.dispose();
        return super.close();
    }

    protected Control createExtendedContentArea(Composite parent) {
        ConverterSelectionHistory history;
        ConverterSelectionDialogCreationAdvisor.ConverterInfoObservableValue selectionModel = new ConverterSelectionDialogCreationAdvisor.ConverterInfoObservableValue();
        this._advisor.setUiInitialized();
        this._advisor.getSelectionModel().setStateModel((IObservable)selectionModel);
        this.doBindData();
        ConverterSelectionDialogCreationAdvisor.ConverterInfo info = (ConverterSelectionDialogCreationAdvisor.ConverterInfo)selectionModel.getValue();
        if (info != null && (history = (ConverterSelectionHistory)this.getSelectionHistory()) != null) {
            history.accessed(info);
        }
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ConverterFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        IJSFAppConfigManager mgr = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance((IProject)this._advisor.getIProject());
        if (mgr != null) {
            List converters = mgr.getConverters();
            if (progressMonitor != null) {
                progressMonitor.beginTask(Messages.ConverterSelectionDialog_searchJob_taskName, converters.size());
            }
            for (ConverterType converter : converters) {
                ConverterIdType converterId = converter.getConverterId();
                if (converterId == null || converterId.getTextContent() == null || converterId.getTextContent().trim().length() == 0) continue;
                ConverterClassType converterClass = converter.getConverterClass();
                contentProvider.add((Object)new ConverterSelectionDialogCreationAdvisor.ConverterInfo(converterId.getTextContent(), converterClass.getTextContent(), this.getString(converter.getDisplayName()), this.getString(converter.getDescription())), itemsFilter);
                if (progressMonitor == null) continue;
                progressMonitor.worked(1);
            }
        }
        if (progressMonitor != null) {
            progressMonitor.done();
        }
    }

    private String getString(EList eList) {
        StringBuilder builder = new StringBuilder();
        for (Object object : eList) {
            if (!(object instanceof String)) continue;
            builder.append((String)object);
        }
        return builder.toString();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public String getElementName(Object item) {
        return ((ConverterSelectionDialogCreationAdvisor.ConverterInfo)item).getId();
    }

    protected Comparator<ConverterSelectionDialogCreationAdvisor.ConverterInfo> getItemsComparator() {
        return new Comparator<ConverterSelectionDialogCreationAdvisor.ConverterInfo>(){

            @Override
            public int compare(ConverterSelectionDialogCreationAdvisor.ConverterInfo o1, ConverterSelectionDialogCreationAdvisor.ConverterInfo o2) {
                Collator collator = Collator.getInstance();
                return collator.compare(o1.getId(), o2.getId());
            }
        };
    }

    protected IStatus validateItem(Object item) {
        return ValidationStatus.OK_STATUS;
    }

    private static final class ConverterDetailsLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private ConverterDetailsLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ConverterSelectionDialogCreationAdvisor.ConverterInfo) {
                ConverterSelectionDialogCreationAdvisor.ConverterInfo info = (ConverterSelectionDialogCreationAdvisor.ConverterInfo)element;
                return info.getClassName();
            }
            return null;
        }
    }

    protected class ConverterFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public ConverterFilter() {
            super((FilteredItemsSelectionDialog)ConverterSelectionDialog.this);
        }

        public ConverterFilter(SearchPattern searchPattern) {
            super((FilteredItemsSelectionDialog)ConverterSelectionDialog.this, searchPattern);
        }

        public boolean isConsistentItem(Object item) {
            if (!(item instanceof ConverterSelectionDialogCreationAdvisor.ConverterInfo)) {
                return false;
            }
            ConverterSelectionDialogCreationAdvisor.ConverterInfo info = (ConverterSelectionDialogCreationAdvisor.ConverterInfo)item;
            return this.doesConverterExist(info.getId());
        }

        private boolean doesConverterExist(String id) {
            boolean exists = false;
            IJSFAppConfigManager mgr = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance((IProject)ConverterSelectionDialog.this._advisor.getIProject());
            if (mgr != null) {
                List converters = mgr.getConverters();
                for (ConverterType converter : converters) {
                    ConverterIdType converterId = converter.getConverterId();
                    if (converterId == null && id == null) {
                        exists = true;
                        break;
                    }
                    if (converterId != null && converterId.getTextContent() == null && id == null) {
                        exists = true;
                        break;
                    }
                    if (converterId == null || converterId.getTextContent() == null || !converterId.getTextContent().equals(id)) continue;
                    exists = true;
                    break;
                }
            }
            return exists;
        }

        public boolean matchItem(Object item) {
            if (!(item instanceof ConverterSelectionDialogCreationAdvisor.ConverterInfo)) {
                return false;
            }
            ConverterSelectionDialogCreationAdvisor.ConverterInfo info = (ConverterSelectionDialogCreationAdvisor.ConverterInfo)item;
            return this.matches(info.getId());
        }
    }

    private static final class ConverterLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private static final String WPE_PLUGUIN_ID = "org.eclipse.jst.jsf.common.ui";
        private static final String WPE_CONVERTER_IMAGE = "/icons/jsf_converter.gif";
        private ImageDescriptor _imageDescriptor;

        private ConverterLabelProvider() {
        }

        public Image getImage(Object element) {
            ImageDescriptor imageDescriptor = this.getImageDescriptor();
            if (imageDescriptor == null) {
                return null;
            }
            return CommonImages.createImage((ImageDescriptor)imageDescriptor);
        }

        private ImageDescriptor getImageDescriptor() {
            if (this._imageDescriptor == null) {
                this._imageDescriptor = Activator.imageDescriptorFromPlugin((String)WPE_PLUGUIN_ID, (String)WPE_CONVERTER_IMAGE);
            }
            return this._imageDescriptor;
        }

        public String getText(Object element) {
            if (element instanceof ConverterSelectionDialogCreationAdvisor.ConverterInfo) {
                ConverterSelectionDialogCreationAdvisor.ConverterInfo info = (ConverterSelectionDialogCreationAdvisor.ConverterInfo)element;
                return info.getId();
            }
            return null;
        }
    }

    private static final class ConverterSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private ConverterSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento memento) {
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
        }
    }
}

