/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.variable.jdtquery;

import java.util.List;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.IProjectVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.search.ui.text.Match;

public class ELJavaQueryParticipant
implements IQueryParticipant {
    public void search(ISearchRequestor requestor, QuerySpecification querySpecification, IProgressMonitor monitor) throws CoreException {
        if (querySpecification instanceof ElementQuerySpecification) {
            IJavaElement element = ((ElementQuerySpecification)querySpecification).getElement();
            if (element.getElementType() == 9) {
                this.handleMethod((IMethod)element);
            } else if (element.getElementType() == 7) {
                this.handleType((IType)element, requestor);
            }
        }
    }

    private void handleMethod(IMethod element) {
    }

    private void handleType(IType element, ISearchRequestor requestor) {
        String fullyQualifiedName = element.getFullyQualifiedName();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectVariablesCache projectCache;
            IProject proj = iProjectArray[n2];
            if (proj.isAccessible() && (projectCache = VariablesController.getInstance().getProjectCache(proj)) != null) {
                List variables = projectCache.getVariables();
                for (Variable var : variables) {
                    String name;
                    DataType type = var.getType();
                    if (type == null || !fullyQualifiedName.equals(name = type.getName())) continue;
                    ResourceLocation definitionLocation = var.getDefinitionLocation();
                    Match match = new Match((Object)definitionLocation.getResource(), (int)definitionLocation.getRange().getOffset(), (int)definitionLocation.getRange().getLength());
                    requestor.reportMatch(match);
                }
            }
            ++n2;
        }
    }

    public int estimateTicks(QuerySpecification specification) {
        return 0;
    }

    public IMatchPresentation getUIParticipant() {
        return null;
    }
}

