/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.validator;

import java.util.List;
import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.jsf.ui.Messages;
import oracle.eclipse.tools.webtier.jsf.ui.internal.Activator;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;
import org.eclipse.jst.jsf.validation.internal.appconfig.AppConfigValidationUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class NewValidatorDialog
extends SelectionStatusDialog {
    private final Shell shell;
    private final IProject project;
    private final ValidatorType validator;
    private final List<String> existingValidatorIds;
    private DataBindingContext dataBindingContext;
    private final UpdateValueStrategy updateValueStrategy;
    private Text validatorIdText;
    private Text validatorClassText;
    private Text descriptionText;
    private static final IStatus OK_STATUS = new Status(0, "oracle.eclipse.tools.webtier.jsf.ui", "");
    private static final IStatus ERROR_STATUS = new Status(4, "oracle.eclipse.tools.webtier.jsf.ui", "");
    private static final IStatus VALIDATOR_ID_EMPTY_STATUS = new Status(4, "oracle.eclipse.tools.webtier.jsf.ui", Messages.NewValidatorDialog_ValidatorIdCannotBeBlank);
    private static final IStatus DUPLICATE_VALIDATOR_ID_STATUS = new Status(4, "oracle.eclipse.tools.webtier.jsf.ui", Messages.NewValidatorDialog_ValidatorIdExists);
    private static final IStatus VALIDATOR_CLASS_NAME_EMPTY_STATUS = new Status(4, "oracle.eclipse.tools.webtier.jsf.ui", Messages.NewValidatorDialog_ValidatorClassCannotBeBlank);
    private static final IStatus VALIDATOR_CLASS_NAME_NOT_VALIDATOR_STATUS = new Status(4, "oracle.eclipse.tools.webtier.jsf.ui", Messages.NewValidatorDialog_ValidatorClassMustImplementValidator);
    private static final String HELPID = "oracle.eclipse.tools.webtier.jsf.ui.NewValidatorDialog";

    public NewValidatorDialog(Shell shell, IProject project, ValidatorType validator, List<String> existingValidatorIds) {
        super(shell);
        this.shell = shell;
        this.project = project;
        this.validator = validator;
        this.existingValidatorIds = existingValidatorIds;
        this.updateValueStrategy = new UpdateValueStrategy();
        this.updateValueStrategy.setAfterConvertValidator((IValidator)new ViewDataValidator());
        this.setTitle(Messages.NewValidatorDialog_NewValidatorDialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Layout layout = composite.getLayout();
        if (layout instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout;
            gridLayout.marginWidth = 14;
            gridLayout.marginHeight = 0;
            gridLayout.marginTop = 14;
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
        }
        Composite localParent = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 8;
        gridLayout.verticalSpacing = 8;
        localParent.setLayout((Layout)gridLayout);
        localParent.setLayoutData((Object)new GridData(4, 4, true, true));
        Label validatorIdLabel = new Label(localParent, 0);
        validatorIdLabel.setText(Messages.NewValidatorDialog_ValidatorIdLabel);
        this.validatorIdText = new Text(localParent, 2052);
        GridData validatorIdTextGridData = new GridData(4, 0x1000000, true, false);
        validatorIdTextGridData.minimumWidth = 265;
        this.validatorIdText.setLayoutData((Object)validatorIdTextGridData);
        this.getEmptyComposite(localParent);
        Label validatorClassLabel = new Label(localParent, 0);
        validatorClassLabel.setText(Messages.NewValidatorDialog_ValidatorClassLabel);
        this.validatorClassText = new Text(localParent, 2052);
        GridData validatorClassTextGridData = new GridData(4, 0x1000000, true, false);
        validatorClassTextGridData.minimumWidth = 265;
        this.validatorClassText.setLayoutData((Object)validatorClassTextGridData);
        ToolBar validatorClassBrowserButtonToolBar = this.getToolBar(localParent, 256);
        ToolItem selectClassButton1 = new ToolItem(validatorClassBrowserButtonToolBar, 8);
        selectClassButton1.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_BROWSE));
        selectClassButton1.setToolTipText(Messages.NewValidatorDialog_ClassBrowserTooltipText);
        selectClassButton1.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent se) {
                this.widgetSelected(se);
            }

            public void widgetSelected(SelectionEvent se) {
                NewValidatorDialog.this.validatorClassBrowserButtonClicked();
            }
        });
        Label descriptionLabel = new Label(localParent, 0);
        descriptionLabel.setText(Messages.JSFConfigAddNavigationCaseDialog_descLabel);
        GridData descriptionLabelGridData = new GridData(4, 1, false, false);
        descriptionLabel.setLayoutData((Object)descriptionLabelGridData);
        this.descriptionText = new Text(localParent, 2626);
        GridData descTextGridData = new GridData(4, 1, true, false);
        descTextGridData.heightHint = 40;
        descTextGridData.minimumWidth = 265;
        this.descriptionText.setLayoutData((Object)descTextGridData);
        this.bindData();
        this.setStatusLineAboveButtons(true);
        this.disableOkButton();
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, HELPID);
    }

    private void disableOkButton() {
        this.updateStatus(ERROR_STATUS);
    }

    private ToolBar getToolBar(Composite parent, int style) {
        ToolBar toolBar = new ToolBar(parent, 0x800000 | style);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        toolBar.setLayout((Layout)gridLayout);
        int alignStyle = 0x1000000;
        if ((style | 0x200) == 512) {
            alignStyle = 1;
        }
        GridData gridData = new GridData(alignStyle, alignStyle, false, false);
        toolBar.setLayoutData((Object)gridData);
        return toolBar;
    }

    private Composite getEmptyComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1, 1, false, false);
        gridData.widthHint = 0;
        gridData.heightHint = 0;
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    private void validatorClassBrowserButtonClicked() {
        try {
            SelectionDialog classBrowserDialog = this.createClassBrowserDialog(Messages.NewValidatorDialog_SelectValidatorClassDialogTitle, Messages.NewValidatorDialog_SelectValidatorClassDialogMessage);
            switch (classBrowserDialog.open()) {
                case 0: {
                    Object selectedClass = classBrowserDialog.getResult()[0];
                    if (selectedClass == null) {
                        return;
                    }
                    String fullyQualifiedClassName = ((IType)selectedClass).getFullyQualifiedName('.');
                    this.validatorClassText.setText(fullyQualifiedClassName);
                }
            }
        }
        catch (JavaModelException e) {
            LoggingService.logError((Plugin)Activator.getDefault(), (String)e.getLocalizedMessage());
        }
    }

    private void bindData() {
        this.dataBindingContext = new DataBindingContext();
        this.dataBindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.validatorIdText, (int)24), EMFObservables.observeValue((EObject)this.validator.getValidatorId(), (EStructuralFeature)FacesConfigPackage.eINSTANCE.getValidatorIdType_TextContent()), this.updateValueStrategy, new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        this.dataBindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.validatorClassText, (int)24), EMFObservables.observeValue((EObject)this.validator.getValidatorClass(), (EStructuralFeature)FacesConfigPackage.eINSTANCE.getValidatorClassType_TextContent()), this.updateValueStrategy, new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        this.dataBindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.descriptionText), EMFObservables.observeValue((EObject)((DescriptionType)this.validator.getDescription().get(0)), (EStructuralFeature)FacesConfigPackage.eINSTANCE.getDescriptionType_TextContent()), new UpdateValueStrategy(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        this.dataBindingContext.updateTargets();
    }

    protected void computeResult() {
        this.dataBindingContext.updateModels();
    }

    private boolean isValidValidatorId() {
        String validatorId = this.validatorIdText.getText().trim();
        if (validatorId.length() == 0) {
            this.updateStatus(VALIDATOR_ID_EMPTY_STATUS);
            return false;
        }
        if (this.existingValidatorIds.contains(validatorId)) {
            this.updateStatus(DUPLICATE_VALIDATOR_ID_STATUS);
            return false;
        }
        return true;
    }

    private boolean isValidValidatorClass() {
        String validatorClassName = this.validatorClassText.getText().trim();
        if (validatorClassName.length() == 0) {
            this.updateStatus(VALIDATOR_CLASS_NAME_EMPTY_STATUS);
            return false;
        }
        IMessage classNameValidationErrorMessage = AppConfigValidationUtil.validateClassName((String)validatorClassName, null, (boolean)true, (IProject)this.project);
        if (classNameValidationErrorMessage != null) {
            this.updateStatus((IStatus)new Status(4, "oracle.eclipse.tools.webtier.jsf.ui", classNameValidationErrorMessage.getText()));
            return false;
        }
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        IType type = null;
        try {
            type = javaProject.findType(validatorClassName);
            if (type != null && !AppConfigValidationUtil.isInstanceOf((IType)type, (String)"javax.faces.validator.Validator")) {
                this.updateStatus(VALIDATOR_CLASS_NAME_NOT_VALIDATOR_STATUS);
                return false;
            }
        }
        catch (JavaModelException jme) {
            LoggingService.logError((Plugin)Activator.getDefault(), (String)jme.getLocalizedMessage());
        }
        return true;
    }

    private SelectionDialog createClassBrowserDialog(String title, String message) throws JavaModelException {
        SelectionDialog classBrowserDialog = JavaUI.createTypeDialog((Shell)this.shell, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IProject)this.project, (int)2, (boolean)false);
        classBrowserDialog.setTitle(title);
        classBrowserDialog.setMessage(message);
        return classBrowserDialog;
    }

    private class ViewDataValidator
    implements IValidator {
        private ViewDataValidator() {
        }

        public IStatus validate(Object value) {
            if (!NewValidatorDialog.this.isValidValidatorId()) {
                return ERROR_STATUS;
            }
            if (!NewValidatorDialog.this.isValidValidatorClass()) {
                return ERROR_STATUS;
            }
            NewValidatorDialog.this.updateStatus(OK_STATUS);
            return OK_STATUS;
        }
    }
}

