/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import oracle.eclipse.tools.application.common.services.appservices.IWebRootResolver;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.util.wtp.webxml.WebXmlUpdater;
import oracle.eclipse.tools.webtier.common.services.util.ProjectUtil;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ComponentArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ConverterArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ManagedBeanArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationCaseArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.NavigationRuleArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ReferencedBeanArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.RenderKitArtifact;
import oracle.eclipse.tools.webtier.jsf.dependency.artifact.ValidatorArtifact;
import oracle.eclipse.tools.webtier.jsf.ui.Messages;
import oracle.eclipse.tools.webtier.jsf.ui.internal.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentTypeType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterForClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.FromOutcomeType;
import org.eclipse.jst.jsf.facesconfig.emf.FromViewIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanNameType;
import org.eclipse.jst.jsf.facesconfig.emf.ReferencedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitIdType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;
import org.eclipse.jst.jsf.facesconfig.ui.FacesConfigEditor;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class JsfUiUtil {
    private static final String DIALOG_SETTINGS_FILE = "dialog-settings.xml";
    private static final String DIALOG_SETTINGS_SECTION_FOR_SELECT_CONFIGURATION_FILE_DIALOG = "SelectConfigurationFileDialogSettings";
    private static final String DIALOG_SETTINGS_KEY_FOR_SELECTED_FACES_CONFIG_FILE = "SelectedFacesConfigFile";
    private static final IContentType CONTENTTYPE_JSPSOURCE = Platform.getContentTypeManager().getContentType("org.eclipse.jst.jsp.core.jspsource");
    private static final IContentType CONTENTTYPE_FACELETSOURCE = Platform.getContentTypeManager().getContentType("jsf.facelet");
    public static final int FCARTIFACTEDIT_MODE_READ = 0;
    public static final int FCARTIFACTEDIT_MODE_WRITE = 1;

    public static String getFacesConfigFile(IProject project, IProgressMonitor monitor) {
        WebXmlUpdater webXmlUpdater;
        List facesConfigFilesAddedViaContextParam;
        ArrayList<String> existingFacesConfigFilenames = new ArrayList<String>();
        if (ProjectUtil.existsInProjectContext((IProject)project, (String)"/WEB-INF/faces-config.xml")) {
            existingFacesConfigFilenames.add("/WEB-INF/faces-config.xml");
        }
        if ((facesConfigFilesAddedViaContextParam = (webXmlUpdater = new WebXmlUpdater(project, monitor)).getContextParamValues("javax.faces.CONFIG_FILES")) != null) {
            for (String facesConfigRelativePath : facesConfigFilesAddedViaContextParam) {
                if (!ProjectUtil.existsInProjectContext((IProject)project, (String)facesConfigRelativePath) || existingFacesConfigFilenames.contains(facesConfigRelativePath)) continue;
                existingFacesConfigFilenames.add(facesConfigRelativePath);
            }
        }
        if (existingFacesConfigFilenames.isEmpty()) {
            MessageBox msgBox = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 32);
            msgBox.setText(Messages.JsfUiUtil_NoFacesConfigFile_title);
            msgBox.setMessage(Messages.JsfUiUtil_NoFacesConfigFile_message);
            msgBox.open();
            throw new IllegalArgumentException(Messages.JsfUiUtil_NoFacesConfigFile_message);
        }
        if (existingFacesConfigFilenames.size() == 1) {
            return ((String)existingFacesConfigFilenames.get(0)).substring(1);
        }
        String facesConfigFile = JsfUiUtil.showSelectConfigurationFileDialog(existingFacesConfigFilenames);
        if (facesConfigFile != null && facesConfigFile.startsWith("/")) {
            facesConfigFile = facesConfigFile.substring(1);
        }
        return facesConfigFile;
    }

    public static String showSelectConfigurationFileDialog(List<String> input) {
        HashSet<String> inputSet = new HashSet<String>(input);
        ArrayList<String> sanitizedInputList = new ArrayList<String>(inputSet);
        Collections.sort(sanitizedInputList);
        ListDialog dialog = new ListDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
        dialog.setTitle(Messages.JsfUiUtil_SelectConfigurationFileDialogTitle);
        dialog.setMessage(Messages.JsfUiUtil_SelectConfigurationFileDialogDescription);
        dialog.setInput(sanitizedInputList);
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setLabelProvider((ILabelProvider)new LabelProvider());
        DialogSettings settings = new DialogSettings(DIALOG_SETTINGS_SECTION_FOR_SELECT_CONFIGURATION_FILE_DIALOG);
        String lastSelectedFile = JsfUiUtil.getDialogSetting(DIALOG_SETTINGS_KEY_FOR_SELECTED_FACES_CONFIG_FILE, input.get(0), (IDialogSettings)settings, DIALOG_SETTINGS_FILE);
        dialog.setInitialElementSelections(Collections.singletonList(lastSelectedFile));
        switch (dialog.open()) {
            case 0: {
                String selectedFacesConfig = dialog.getResult()[0].toString();
                JsfUiUtil.putDialogSetting(DIALOG_SETTINGS_KEY_FOR_SELECTED_FACES_CONFIG_FILE, selectedFacesConfig, (IDialogSettings)settings, DIALOG_SETTINGS_FILE);
                return selectedFacesConfig;
            }
        }
        return null;
    }

    private static String getDialogSetting(String key, String defaultValue, IDialogSettings settings, String settingsFile) {
        try {
            settings.load(DIALOG_SETTINGS_FILE);
        }
        catch (IOException iOException) {}
        String value = settings.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private static void putDialogSetting(String key, String value, IDialogSettings settings, String settingsFile) {
        settings.put(key, value);
        try {
            settings.save(DIALOG_SETTINGS_FILE);
        }
        catch (IOException e) {
            LoggingService.logError((Plugin)Activator.getDefault(), (String)e.getLocalizedMessage());
        }
    }

    private static List<String> getRelativeFilenamesForJSF(IFolder rootFolder, String[] excludePattern) {
        ArrayList<String> filenames = new ArrayList<String>();
        IProject project = rootFolder.getProject();
        Project oepeProj = (Project)project.getAdapter(Project.class);
        if (oepeProj != null) {
            if (oepeProj.hasTechnology("jsf", "2.0")) {
                filenames.addAll(JsfUiUtil.getRelativeFaceletFilenames(rootFolder, excludePattern));
            }
            filenames.addAll(JsfUiUtil.getRelativeJSPFilenames(rootFolder, excludePattern));
        }
        return filenames;
    }

    private static List<String> getRelativeFaceletFilenames(IFolder rootFolder, String[] excludePattern) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        JsfUiUtil.collectFilesByContentType(rootFolder, files, CONTENTTYPE_FACELETSOURCE);
        return JsfUiUtil.filterAndSort(rootFolder, excludePattern, files);
    }

    public static List<String> getRelativeJSPFilenames(IFolder rootFolder, String[] excludePatterns) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        JsfUiUtil.collectFilesByContentType(rootFolder, files, CONTENTTYPE_JSPSOURCE);
        return JsfUiUtil.filterAndSort(rootFolder, excludePatterns, files);
    }

    private static List<String> filterAndSort(IFolder rootFolder, String[] excludePatterns, List<IFile> files) {
        ArrayList<String> filenames = new ArrayList<String>();
        IPath rootPath = rootFolder.getProjectRelativePath();
        for (IFile file : files) {
            IPath filePath = file.getProjectRelativePath();
            IPath relFilePath = filePath.makeRelativeTo(rootPath);
            String filename = relFilePath.toString();
            if (!filename.startsWith("/")) {
                filename = "/" + filename;
            }
            boolean exclude = false;
            String[] stringArray = excludePatterns;
            int n = excludePatterns.length;
            int n2 = 0;
            while (n2 < n) {
                String excludePattern = stringArray[n2];
                if (filename.contains(excludePattern)) {
                    exclude = true;
                }
                ++n2;
            }
            if (exclude) continue;
            filenames.add(filename);
        }
        Collections.sort(filenames);
        return filenames;
    }

    private static void collectFilesByContentType(IFolder rootFolder, List<IFile> files, IContentType matchContentType) {
        if (rootFolder != null && files != null) {
            try {
                IResource[] children = rootFolder.members();
                if (children != null) {
                    IResource[] iResourceArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContentType contentType;
                        IContentDescription contentDesc;
                        IResource child = iResourceArray[n2];
                        if (child instanceof IFolder) {
                            JsfUiUtil.collectFilesByContentType((IFolder)child, files, matchContentType);
                        } else if (child instanceof IFile && (contentDesc = ((IFile)child).getContentDescription()) != null && (contentType = contentDesc.getContentType()) != null && contentType.isKindOf(matchContentType)) {
                            files.add((IFile)child);
                        }
                        ++n2;
                    }
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public static String selectJSFFileFromDialog(IProject iProject) {
        IResource resourceForPath;
        IWebRootResolver appService;
        Project oepeProj;
        String fileName = null;
        if (iProject != null && (oepeProj = (Project)iProject.getAdapter(Project.class)) != null && (appService = (IWebRootResolver)oepeProj.getAppService(IWebRootResolver.class)) != null && (resourceForPath = appService.getResourceForPath("/")) != null && resourceForPath.getType() == 2) {
            Object result;
            Object[] results;
            IFolder webContentFolder = (IFolder)resourceForPath;
            List<String> JSPs = JsfUiUtil.getRelativeFilenamesForJSF(webContentFolder, new String[]{"/META-INF/", "/WEB-INF/"});
            ListDialog dialog = new ListDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
            dialog.setTitle(Messages.JsfUiUtil_SelectJSPFromDialog_title);
            dialog.setMessage(Messages.JsfUiUtil_SelectJSPFromDialog_description);
            dialog.setInput(JSPs);
            dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            dialog.setLabelProvider((ILabelProvider)new LabelProvider());
            if (dialog.open() == 0 && dialog != null && (results = dialog.getResult()) != null && results.length > 0 && (result = results[0]) != null) {
                fileName = result.toString();
            }
        }
        return fileName;
    }

    public static FacesConfigArtifactEdit getFacesConfigArtifactEdit(IArtifact artifact, int mode) {
        IVirtualFolder virtFolder;
        IVirtualComponent virtComponent;
        IResource resource;
        ResourceLocation location;
        IProject iProject;
        FacesConfigArtifactEdit fcConfigEdit = null;
        if (artifact != null && (iProject = artifact.getProject()) != null && iProject.isAccessible() && (location = artifact.getLocation()) != null && (resource = location.getResource()) instanceof IFile && (virtComponent = ComponentCore.createComponent((IProject)iProject)) != null && (virtFolder = virtComponent.getRootFolder()) != null) {
            IPath webContentPath = virtFolder.getProjectRelativePath();
            IPath fcConfigPath = ((IFile)resource).getProjectRelativePath();
            fcConfigPath = fcConfigPath.makeRelativeTo(webContentPath);
            if (mode == 0) {
                fcConfigEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)iProject, (String)fcConfigPath.toString());
            } else if (mode == 1) {
                fcConfigEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)iProject, (String)fcConfigPath.toString());
            }
        }
        return fcConfigEdit;
    }

    public static NavigationRuleType getNavigationRule(FacesConfigArtifactEdit fcArtifactEdit, IArtifact artifact) {
        FacesConfigType facesConfig;
        NavigationRuleType navigationRuleType = null;
        if (fcArtifactEdit != null && artifact instanceof NavigationRuleArtifact && (facesConfig = fcArtifactEdit.getFacesConfig()) != null) {
            EList navRules = facesConfig.getNavigationRule();
            for (Object navRule : navRules) {
                if (!(navRule instanceof NavigationRuleType)) continue;
                FromViewIdType fromViewIdType = ((NavigationRuleType)navRule).getFromViewId();
                if (fromViewIdType != null) {
                    String fromViewId = fromViewIdType.getTextContent();
                    if (fromViewId == null || !fromViewId.equals(artifact.getName())) continue;
                    navigationRuleType = (NavigationRuleType)navRule;
                    break;
                }
                if (!((NavigationRuleArtifact)artifact).hasNoFromViewIdElement()) continue;
                navigationRuleType = (NavigationRuleType)navRule;
                break;
            }
        }
        return navigationRuleType;
    }

    public static NavigationCaseType getNavigationCase(FacesConfigArtifactEdit fcArtifactEdit, IArtifact artifact) {
        NavigationRuleType navigationRuleType;
        IArtifact ownerArtifact;
        NavigationCaseType navigationCaseType = null;
        if (fcArtifactEdit != null && artifact instanceof NavigationCaseArtifact && (ownerArtifact = artifact.getOwner()) instanceof NavigationRuleArtifact && (navigationRuleType = JsfUiUtil.getNavigationRule(fcArtifactEdit, ownerArtifact)) != null) {
            EList navCases = navigationRuleType.getNavigationCase();
            for (Object navCase : navCases) {
                String fromOutcome;
                FromOutcomeType fromOutcomeType;
                if (!(navCase instanceof NavigationCaseType) || (fromOutcomeType = ((NavigationCaseType)navCase).getFromOutcome()) == null || (fromOutcome = fromOutcomeType.getTextContent()) == null || !fromOutcome.equals(((NavigationCaseArtifact)artifact).getOutcome())) continue;
                navigationCaseType = (NavigationCaseType)navCase;
                break;
            }
        }
        return navigationCaseType;
    }

    public static ManagedBeanType getManagedBean(FacesConfigArtifactEdit fcArtifactEdit, IArtifact artifact) {
        FacesConfigType facesConfig;
        ManagedBeanType managedBeanType = null;
        if (fcArtifactEdit != null && artifact instanceof ManagedBeanArtifact && (facesConfig = fcArtifactEdit.getFacesConfig()) != null) {
            EList managedBeans = facesConfig.getManagedBean();
            for (Object managedBean : managedBeans) {
                String managedBeanName;
                ManagedBeanNameType managedBeanNameType;
                if (!(managedBean instanceof ManagedBeanType) || (managedBeanNameType = ((ManagedBeanType)managedBean).getManagedBeanName()) == null || (managedBeanName = managedBeanNameType.getTextContent()) == null || !managedBeanName.equals(artifact.getName())) continue;
                managedBeanType = (ManagedBeanType)managedBean;
                break;
            }
        }
        return managedBeanType;
    }

    public static ComponentType getComponent(FacesConfigArtifactEdit fcArtifactEdit, IArtifact artifact) {
        FacesConfigType facesConfig;
        ComponentType componentType = null;
        if (fcArtifactEdit != null && artifact instanceof ComponentArtifact && (facesConfig = fcArtifactEdit.getFacesConfig()) != null) {
            EList components = facesConfig.getComponent();
            for (Object component : components) {
                String componentTypeText;
                ComponentTypeType componentTypeType;
                if (!(component instanceof ComponentType) || (componentTypeType = ((ComponentType)component).getComponentType()) == null || (componentTypeText = componentTypeType.getTextContent()) == null || !componentTypeText.equals(artifact.getName())) continue;
                componentType = (ComponentType)component;
                break;
            }
        }
        return componentType;
    }

    public static ConverterType getConverter(FacesConfigArtifactEdit fcArtifactEdit, IArtifact artifact) {
        FacesConfigType facesConfig;
        ConverterType converterType = null;
        if (fcArtifactEdit != null && artifact instanceof ConverterArtifact && (facesConfig = fcArtifactEdit.getFacesConfig()) != null) {
            EList converters = facesConfig.getConverter();
            for (Object converter : converters) {
                String converterForClass;
                if (!(converter instanceof ConverterType)) continue;
                ConverterIdType converterIdType = ((ConverterType)converter).getConverterId();
                if (converterIdType != null) {
                    String converterId = converterIdType.getTextContent();
                    if (converterId == null || !converterId.equals(artifact.getName())) continue;
                    converterType = (ConverterType)converter;
                    break;
                }
                ConverterForClassType converterForClassType = ((ConverterType)converter).getConverterForClass();
                if (converterForClassType == null || (converterForClass = converterForClassType.getTextContent()) == null || !converterForClass.equals(artifact.getName())) continue;
                converterType = (ConverterType)converter;
                break;
            }
        }
        return converterType;
    }

    public static ReferencedBeanType getReferencedBean(FacesConfigArtifactEdit fcArtifactEdit, IArtifact artifact) {
        FacesConfigType facesConfig;
        ReferencedBeanType referencedBeanType = null;
        if (fcArtifactEdit != null && artifact instanceof ReferencedBeanArtifact && (facesConfig = fcArtifactEdit.getFacesConfig()) != null) {
            EList referencedBeans = facesConfig.getReferencedBean();
            for (Object referencedBean : referencedBeans) {
                String referencedBeanName;
                ReferencedBeanNameType referencedBeanNameType;
                if (!(referencedBean instanceof ReferencedBeanType) || (referencedBeanNameType = ((ReferencedBeanType)referencedBean).getReferencedBeanName()) == null || (referencedBeanName = referencedBeanNameType.getTextContent()) == null || !referencedBeanName.equals(artifact.getName())) continue;
                referencedBeanType = (ReferencedBeanType)referencedBean;
                break;
            }
        }
        return referencedBeanType;
    }

    public static RenderKitType getRenderKit(FacesConfigArtifactEdit fcArtifactEdit, IArtifact artifact) {
        FacesConfigType facesConfig;
        RenderKitType renderKitType = null;
        if (fcArtifactEdit != null && artifact instanceof RenderKitArtifact && (facesConfig = fcArtifactEdit.getFacesConfig()) != null) {
            EList renderKits = facesConfig.getRenderKit();
            for (Object renderKit : renderKits) {
                String renderKitId;
                RenderKitIdType renderKitIdType;
                if (!(renderKit instanceof RenderKitType) || (renderKitIdType = ((RenderKitType)renderKit).getRenderKitId()) == null || (renderKitId = renderKitIdType.getTextContent()) == null || !renderKitId.equals(artifact.getName())) continue;
                renderKitType = (RenderKitType)renderKit;
                break;
            }
        }
        return renderKitType;
    }

    public static ValidatorType getValidator(FacesConfigArtifactEdit fcArtifactEdit, IArtifact artifact) {
        FacesConfigType facesConfig;
        ValidatorType validatorType = null;
        if (fcArtifactEdit != null && artifact instanceof ValidatorArtifact && (facesConfig = fcArtifactEdit.getFacesConfig()) != null) {
            EList validators = facesConfig.getValidator();
            for (Object validator : validators) {
                String validatorId;
                ValidatorIdType validatorIdType;
                if (!(validator instanceof ValidatorType) || (validatorIdType = ((ValidatorType)validator).getValidatorId()) == null || (validatorId = validatorIdType.getTextContent()) == null || !validatorId.equals(artifact.getName())) continue;
                validatorType = (ValidatorType)validator;
                break;
            }
        }
        return validatorType;
    }

    public static void save(FacesConfigArtifactEdit fcArtifactEdit) {
        if (fcArtifactEdit != null) {
            Resource resource;
            IStatus status;
            IWorkspace workspace;
            IProject project;
            IFile file = fcArtifactEdit.getFile();
            if (file != null && file.isAccessible() && (project = file.getProject()) != null && project.isAccessible() && (workspace = project.getWorkspace()) != null && !(status = workspace.validateEdit(new IFile[]{file}, IWorkspace.VALIDATE_PROMPT)).isOK()) {
                LoggingService.logWarning((Plugin)Activator.getDefault(), (String)status.getMessage());
                return;
            }
            FacesConfigType facesConfig = fcArtifactEdit.getFacesConfig();
            if (facesConfig != null) {
                IEditorReference[] editorRefs;
                IWorkbenchPage workbenchPage = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage();
                IEditorReference[] iEditorReferenceArray = editorRefs = workbenchPage.findEditors(null, "org.eclipse.jst.jsf.facesconfig.ui.FacesConfigEditor", 2);
                int n = editorRefs.length;
                int n2 = 0;
                while (n2 < n) {
                    FacesConfigEditor fcEditor;
                    FacesConfigType editorsFacesConfig;
                    IEditorReference editorRef = iEditorReferenceArray[n2];
                    IEditorPart editor = editorRef.getEditor(false);
                    if (editor instanceof FacesConfigEditor && (editorsFacesConfig = (fcEditor = (FacesConfigEditor)editor).getFacesConfig()) == facesConfig) {
                        workbenchPage.activate((IWorkbenchPart)fcEditor);
                        MessageBox msgBox = new MessageBox(Workbench.getInstance().getDisplay().getActiveShell(), 192);
                        msgBox.setText(Messages.JsfUiUtil_SaveModifiedOpenFile_title);
                        msgBox.setMessage(Messages.JsfUiUtil_SaveModifiedOpenFile_message);
                        if (msgBox.open() == 64) {
                            fcEditor.doSave(null);
                        }
                        return;
                    }
                    ++n2;
                }
            }
            if ((resource = fcArtifactEdit.getDeploymentDescriptorResource()) != null) {
                try {
                    resource.save(Collections.EMPTY_MAP);
                }
                catch (IOException ioe) {
                    LoggingService.logError((Plugin)Activator.getDefault(), (String)ioe.getLocalizedMessage());
                }
            }
        }
    }
}

