/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.appservices.IAppLocalizer;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentLocalizationContext;
import oracle.eclipse.tools.application.common.services.util.LocalizeUtil;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.JavaResourceBundleDataType;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.application.common.services.variables.VariablesIterator;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IStructuredXMLModelVisitor;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.StructuredModelFactory;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.util.ObjectUtil;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;
import oracle.eclipse.tools.webtier.jsf.refactoring.internal.JsfRefactoringUtil;
import oracle.eclipse.tools.webtier.jsf.ui.internal.Activator;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.NLSSubstitution;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.NLSSubstitutionGroup;
import oracle.eclipse.tools.webtier.jsp.model.dom.JSPNamespaceContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jst.jsf.common.internal.types.CompositeType;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.metadataprocessors.IMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataEnabledProcessingFactory;
import org.eclipse.jst.jsf.metadataprocessors.features.ELIsNotValidException;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidELValues;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.BooleanType;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.ColorType;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.ComponentIDType;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.CurrencyCodeType;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.LanguageCodeType;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.LinkType;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.LocaleType;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.MethodBindingType;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.NumberType;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.TimeZoneType;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NLSHint {
    private static final String WTP_MODEL_PROVIDER = "org.eclipse.wst.sse.core.StructuredModelManager";
    public static final String DEFAULT_VAR_NAME = "msg";
    private NLSSubstitutionGroup loneSubstitutionGroup;
    private Map<IFile, NLSSubstitutionGroup> groupsMap = new HashMap<IFile, NLSSubstitutionGroup>();

    public NLSHint(IFile file) {
        Assert.isNotNull((Object)file);
        this.createSubstitutionGroups(file);
    }

    private void createSubstitutionGroups(IFile file) {
        IDocument doc = (IDocument)file.getAdapter(IDocument.class);
        if (doc == null) {
            return;
        }
        IDocumentLocalizationContext context = (IDocumentLocalizationContext)doc.getAdapter(IDocumentLocalizationContext.class);
        if (context == null) {
            return;
        }
        try {
            IVisitableDOMModel model = StructuredModelFactory.getVisitableModelForRead((IFile)file, (String)WTP_MODEL_PROVIDER);
            JSPVisitor visitor = new JSPVisitor(model, file);
            model.accept((IStructuredXMLModelVisitor)visitor);
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
        catch (IOException e) {
            Activator.log(e);
        }
    }

    public NLSSubstitutionGroup getLoneSubstitutionGroup() {
        return this.loneSubstitutionGroup;
    }

    public List<NLSSubstitutionGroup> getSubstitutionGroups() {
        return new ArrayList<NLSSubstitutionGroup>(this.groupsMap.values());
    }

    private static class AttributeValidator {
        private static final Map<String, String[]> af_ElementAttrMap = new HashMap<String, String[]>();
        private static final Map<String, String[]> h_ElementAttrMap = new HashMap<String, String[]>();
        private static final Map<String, String[]> f_ElementAttrMap = new HashMap<String, String[]>();
        private static final Map<String, Map<String, String[]>> nsElementMap = new HashMap<String, Map<String, String[]>>();
        private static final Set<String> ignoredNamespaces = new HashSet<String>();
        private JSPNamespaceContext nsContext = new JSPNamespaceContext();

        static {
            ignoredNamespaces.add("http://java.sun.com/jsp/jstl/fmt");
            ignoredNamespaces.add("http://java.sun.com/jstl/fmt");
            ignoredNamespaces.add("http://java.sun.com/jstl/fmt_rt");
            ignoredNamespaces.add("http://java.sun.com/jsp/jstl/core");
            ignoredNamespaces.add("http://java.sun.com/jstl/core");
            ignoredNamespaces.add("http://java.sun.com/jstl/core_rt");
            ignoredNamespaces.add("http://java.sun.com/jsp/jstl/sql");
            ignoredNamespaces.add("http://java.sun.com/jstl/sql");
            ignoredNamespaces.add("http://java.sun.com/jstl/sql_rt");
            ignoredNamespaces.add("http://java.sun.com/jstl/xml");
            ignoredNamespaces.add("http://java.sun.com/jsp/jstl/xml");
            ignoredNamespaces.add("http://java.sun.com/jstl/xml_rt");
            nsElementMap.put("http://xmlns.oracle.com/adf/faces/rich", af_ElementAttrMap);
            nsElementMap.put("http://java.sun.com/jsf/html", h_ElementAttrMap);
            nsElementMap.put("http://java.sun.com/jsf/core", f_ElementAttrMap);
            af_ElementAttrMap.put("table", new String[]{"var"});
            af_ElementAttrMap.put("column", new String[]{"sortProperty"});
            af_ElementAttrMap.put("selectBooleanRadio", new String[]{"group"});
            af_ElementAttrMap.put("message", new String[]{"for"});
            h_ElementAttrMap.put("commandButton", new String[]{"type"});
            h_ElementAttrMap.put("dataTable", new String[]{"var"});
            f_ElementAttrMap.put("convertNumber", new String[]{"type"});
            f_ElementAttrMap.put("convertDateTime", new String[]{"dateStyle", "type", "timeStyle"});
            f_ElementAttrMap.put("selectManyCheckbox", new String[]{"layout"});
        }

        private AttributeValidator() {
        }

        boolean isIgnored(IDOMAttr attribute) {
            if (attribute.getOwnerElement() != null) {
                Element element = attribute.getOwnerElement();
                String elementName = element.getLocalName();
                String attrName = attribute.getLocalName();
                String ns = this.nsContext.getNamespace((Node)element);
                if (ns != null) {
                    String[] attributes;
                    if (ignoredNamespaces.contains(ns)) {
                        return true;
                    }
                    Map<String, String[]> elementMap = nsElementMap.get(ns);
                    if (elementMap != null && (attributes = elementMap.get(elementName)) != null && Arrays.asList(attributes).contains(attrName)) {
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private class JSPVisitor
    implements IStructuredXMLModelVisitor {
        private IStructuredDocument doc;
        private IFile file;

        public JSPVisitor(IVisitableDOMModel model, IFile file) {
            this.doc = model.getModel().getStructuredDocument();
            this.file = file;
        }

        public boolean visit(IDOMNode node) {
            return true;
        }

        public boolean visit(IDOMElement element) {
            this.checkValidElement(element);
            return true;
        }

        public boolean visit(IDOMDocument document) {
            return true;
        }

        public boolean visit(IDOMAttr attribute) {
            if (this.checkValidAttribute(attribute)) {
                int regOffset = attribute.getValueRegionStartOffset();
                int regLength = attribute.getValueRegionText().length();
                String attValue = attribute.getValueRegionText();
                this.addSubstitution(regOffset, regLength, attValue);
            }
            return false;
        }

        private void addSubstitution(int regOffset, int regLength, String attValue) {
            String value = new String(attValue).trim();
            if (StringUtils.isQuoted((String)attValue)) {
                ++regOffset;
                regLength -= 2;
                value = value.substring(1);
                value = value.substring(0, value.length() - 1);
            }
            NLSElement element = new NLSElement(value, regOffset, regLength, 0, false);
            NLSSubstitution substitution = new NLSSubstitution(2, value, element);
            this.addToSubstitutionGroup(substitution);
        }

        private void addToSubstitutionGroup(NLSSubstitution substitution) {
            IDocument document = (IDocument)this.file.getAdapter(IDocument.class);
            Project project = document.getProject();
            IAppLocalizer appService = (IAppLocalizer)project.getAppService(IAppLocalizer.class);
            Set allBaseNames = appService.getAllBaseNames();
            boolean loneSubstitution = true;
            for (String basename : allBaseNames) {
                IBundleResource bundleResource = LocalizeUtil.INSTANCE.getBundleResource(substitution.getNLSElement().getPosition().getOffset(), basename, document);
                if (bundleResource == null) continue;
                IFile bundleFile = bundleResource.getUnderlyingResource();
                if (bundleFile == null) {
                    String packageName = ObjectUtil.getPackageName((String)basename);
                    String className = ObjectUtil.getClassName((String)basename);
                    packageName = packageName != null ? packageName : "";
                    List sourcePaths = JavaUtil.getProjectRelativeSourcePaths((IProject)this.file.getProject());
                    for (IPath srcPath : sourcePaths) {
                        IPath path = srcPath.append(packageName).append(String.valueOf(className) + ".properties");
                        IFile propertyFile = this.file.getProject().getFile(path);
                        if (propertyFile == null || !propertyFile.exists()) continue;
                        bundleFile = propertyFile;
                        break;
                    }
                }
                if (bundleFile == null) continue;
                NLSSubstitutionGroup group = (NLSSubstitutionGroup)NLSHint.this.groupsMap.get(bundleFile);
                if (group == null) {
                    group = new NLSSubstitutionGroup(bundleFile, false);
                    String var = this.getRepresentingVariableFor(basename);
                    group.setBaseName(basename);
                    group.setBundleVariable(var);
                    NLSHint.this.groupsMap.put(bundleFile, group);
                }
                group.addSubstitution(substitution);
                loneSubstitution = false;
            }
            if (loneSubstitution) {
                IPath srcPath;
                List srcPaths = JavaUtil.getProjectRelativeSourcePaths((IProject)this.file.getProject());
                IPath iPath = srcPath = srcPaths != null && srcPaths.size() > 0 ? (IPath)srcPaths.get(0) : null;
                if (srcPath != null) {
                    IFile defaultBundleFile = this.file.getProject().getFile(srcPath.append("messages.properties"));
                    NLSSubstitutionGroup group = (NLSSubstitutionGroup)NLSHint.this.groupsMap.get(defaultBundleFile);
                    if (group == null) {
                        group = new NLSSubstitutionGroup(defaultBundleFile, true);
                    }
                    group.addSubstitution(substitution);
                    group.setBundleVariable(NLSHint.DEFAULT_VAR_NAME);
                    group.setBaseName(JsfRefactoringUtil.getFullyQualifiedFileName((IFile)defaultBundleFile));
                    NLSHint.this.groupsMap.put(defaultBundleFile, group);
                }
            }
        }

        private String getRepresentingVariableFor(String basename) {
            VariablesIterator iter = VariablesController.getInstance().iterator(this.file, false);
            while (iter.hasNext()) {
                Variable var = iter.next();
                DataType varType = var.getType();
                DataType type = null;
                type = varType.isEnumerable() ? varType.getComponentType() : varType;
                if (!(type instanceof JavaResourceBundleDataType) || !basename.equals(((JavaResourceBundleDataType)type).getBaseName())) continue;
                return var.getName();
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean checkValidAttribute(IDOMAttr attribute) {
            IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((org.eclipse.jface.text.IDocument)this.doc, (Node)attribute);
            ITaglibContextResolver contextResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTaglibContextResolver(context);
            String uri = contextResolver.getTagURIForNodeName((Node)attribute);
            List feature = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IValidELValues.class, context, uri, attribute.getOwnerElement().getLocalName(), attribute.getName());
            IMetaDataEnabledFeature processor = feature.size() > 0 ? (IMetaDataEnabledFeature)feature.get(0) : null;
            if (processor == null) return false;
            if (!this.isCompatibleType(processor)) return false;
            try {
                String[] signatures;
                CompositeType type = ((IValidELValues)processor).getExpectedRuntimeType();
                if (type == null) return false;
                String value = attribute.getValue();
                if (value != null) {
                    if (value.trim().indexOf("#{") >= 0) return false;
                    if (value.trim().indexOf("${") >= 0) return false;
                    if (value.trim().indexOf("<%=") >= 0) return false;
                    if (value.trim().equals("")) {
                        return false;
                    }
                }
                if (new AttributeValidator().isIgnored(attribute)) {
                    return false;
                }
                String[] stringArray = signatures = type.getSignatures();
                int n = signatures.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    String signature = stringArray[n2];
                    if (signature.indexOf("java.lang.String") > 0) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (ELIsNotValidException eLIsNotValidException) {
                return false;
            }
        }

        private boolean isCompatibleType(IMetaDataEnabledFeature processor) {
            return processor instanceof IValidELValues && !(processor instanceof BooleanType) && !(processor instanceof ColorType) && !(processor instanceof CurrencyCodeType) && !(processor instanceof LanguageCodeType) && !(processor instanceof LinkType) && !(processor instanceof NumberType) && !(processor instanceof TimeZoneType) && !(processor instanceof MethodBindingType) && !(processor instanceof LocaleType) && !(processor instanceof ComponentIDType);
        }

        private boolean checkValidElement(IDOMElement element) {
            return true;
        }
    }
}

