/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.refactoring;

import java.text.MessageFormat;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.FixIdsWizard;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.Messages;
import oracle.eclipse.tools.webtier.ui.utils.TagIDUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class FixIdsCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof IFile) {
            IFile sourceFile = (IFile)((IStructuredSelection)selection).getFirstElement();
            TextFileChange change = (TextFileChange)TagIDUtils.fixFragmentIds((IFile)sourceFile);
            if (change == null || change.getEdit() == null || !change.getEdit().hasChildren()) {
                MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)MessageFormat.format(Messages.FixIdWizardPage_title, sourceFile.getName()), (String)Messages.FixIdWizardPage_nothing_to_fix);
            } else {
                FixIdsWizard.open(sourceFile, HandlerUtil.getActiveShell((ExecutionEvent)event));
            }
        }
        return null;
    }
}

