/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.refactoring;

import java.text.MessageFormat;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.AbstractEditorAction;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.FixIdsWizard;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.Messages;
import oracle.eclipse.tools.webtier.ui.utils.TagIDUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class FixIdsAction
extends AbstractEditorAction {
    @Override
    protected void performAction(StructuredTextEditor se) {
        IEditorInput editorInput = se.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFile sourceFile = ((IFileEditorInput)editorInput).getFile();
            TextFileChange change = (TextFileChange)TagIDUtils.fixFragmentIds((IFile)sourceFile);
            if (change == null || change.getEdit() == null || !change.getEdit().hasChildren()) {
                MessageDialog.openInformation((Shell)se.getSite().getShell(), (String)MessageFormat.format(Messages.FixIdWizardPage_title, sourceFile.getName()), (String)Messages.FixIdWizardPage_nothing_to_fix);
            } else {
                FixIdsWizard.open(sourceFile, se.getSite().getShell());
            }
        }
    }
}

