/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.webtier.jsf.metadata.FacetMetadataUtil;
import oracle.eclipse.tools.webtier.ui.tagdrop.FacetMessages;
import org.eclipse.emf.ecore.xml.type.SimpleAnyType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.jsf.common.metadata.traittypes.traittypes.ListOfValues;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.html.core.internal.format.HTMLFormatter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FacetSelectionAction
extends Action {
    private static final String XMLNS = "xmlns";
    private static final String HTTP_JAVA_SUN_COM_JSF_CORE = "http://java.sun.com/jsf/core";
    private static final String ELEMENT_FACET = "facet";
    private static final String ATTR_NAME = "name";

    public FacetSelectionAction() {
        super("Facets", 4);
    }

    public boolean isEnabled() {
        return this.isFacetMenuEnabled();
    }

    public String getText() {
        IDOMElement element = this.getSelectedElement();
        if (element != null) {
            return "Facets - " + element.getNodeName();
        }
        return "Facets";
    }

    public IMenuCreator getMenuCreator() {
        return new IMenuCreator(){
            private Menu menu;

            public Menu getMenu(Menu parent) {
                if (this.menu == null) {
                    this.menu = new Menu(parent);
                    List<IAction> actions = this.getFacetEditingActions();
                    for (IAction action : actions) {
                        ActionContributionItem item = new ActionContributionItem(action);
                        item.fill(this.menu, -1);
                    }
                }
                return this.menu;
            }

            public Menu getMenu(Control parent) {
                return null;
            }

            private List<IAction> getFacetEditingActions() {
                ListOfValues values;
                ArrayList<IAction> result = new ArrayList<IAction>();
                IDOMElement element = FacetSelectionAction.this.getSelectedElement();
                if (element != null && (values = FacetSelectionAction.this.getListOfValuesFor(element)) != null) {
                    for (Object value : values.getEntries()) {
                        if (!(value instanceof SimpleAnyType)) continue;
                        String facetName = ((SimpleAnyType)value).getRawValue();
                        result.add(FacetSelectionAction.this.createFacetAction(element, facetName));
                    }
                }
                return result;
            }

            public void dispose() {
                if (this.menu != null) {
                    this.menu.dispose();
                    this.menu = null;
                }
            }
        };
    }

    private IAction createFacetAction(final IDOMElement parent, final String facetName) {
        return new Action(facetName, 2){

            public void run() {
                boolean confirm;
                if (this.isChecked() && FacetSelectionAction.this.hasFacetWithName(parent, facetName) && FacetSelectionAction.this.notEmptyFacet(parent, facetName) && !(confirm = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)(String.valueOf(facetName) + "- Facet Not Empty"), (String)(String.valueOf(facetName) + "- The facet is not empty. Are you sure you want to proceed with the delete?")))) {
                    return;
                }
                IDOMElement facetElement = FacetSelectionAction.this.getFacetWithName(parent, facetName);
                if (facetElement != null && this.isChecked()) {
                    parent.removeChild((Node)facetElement);
                } else if (facetElement == null && !this.isChecked()) {
                    Document ownerDocument = parent.getOwnerDocument();
                    IDOMElement newFacetElement = (IDOMElement)ownerDocument.createElementNS(FacetSelectionAction.HTTP_JAVA_SUN_COM_JSF_CORE, FacetSelectionAction.ELEMENT_FACET);
                    String prefix = this.getPrefixForNs(ownerDocument, FacetSelectionAction.HTTP_JAVA_SUN_COM_JSF_CORE);
                    if (prefix == null) {
                        prefix = this.createNamespaceWithPrefix(ownerDocument, FacetSelectionAction.HTTP_JAVA_SUN_COM_JSF_CORE, "f");
                    }
                    newFacetElement.setPrefix(prefix);
                    newFacetElement.setAttribute(FacetSelectionAction.ATTR_NAME, facetName);
                    parent.appendChild((Node)newFacetElement);
                }
                new HTMLFormatter().format((Node)parent);
            }

            public String getText() {
                return FacetMessages.getString((String)super.getText());
            }

            private String createNamespaceWithPrefix(Document ownerDocument, String ns, String c) {
                IDOMElement documentElement = (IDOMElement)ownerDocument.getDocumentElement();
                documentElement.setAttribute("xmlns:" + c, ns);
                return c;
            }

            private String getPrefixForNs(Document ownerDocument, String ns) {
                NamedNodeMap attributes = ownerDocument.getDocumentElement().getAttributes();
                int i = 0;
                while (i < attributes.getLength()) {
                    Attr node = (Attr)attributes.item(i);
                    String prefix = node.getPrefix();
                    if (prefix != null && prefix.equalsIgnoreCase(FacetSelectionAction.XMLNS) && node.getValue().equals(ns)) {
                        return node.getLocalName();
                    }
                    ++i;
                }
                return null;
            }

            public boolean isChecked() {
                return FacetSelectionAction.this.hasFacetWithName(parent, facetName);
            }
        };
    }

    private boolean hasFacetWithName(IDOMElement element, String facetName) {
        return this.getFacetWithName(element, facetName) != null;
    }

    private boolean notEmptyFacet(IDOMElement element, String facetName) {
        IDOMElement facetElement = this.getFacetWithName(element, facetName);
        return facetElement.hasChildNodes();
    }

    private IDOMElement getFacetWithName(IDOMElement element, String facetName) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            String fName;
            IDOMNode node = (IDOMNode)nodes.item(i);
            if (node != null && node instanceof IDOMElement && ((IDOMElement)node).getLocalName().equals(ELEMENT_FACET) && (fName = ((IDOMElement)node).getAttribute(ATTR_NAME)) != null && fName.equals(facetName)) {
                return (IDOMElement)node;
            }
            ++i;
        }
        return null;
    }

    private boolean isFacetMenuEnabled() {
        IDOMElement selectedElement = this.getSelectedElement();
        return selectedElement != null;
    }

    private IDOMElement getSelectedElement() {
        ListOfValues values;
        ISelectionService selectionService;
        IDOMElement element;
        IWorkbenchWindow[] workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (workbenchWindows.length > 0 && (element = this.getMainElement((selectionService = workbenchWindows[0].getSelectionService()).getSelection())) != null && (values = this.getListOfValuesFor(element)) != null) {
            return element;
        }
        return null;
    }

    private IDOMElement getMainElement(ISelection selection) {
        Object element;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IDOMNode) {
            IDOMNode node = (IDOMNode)element;
            if (node instanceof IDOMText) {
                node = (IDOMNode)((IDOMText)node).getParentNode();
            }
            if (node instanceof IDOMAttr) {
                node = (IDOMElement)((IDOMAttr)node).getOwnerElement();
            }
            if (node instanceof IDOMElement) {
                if (node.getLocalName().equals(ELEMENT_FACET)) {
                    node = (IDOMElement)((IDOMElement)node).getParentNode();
                }
                return (IDOMElement)node;
            }
        }
        return null;
    }

    private ListOfValues getListOfValuesFor(IDOMElement element) {
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)element.getStructuredDocument(), element.getStartOffset());
        ListOfValues listOfValues = FacetMetadataUtil.getListOfValues((IDOMNode)element, (IStructuredDocumentContext)context);
        if (listOfValues != null && listOfValues.getEntries() != null && listOfValues.getEntries().size() > 0) {
            return listOfValues;
        }
        return null;
    }
}

