/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.refactoring;

import java.text.MessageFormat;
import oracle.eclipse.tools.webtier.jsf.ui.internal.Activator;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.ExternalizeWizardPage;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.Messages;
import oracle.eclipse.tools.webtier.jsf.ui.refactoring.NLSRefactoring;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ExternalizeRefactoringWizard
extends RefactoringWizard {
    private IFile jsfFile;

    public ExternalizeRefactoringWizard(Refactoring refactoring, IFile file) {
        super(refactoring, 3);
        this.setDefaultPageTitle(MessageFormat.format(Messages.ExternalizeWizardPage_title, file.getName()));
        this.setWindowTitle(Messages.ExternalizeWizard_name);
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_EXTERNALIZE_STRINGS);
        this.jsfFile = file;
    }

    protected void addUserInputPages() {
        NLSRefactoring nlsRefac = (NLSRefactoring)this.getRefactoring();
        ExternalizeWizardPage page = new ExternalizeWizardPage(nlsRefac, this.jsfFile);
        page.setMessage(Messages.ExternalizeWizard_select);
        this.addPage((IWizardPage)page);
    }

    public static void open(final IFile file, final Shell shell) {
        if (file == null || !file.exists()) {
            return;
        }
        Display display = shell != null ? shell.getDisplay() : Display.getCurrent();
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            @Override
            public void run() {
                RefactoringSaveHelper saveHelper = new RefactoringSaveHelper(1);
                saveHelper.saveEditors(shell);
                NLSRefactoring refactoring = NLSRefactoring.create(file);
                if (refactoring != null) {
                    RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)new ExternalizeRefactoringWizard(refactoring, file));
                    try {
                        int result = op.run(shell, Messages.ExternalizeRefactoringWizard_title);
                        if (result == 1 || result == 1025) {
                            saveHelper.triggerIncrementalBuild();
                        }
                    }
                    catch (InterruptedException e) {
                        Activator.log(e);
                    }
                }
            }
        });
    }
}

