/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.customedit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.util.INavigationCaseProvider;
import oracle.eclipse.tools.common.services.util.NavigationCaseDocumentServiceFactory;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.webtier.jsf.ui.Messages;
import oracle.eclipse.tools.webtier.jsf.ui.customedit.NavigationCaseToOutcomeConverter;
import oracle.eclipse.tools.webtier.jsf.ui.customedit.OutcomeToNavigationCaseConverter;
import oracle.eclipse.tools.xml.edit.ui.propeditor.PropertyEditorDialog;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.JSFAppConfigManagerFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FromOutcomeType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.emf.ToViewIdType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class SelectJSFNavigationCaseDialog
extends PropertyEditorDialog {
    private IDocument baseDoc;
    private IPath webContentPath;
    protected TableViewer tableViewer;
    private NavigationCaseTypeObservableValue intermediateValue;
    private static final String HELPID = "oracle.eclipse.tools.webtier.ui.ChooseNavigationCaseDialog";

    public SelectJSFNavigationCaseDialog(IShellProvider parentShellProvider, IObservableValue modelValue, IValidator validator, IDocument baseDoc) {
        super(parentShellProvider, Messages.SelectJSFNavigationCaseDialog_title, Messages.SelectJSFNavigationCaseDialog_instructions, (IObservable)modelValue, validator);
        this.baseDoc = baseDoc;
    }

    public SelectJSFNavigationCaseDialog(Shell parentShell, IObservableValue modelValue, IValidator validator, IDocument baseDoc) {
        super(parentShell, Messages.SelectJSFNavigationCaseDialog_title, Messages.SelectJSFNavigationCaseDialog_instructions, (IObservable)modelValue, validator);
        this.baseDoc = baseDoc;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, HELPID);
    }

    protected void bindData() {
        Object selection;
        this.intermediateValue = new NavigationCaseTypeObservableValue(null);
        this.validationBinding = this.context.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this.tableViewer), (IObservableValue)this.intermediateValue, new UpdateValueStrategy(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        this.updateModelBinding = this.context.bindValue((IObservableValue)this.modelObservable, (IObservableValue)this.intermediateValue, new UpdateValueStrategy().setConverter((IConverter)new OutcomeToNavigationCaseConverter((Viewer)this.tableViewer)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST).setConverter((IConverter)new NavigationCaseToOutcomeConverter()));
        this.updateModelBinding.updateTargetToModel();
        this.validationBinding.updateModelToTarget();
        if (this.tableViewer != null && !this.tableViewer.getControl().isDisposed() && (selection = this.tableViewer.getData(IStructuredSelection.class.getName())) instanceof IStructuredSelection) {
            this.tableViewer.setSelection((ISelection)((IStructuredSelection)selection));
        }
    }

    protected void bindOkButton(Button button) {
        this.context.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)button), (IObservableValue)new ComputedValue(this.context.getValidationRealm(), Boolean.class){

            protected Object calculate() {
                return SelectJSFNavigationCaseDialog.this.intermediateValue.getValue() instanceof NavigationCaseType;
            }
        }, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
    }

    protected Control createEditingArea(Composite parent) {
        Object key;
        Composite localParent = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(localParent);
        GridDataFactory.fillDefaults().grab(true, true).hint(400, 200).applyTo((Control)localParent);
        Composite tableComposite = new Composite(localParent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        Table table = new Table(tableComposite, 68356);
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                String text = item.getText(event.index);
                Point size = event.gc.textExtent(text);
                event.width = size.x + 2;
                event.height = Math.max(event.height, size.y + 1);
            }
        });
        table.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFEF;
            }
        });
        table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                String text = item.getText(event.index);
                Point size = event.gc.textExtent(text);
                int yOffset = Math.max(0, (event.height - size.y) / 2);
                event.gc.drawText(text, event.x + 1, event.y + yOffset, true);
            }
        });
        this.tableViewer = new TableViewer(table);
        TableColumnLayout layout = new TableColumnLayout();
        tableComposite.setLayout((Layout)layout);
        layout.setColumnData((Widget)new TableViewerColumn(this.tableViewer, 0).getColumn(), (ColumnLayoutData)new ColumnWeightData(35, true));
        layout.setColumnData((Widget)new TableViewerColumn(this.tableViewer, 0).getColumn(), (ColumnLayoutData)new ColumnWeightData(75, true));
        ArrayList<NavigationCaseType> navigationCaseTypes = new ArrayList<NavigationCaseType>();
        Map<String, List<Pair<NavigationCaseType, IFile>>> map = this.computeNavigationCaseMap(navigationCaseTypes);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new NavigationCaseMapLabelProvider().setMap(map));
        this.tableViewer.setSorter(new ViewerSorter());
        this.tableViewer.setInput((Object)navigationCaseTypes.toArray());
        if (this.modelObservable instanceof AbstractObservableValue && (key = ((AbstractObservableValue)this.modelObservable).getValue()) != null) {
            for (NavigationCaseType navigationCaseType : navigationCaseTypes) {
                if (!key.equals(this.getLabel(navigationCaseType))) continue;
                this.tableViewer.setData(IStructuredSelection.class.getName(), (Object)new StructuredSelection((Object)navigationCaseType));
                break;
            }
        }
        GridData viewerGridData = new GridData();
        viewerGridData.grabExcessHorizontalSpace = true;
        viewerGridData.grabExcessVerticalSpace = true;
        viewerGridData.horizontalAlignment = 4;
        viewerGridData.verticalAlignment = 4;
        viewerGridData.minimumHeight = 300;
        viewerGridData.minimumWidth = 300;
        this.tableViewer.getControl().setLayoutData((Object)viewerGridData);
        this.tableViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                SelectJSFNavigationCaseDialog.this.okPressed();
            }
        });
        table.pack();
        return localParent;
    }

    private Map<String, List<Pair<NavigationCaseType, IFile>>> computeNavigationCaseMap(Collection<NavigationCaseType> navigationCaseTypes) {
        IProject iProject;
        Project project;
        if (this.baseDoc != null && (project = this.baseDoc.getProject()) != null && (iProject = project.getEclipseProject()) != null) {
            IFile pageFile = this.baseDoc.getFile();
            HashMap<String, List<Pair<NavigationCaseType, IFile>>> map = new HashMap<String, List<Pair<NavigationCaseType, IFile>>>();
            try {
                INavigationCaseProvider provider = NavigationCaseDocumentServiceFactory.getNavigationCaseProvider((IFile)pageFile);
                if (provider != null) {
                    Collection navigationCases = provider.getFromNavigationCases();
                    for (IArtifact navigationCase : navigationCases) {
                        NavigationCaseType navigationCaseType;
                        IFile file = this.getFile(navigationCase);
                        if (file == null || (navigationCaseType = this.toNavigationRuleType(navigationCase, provider)) == null) continue;
                        String label = this.getLabel(navigationCaseType);
                        ArrayList<Pair> list = (ArrayList<Pair>)map.get(label);
                        if (list == null) {
                            list = new ArrayList<Pair>();
                            map.put(label, list);
                            navigationCaseTypes.add(navigationCaseType);
                        }
                        Pair pair = new Pair((Object)navigationCaseType, (Object)file);
                        list.add(pair);
                    }
                    if (!map.isEmpty()) {
                        return map;
                    }
                }
            }
            catch (Exception exception) {}
            IJSFAppConfigManager appConfigManager = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance((IProject)iProject);
            if (appConfigManager != null) {
                List navRules = appConfigManager.getNavigationRulesForPage(pageFile);
                for (NavigationRuleType navRule : navRules) {
                    for (Object object : navRule.getNavigationCase()) {
                        NavigationCaseType navigationCaseType = (NavigationCaseType)object;
                        String label = this.getLabel(navigationCaseType);
                        ArrayList<Pair> list = (ArrayList<Pair>)map.get(label);
                        if (list == null) {
                            list = new ArrayList<Pair>();
                            map.put(label, list);
                            navigationCaseTypes.add(navigationCaseType);
                        }
                        Pair pair = new Pair((Object)navigationCaseType, null);
                        list.add(pair);
                    }
                }
            }
            if (!map.isEmpty()) {
                return map;
            }
        }
        return Collections.emptyMap();
    }

    private IFile getFile(IArtifact artifact) {
        IResource resource;
        if (artifact != null && artifact.getLocation() != null && (resource = artifact.getLocation().getResource()) instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    private NavigationCaseType toNavigationRuleType(IArtifact navigationCase, INavigationCaseProvider provider) {
        FromOutcomeType outcomeType = FacesConfigFactory.eINSTANCE.createFromOutcomeType();
        outcomeType.setTextContent(navigationCase.getName());
        ToViewIdType toViewIdType = FacesConfigFactory.eINSTANCE.createToViewIdType();
        IArtifact toArtifact = provider.getToArtifact(navigationCase);
        if (toArtifact != null) {
            IResource resource = provider.getToArtifactResource(navigationCase, toArtifact);
            if (resource instanceof IFile) {
                toViewIdType.setTextContent(this.computeWebPath(resource.getProjectRelativePath()));
            } else {
                toViewIdType.setTextContent(toArtifact.getName());
            }
        }
        NavigationCaseType navigationCaseType = FacesConfigFactory.eINSTANCE.createNavigationCaseType();
        navigationCaseType.setFromOutcome(outcomeType);
        navigationCaseType.setToViewId(toViewIdType);
        return navigationCaseType;
    }

    protected void performModelBindingUpdate() {
        this.updateModelBinding.updateModelToTarget();
        this.triggerUnsetBindings();
    }

    private IPath getBaseDocProjectWebContentPath() {
        IVirtualFolder folder;
        IVirtualComponent component;
        IProject project;
        if (this.webContentPath == null && (project = this.baseDoc.getProject().getEclipseProject()) != null && (component = ComponentCore.createComponent((IProject)project)) != null && (folder = component.getRootFolder()) != null) {
            this.webContentPath = folder.getProjectRelativePath();
        }
        return this.webContentPath;
    }

    private String computeWebPath(IPath path) {
        String ret = null;
        IPath webPath = this.getBaseDocProjectWebContentPath();
        if (webPath != null && !(ret = (path = path.makeRelativeTo(webPath)).toString()).startsWith("/")) {
            ret = "/" + ret;
        }
        return ret;
    }

    private String getLabel(NavigationCaseType navigationCaseType) {
        if (navigationCaseType != null && navigationCaseType.getFromOutcome() != null) {
            return navigationCaseType.getFromOutcome().getTextContent();
        }
        return Messages.unknownOutcomeElement;
    }

    private class NavigationCaseMapLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Map<String, List<Pair<NavigationCaseType, IFile>>> map;

        private NavigationCaseMapLabelProvider() {
        }

        public NavigationCaseMapLabelProvider setMap(Map<String, List<Pair<NavigationCaseType, IFile>>> map) {
            this.map = map;
            return this;
        }

        public String getText(Object element) {
            return SelectJSFNavigationCaseDialog.this.getLabel((NavigationCaseType)element);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String label = this.getText(element);
            switch (columnIndex) {
                case 0: {
                    return label;
                }
                case 1: {
                    ArrayList<String> cellRows = new ArrayList<String>(this.map.get(label).size());
                    for (Pair<NavigationCaseType, IFile> pair : this.map.get(label)) {
                        StringBuilder cellRow = new StringBuilder();
                        if (pair.getSecond() == null) {
                            cellRow.append(Messages.facesConfiguration);
                        } else {
                            cellRow.append(SelectJSFNavigationCaseDialog.this.computeWebPath(((IFile)pair.getSecond()).getProjectRelativePath()));
                        }
                        if (((NavigationCaseType)pair.getFirst()).getToViewId() != null && ((NavigationCaseType)pair.getFirst()).getToViewId().getTextContent() != null) {
                            cellRow.append(" - ");
                            cellRow.append(((NavigationCaseType)pair.getFirst()).getToViewId().getTextContent());
                        }
                        cellRows.add(cellRow.toString());
                    }
                    Collections.sort(cellRows);
                    StringBuilder cellText = new StringBuilder();
                    for (String s : cellRows) {
                        cellText.append(" \n").append(s);
                    }
                    return cellText.substring(2);
                }
            }
            return null;
        }
    }

    private static class NavigationCaseTypeObservableValue
    extends WritableValue {
        public NavigationCaseTypeObservableValue(NavigationCaseType navCase) {
            super((Object)navCase, NavigationCaseType.class);
        }
    }
}

