/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.converter;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.webtier.jsf.ui.converter.NewConverterDialog;
import oracle.eclipse.tools.webtier.jsf.ui.util.JsfUiUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.JSFAppConfigManagerFactory;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterForClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NewConverterAction
extends Action {
    private IProject project;

    public void run() {
        String facesConfigFilename;
        if (this.project == null) {
            throw new IllegalArgumentException("Was expecting a valid non-null project");
        }
        try {
            facesConfigFilename = JsfUiUtil.getFacesConfigFile(this.project, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        if (facesConfigFilename != null) {
            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            ConverterType converter = this.createConverter();
            NewConverterDialog dialog = new NewConverterDialog(shell, this.project, converter, this.getExistingConverterIds(), this.getExistingConverterForClasses());
            switch (dialog.open()) {
                case 0: {
                    this.updateFacesConfigFile(facesConfigFilename, converter);
                }
            }
        }
    }

    private List<String> getExistingConverterIds() {
        IJSFAppConfigManager appConfigManager;
        ArrayList<String> existingConverterIds = new ArrayList<String>();
        if (this.project != null && (appConfigManager = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance((IProject)this.project)) != null) {
            List converters = appConfigManager.getConverters();
            for (ConverterType converterType : converters) {
                String converterId;
                ConverterIdType converterIdType = converterType.getConverterId();
                if (converterIdType == null || (converterId = converterIdType.getTextContent()) == null) continue;
                existingConverterIds.add(converterId.trim());
            }
        }
        return existingConverterIds;
    }

    private List<String> getExistingConverterForClasses() {
        IJSFAppConfigManager appConfigManager;
        ArrayList<String> existingConverterForClasses = new ArrayList<String>();
        if (this.project != null && (appConfigManager = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance((IProject)this.project)) != null) {
            List converters = appConfigManager.getConverters();
            for (ConverterType converterType : converters) {
                String converterForClass;
                ConverterForClassType converterForClassType = converterType.getConverterForClass();
                if (converterForClassType == null || (converterForClass = converterForClassType.getTextContent()) == null) continue;
                existingConverterForClasses.add(converterForClass.trim());
            }
        }
        return existingConverterForClasses;
    }

    public void selectionChanged(ISelection selection) {
        Object firstSegment;
        TreeSelection treeSelection;
        TreePath[] treePaths;
        if (selection instanceof TreeSelection && (treePaths = (treeSelection = (TreeSelection)selection).getPaths()) != null && treePaths.length > 0 && (firstSegment = treePaths[0].getFirstSegment()) instanceof IProject) {
            this.project = (IProject)firstSegment;
        }
    }

    private ConverterType createConverter() {
        ConverterType converter = FacesConfigFactory.eINSTANCE.createConverterType();
        converter.setConverterId(FacesConfigFactory.eINSTANCE.createConverterIdType());
        converter.setConverterClass(FacesConfigFactory.eINSTANCE.createConverterClassType());
        converter.getDescription().add((Object)FacesConfigFactory.eINSTANCE.createDescriptionType());
        converter.setConverterForClass(FacesConfigFactory.eINSTANCE.createConverterForClassType());
        return converter;
    }

    private void updateFacesConfigFile(String facesConfigFilename, ConverterType converter) {
        FacesConfigArtifactEdit facesConfigEdit = null;
        try {
            DescriptionType description;
            String descriptionString;
            facesConfigEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)this.project, (String)facesConfigFilename);
            if (converter.getConverterId().getTextContent() == null) {
                converter.setConverterId(null);
            }
            if (converter.getConverterForClass().getTextContent() == null) {
                converter.setConverterForClass(null);
            }
            if ((descriptionString = (description = (DescriptionType)converter.getDescription().get(0)).getTextContent()) == null || descriptionString.trim().length() == 0) {
                converter.getDescription().clear();
            }
            facesConfigEdit.getFacesConfig().getConverter().add((Object)converter);
            JsfUiUtil.save(facesConfigEdit);
        }
        finally {
            if (facesConfigEdit != null) {
                facesConfigEdit.dispose();
                assert (facesConfigEdit.isDisposed());
                facesConfigEdit = null;
            }
        }
    }
}

