/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsf.ui.config;

import oracle.eclipse.tools.webtier.jsf.ui.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.jsp.ui.internal.wizard.NewJSPWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.wst.common.componentcore.ComponentCore;

public class MyNewJSPWizard
extends NewJSPWizard {
    private String _fileName;
    private final IProject _project;
    private IPath _webContentRelativePath;
    private final String _initialPageName;
    private WizardNewFileCreationPage _page;
    private static final String FORWARD_SLASH = "/";

    public MyNewJSPWizard(IProject project, String initialPageName) {
        this._project = project;
        this._initialPageName = this.stripInitialSlashIfNecessary(initialPageName);
    }

    private String stripInitialSlashIfNecessary(String initialPageName) {
        if (initialPageName == null || initialPageName.trim().equals("")) {
            return "";
        }
        if (initialPageName.substring(0, 1).equals(FORWARD_SLASH)) {
            return initialPageName.substring(1);
        }
        return initialPageName;
    }

    public boolean performFinish() {
        boolean status = super.performFinish();
        return status &= this.setFileNameFromWizard();
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this._page = (WizardNewFileCreationPage)this.getPage("JSPWizardNewFileCreationPage");
        this._page.setFileName(this._initialPageName);
        this._page.setContainerFullPath(this.getWebContentFolderPath());
    }

    private IPath getWebContentFolderPath() {
        IFolder webContentFolder = (IFolder)ComponentCore.createComponent((IProject)this._project).getRootFolder().getUnderlyingFolder();
        if (webContentFolder != null) {
            return webContentFolder.getFullPath();
        }
        return this._project.getFullPath();
    }

    private boolean setFileNameFromWizard() {
        IPath path = this._page.getContainerFullPath();
        boolean valid = this.validatePath(path);
        if (valid) {
            this._fileName = FORWARD_SLASH + this._webContentRelativePath.append(this._page.getFileName()).toString();
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean validatePath(IPath filePath) {
        if (filePath == null) return false;
        if (filePath.isEmpty()) return false;
        if (filePath.segmentCount() < 2) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.JSFConfigAddNavigationCaseDialog_invalidLocationTitle, (String)Messages.JSFConfigAddNavigationCaseDialog_invalidLocationMsg);
            return false;
        }
        String projectSegment = filePath.segments()[0];
        String webContentSegment = filePath.segments()[1];
        if (!projectSegment.equals(this._project.getName())) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.JSFConfigAddNavigationCaseDialog_incorrectProjectTitle, (String)Messages.JSFConfigAddNavigationCaseDialog_incorrectProjectMsg);
            return false;
        }
        IFile webXMLPath = this._project.getFile(new Path(webContentSegment).append("WEB-INF/web.xml"));
        if (!webXMLPath.exists()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.JSFConfigAddNavigationCaseDialog_invalidLocationTitle, (String)Messages.JSFConfigAddNavigationCaseDialog_invalidLocationMsg);
            return false;
        }
        this._webContentRelativePath = filePath.removeFirstSegments(2);
        return true;
    }

    public String getFileName() {
        return this._fileName;
    }
}

